/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.OrderedPairlist;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StandardBaseSeq<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(StandardBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    public final ReductionSeq<C> red;

    public StandardBaseSeq() {
        this(new ReductionSeq());
    }

    public StandardBaseSeq(ReductionSeq<C> red) {
        this.red = red;
    }

    public boolean isSTD(List<MultiVarPowerSeries<C>> F2) {
        return this.isSTD(0, F2);
    }

    public boolean isSTD(int modv, List<MultiVarPowerSeries<C>> F2) {
        if (F2 == null) {
            return true;
        }
        int i = 0;
        while (i < F2.size()) {
            MultiVarPowerSeries<C> pi = F2.get(i);
            int j = i + 1;
            while (j < F2.size()) {
                MultiVarPowerSeries<C> h;
                MultiVarPowerSeries<C> s;
                MultiVarPowerSeries<C> pj = F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj) && !(s = this.red.SPolynomial(pi, pj)).isZERO() && !(h = this.red.normalform(F2, s)).isZERO()) {
                    System.out.println("pi = " + pi + ", pj = " + pj);
                    System.out.println("s  = " + s + ", h = " + h);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public List<MultiVarPowerSeries<C>> STD(List<MultiVarPowerSeries<C>> F2) {
        return this.STD(0, F2);
    }

    /*
     * Unable to fully structure code
     */
    public List<MultiVarPowerSeries<C>> STD(int modv, List<MultiVarPowerSeries<C>> F) {
        p = null;
        G = new ArrayList<MultiVarPowerSeries<C>>();
        pairlist = null;
        l = F.size();
        it = F.listIterator();
        while (it.hasNext()) {
            p = it.next();
            if (!p.isZERO()) {
                if (p.isUnit()) {
                    G.clear();
                    G.add(p);
                    return G;
                }
                G.add(p);
                if (pairlist == null) {
                    pairlist = new OrderedPairlist<C>(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l > 1) ** GOTO lbl58
        return G;
lbl-1000:
        // 1 sources

        {
            pair = pairlist.removeNext();
            if (pair == null) continue;
            pi = pair.pi;
            pj = pair.pj;
            if (this.debug) {
                StandardBaseSeq.logger.debug((Object)("pi    = " + pi));
                StandardBaseSeq.logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (StandardBaseSeq.logger.isInfoEnabled()) {
                es = S.orderExpVector();
                StandardBaseSeq.logger.info((Object)("ht(S) = " + es.toString(S.ring.vars) + ", " + es));
            }
            if ((H = this.red.normalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (StandardBaseSeq.logger.isInfoEnabled()) {
                eh = H.orderExpVector();
                StandardBaseSeq.logger.info((Object)("ht(H) = " + eh.toString(S.ring.vars) + ", " + eh));
            }
            if (H.isUnit()) {
                G.clear();
                G.add(H);
                return G;
            }
            if (StandardBaseSeq.logger.isDebugEnabled()) {
                StandardBaseSeq.logger.info((Object)("H = " + H));
            }
            ++l;
            G.add(H);
            pairlist.put(H);
lbl58:
            // 5 sources

            ** while (pairlist.hasNext())
        }
lbl59:
        // 1 sources

        StandardBaseSeq.logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalSTD(G);
        StandardBaseSeq.logger.info((Object)("" + pairlist));
        return G;
    }

    public List<MultiVarPowerSeries<C>> minimalSTD(List<MultiVarPowerSeries<C>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<MultiVarPowerSeries<C>> G = new ArrayList<MultiVarPowerSeries<C>>(Gp.size());
        for (MultiVarPowerSeries<C> a : Gp) {
            if (a == null || a.isZERO()) continue;
            a = a.monic();
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            MultiVarPowerSeries<C> a;
            a = (MultiVarPowerSeries<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<MultiVarPowerSeries<C>> ff = new ArrayList<MultiVarPowerSeries<C>>(G);
                ff.addAll(F2);
                a = this.red.normalform(ff, a);
                if (a.isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        return G;
    }
}

