/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.Element;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnivPowerSeriesTest
extends TestCase {
    UnivPowerSeriesRing<BigRational> fac;
    UnivPowerSeries<BigRational> a;
    UnivPowerSeries<BigRational> b;
    UnivPowerSeries<BigRational> c;
    UnivPowerSeries<BigRational> d;
    UnivPowerSeries<BigRational> e;
    int kl = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)UnivPowerSeriesTest.suite());
    }

    public UnivPowerSeriesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(UnivPowerSeriesTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new UnivPowerSeriesRing<BigRational>(new BigRational(1L));
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        UnivPowerSeriesTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        UnivPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        UnivPowerSeriesTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        UnivPowerSeriesTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 5) {
            this.a = this.fac.random(i + 2);
            UnivPowerSeriesTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            UnivPowerSeriesTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        UnivPowerSeriesTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.d = this.c.subtract(this.b);
        UnivPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.sum(this.b.sum(this.c));
        this.e = this.a.sum(this.b).sum(this.c);
        UnivPowerSeriesTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        UnivPowerSeriesTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        UnivPowerSeriesTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        UnivPowerSeriesTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        UnivPowerSeriesTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        UnivPowerSeriesTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        UnivPowerSeriesTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testQuotRem() {
        this.fac = new UnivPowerSeriesRing<BigRational>(new BigRational(1L));
        this.a = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        UnivPowerSeries<BigRational> h = this.a;
        Element g = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( g )", (!((UnivPowerSeries)g).isZERO() ? 1 : 0) != 0);
        this.a = this.a.multiply((UnivPowerSeries<BigRational>)g);
        this.b = this.b.multiply((UnivPowerSeries<BigRational>)g);
        this.c = this.a.gcd(this.b);
        UnivPowerSeriesTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        UnivPowerSeriesTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
    }

    public void testEvaluation() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        BigRational fv = new BigRational(0L);
        BigRational v = fv.random(this.kl);
        BigRational av = this.a.evaluate(v);
        BigRational bv = this.b.evaluate(v);
        this.c = this.a.sum(this.b);
        BigRational cv = this.c.evaluate(v);
        BigRational dv = av.sum(bv);
        UnivPowerSeriesTest.assertEquals((String)"a(v)+b(v) = (a+b)(v) ", (Object)cv, (Object)dv);
        this.c = this.fac.getZERO();
        cv = this.c.evaluate(v);
        dv = fv.getZERO();
        UnivPowerSeriesTest.assertEquals((String)"0(v) = 0 ", (Object)cv, (Object)dv);
        this.c = this.fac.getONE();
        cv = this.c.evaluate(v);
        dv = fv.getONE();
        UnivPowerSeriesTest.assertEquals((String)"1(v) = 1 ", (Object)cv, (Object)dv);
    }

    public void testTaylor() {
        BigRational br = new BigRational(0L);
        GenPolynomialRing<BigRational> pr = this.fac.polyRing();
        GenPolynomial<BigRational> p = pr.random(this.kl, 3, 3, this.q + this.q);
        System.out.println("p   = " + p);
        PolynomialTaylorFunction<BigRational> F2 = new PolynomialTaylorFunction<BigRational>(p);
        UnivPowerSeriesRing<BigRational> psr = new UnivPowerSeriesRing<BigRational>(pr);
        UnivPowerSeries<BigRational> ps = this.fac.seriesOfTaylor(F2, br);
        UnivPowerSeries<BigRational> pps = this.fac.fromPolynomial(p);
        UnivPowerSeriesTest.assertEquals((String)"taylor(p) == p", ps, pps);
        for (GenPolynomial<BigRational> g : pr.generators()) {
            F2 = new PolynomialTaylorFunction<BigRational>(g);
            ps = this.fac.seriesOfTaylor(F2, br);
            System.out.println("g   = " + g);
            System.out.println("ps  = " + ps);
            pps = this.fac.fromPolynomial(g);
            System.out.println("pps = " + pps);
            UnivPowerSeriesTest.assertEquals((String)"taylor(p) == p", ps, pps);
        }
    }
}

