/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;

public class Boundary<C extends RingElem<C> & Rational> {
    public final Rectangle<C> rect;
    public final GenPolynomial<Complex<C>> A;
    public final GenPolynomial<Complex<C>>[] polys;
    public final GreatestCommonDivisorAbstract<Complex<C>> ufd;
    GenPolynomialRing<C> rfac;

    public Boundary(Rectangle<C> r, GenPolynomial<Complex<C>> p) throws InvalidBoundaryException {
        this.rect = r;
        this.A = p;
        this.ufd = GCDFactory.getImplementation(this.A.ring.coFac);
        this.polys = new GenPolynomial[5];
        Complex<C>[] corner = this.rect.corners;
        int i = 0;
        while (i < 4) {
            Complex t = corner[i + 1].subtract(corner[i]);
            GenPolynomial tp = this.A.ring.univariate(0, 1L).multiply(t);
            GenPolynomial<Complex<Complex<C>>> pc = PolyUtil.seriesOfTaylor(this.A, corner[i]);
            GenPolynomial gcd = this.ufd.gcd(this.A, pc = PolyUtil.substituteUnivariate(pc, tp));
            if (!gcd.isONE()) {
                throw new InvalidBoundaryException("A has a zero on rectangle " + this.rect);
            }
            this.polys[i] = pc;
            ++i;
        }
        this.polys[4] = this.polys[0];
        ComplexRing cr = (ComplexRing)this.A.ring.coFac;
        RingFactory cf = cr.ring;
        this.rfac = new GenPolynomialRing(cf, this.A.ring);
    }

    protected Boundary(Rectangle<C> r, GenPolynomial<Complex<C>> p, GenPolynomial<Complex<C>>[] b) {
        this.rect = r;
        this.A = p;
        this.polys = b;
        this.ufd = GCDFactory.getImplementation(this.A.ring.coFac);
    }

    public String toString() {
        return this.rect.toString();
    }

    public String toScript() {
        return this.rect.toScript();
    }

    public GenPolynomial<C> getRealPart(int i) {
        GenPolynomial<C> f = PolyUtil.realPartFromComplex(this.rfac, this.polys[i]);
        return f;
    }

    public GenPolynomial<C> getImagPart(int i) {
        GenPolynomial<C> g = PolyUtil.imaginaryPartFromComplex(this.rfac, this.polys[i]);
        return g;
    }

    public Boundary<C> clone() {
        return new Boundary<C>(this.rect, this.A, this.polys);
    }

    public boolean equals(Object b) {
        if (!(b instanceof Boundary)) {
            return false;
        }
        Boundary a = null;
        try {
            a = (Boundary)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.rect.equals(a.rect) && this.A.equals(a.A);
    }

    public int hashCode() {
        int hc = 0;
        return 37 * (hc += 37 * this.rect.hashCode()) + this.A.hashCode();
    }
}

