/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.Rectangle;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.StarRingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ComplexAlgebraicTest
extends TestCase {
    ComplexAlgebraicRing<BigRational> fac;
    GenPolynomialRing<Complex<BigRational>> mfac;
    ComplexAlgebraicNumber<BigRational> a;
    ComplexAlgebraicNumber<BigRational> b;
    ComplexAlgebraicNumber<BigRational> c;
    ComplexAlgebraicNumber<BigRational> d;
    ComplexAlgebraicNumber<BigRational> e;
    ComplexAlgebraicNumber<BigRational> alpha;
    int rl = 1;
    int kl = 10;
    int ll;
    int el = this.ll = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ComplexAlgebraicTest.suite());
    }

    public ComplexAlgebraicTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ComplexAlgebraicTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        ComplexRing<BigRational> cfac = new ComplexRing<BigRational>(new BigRational(1L));
        Complex<BigRational> im = cfac.getIMAG();
        BigRational rfac = new BigRational();
        BigRational two = new BigRational(2L);
        Complex<BigRational> nw = new Complex<BigRational>(cfac, rfac.getZERO(), two);
        Complex<BigRational> sw = new Complex<BigRational>(cfac, rfac.getZERO(), rfac.getZERO());
        Complex<BigRational> se = new Complex<BigRational>(cfac, two, rfac.getZERO());
        Complex<BigRational> ne = new Complex<BigRational>(cfac, two, two);
        Rectangle<BigRational> positiv = new Rectangle<BigRational>(nw, sw, se, ne);
        String[] vars = new String[]{"alpha"};
        this.mfac = new GenPolynomialRing<BigRational>(cfac, this.rl, vars);
        Complex<BigRational> r1 = ((Complex)cfac.fromInteger(1L)).sum(im);
        StarRingElem r2 = r1.conjugate();
        GenPolynomial mo = this.mfac.univariate(0, 1L);
        mo = mo.subtract(r1).multiply((Complex<BigRational>)((Object)mo.subtract((Complex<BigRational>)r2)));
        this.fac = new ComplexAlgebraicRing<BigRational>(mo, positiv);
        this.alpha = this.fac.getGenerator();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.alpha = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ComplexAlgebraicTest.assertTrue((String)"length( c ) = 1", (this.c.number.getVal().length() == 1 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ComplexAlgebraicTest.assertTrue((String)"length( d ) = 0", (this.d.number.getVal().length() == 0 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ComplexAlgebraicTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.el);
            if (!this.a.isZERO() && !this.a.isONE()) {
                ComplexAlgebraicTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.number.getVal().length() >= 0 ? 1 : 0) != 0);
                ComplexAlgebraicTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                ComplexAlgebraicTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        ComplexAlgebraicTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ComplexAlgebraicTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        ComplexAlgebraicTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((ComplexAlgebraicNumber<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((ComplexAlgebraicNumber<BigRational>)this.fac.getZERO());
        ComplexAlgebraicTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((ComplexAlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((ComplexAlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        ComplexAlgebraicTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        ComplexAlgebraicTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        ComplexAlgebraicTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ComplexAlgebraicTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        ComplexAlgebraicTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ComplexAlgebraicTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ComplexAlgebraicTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ComplexAlgebraicTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ComplexAlgebraicTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((ComplexAlgebraicNumber<BigRational>)this.fac.getONE());
        this.d = ((ComplexAlgebraicNumber)this.fac.getONE()).multiply(this.a);
        ComplexAlgebraicTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply(this.a);
        ComplexAlgebraicTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((ComplexAlgebraicNumber)this.fac.getZERO()).inverse();
        }
        catch (NotInvertibleException expected) {
            return;
        }
        ComplexAlgebraicTest.fail((String)"0 invertible");
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        ComplexAlgebraicTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testCompare() {
        this.a = ((ComplexAlgebraicNumber)this.fac.random(this.ll)).abs();
        this.b = this.a.sum((ComplexAlgebraicNumber<BigRational>)this.fac.getONE());
        this.c = this.b.sum((ComplexAlgebraicNumber<BigRational>)this.fac.getONE());
        int ab = this.a.compareTo(this.b);
        int bc = this.b.compareTo(this.c);
        int ac = this.a.compareTo(this.c);
        ComplexAlgebraicTest.assertTrue((String)"a < a+1 ", (ab < 0 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (bc < 0 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"a < a+2 ", (ac < 0 ? 1 : 0) != 0);
        this.a = this.a.negate();
        this.b = this.a.sum((ComplexAlgebraicNumber<BigRational>)this.fac.getONE());
        this.c = this.b.sum((ComplexAlgebraicNumber<BigRational>)this.fac.getONE());
        ab = this.a.compareTo(this.b);
        bc = this.b.compareTo(this.c);
        ac = this.a.compareTo(this.c);
        ComplexAlgebraicTest.assertTrue((String)"a < a+1 ", (ab < 0 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (bc < 0 ? 1 : 0) != 0);
        ComplexAlgebraicTest.assertTrue((String)"a < a+2 ", (ac < 0 ? 1 : 0) != 0);
    }
}

