/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexRootsAbstract;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.Rectangle;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ComplexRootTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<Complex<BigRational>> dfac;
    ComplexRing<BigRational> cfac;
    BigRational eps;
    GenPolynomial<Complex<BigRational>> a;
    GenPolynomial<Complex<BigRational>> b;
    GenPolynomial<Complex<BigRational>> c;
    GenPolynomial<Complex<BigRational>> d;
    GenPolynomial<Complex<BigRational>> e;
    int rl = 1;
    int kl = 3;
    int ll = 3;
    int el = 5;
    float q = 0.7f;

    public static void main(String[] args) {
        TestRunner.run((Test)ComplexRootTest.suite());
        ComputerThreads.terminate();
    }

    public ComplexRootTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ComplexRootTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new ComplexRing<BigRational>(new BigRational(1L));
        String[] vars = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(this.cfac, this.rl, this.to, vars);
        this.eps = Power.positivePower(new BigRational(1L, 10L), 50L);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.dfac = null;
        this.cfac = null;
        this.eps = null;
    }

    public void testRootBound() {
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.dfac.getONE());
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex Mb = cr.rootBound(this.a);
        BigRational M = (BigRational)Mb.getRe();
        ComplexRootTest.assertTrue((String)"M >= 1 ", (M.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
        this.a = this.a.multiply((Complex<BigRational>)this.dfac.fromInteger(5L));
        M = (BigRational)cr.rootBound(this.a).getRe();
        ComplexRootTest.assertTrue((String)"M >= 1 ", (M.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
    }

    public void testCauchyIndex() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
        BigRational l = new BigRational(0L);
        BigRational r = new BigRational(1L);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(l, this.dfac);
        ComplexRootsSturm<BigRational> cr = new ComplexRootsSturm<BigRational>(this.cfac);
        GenPolynomial<BigRational> f = PolyUtil.realPartFromComplex(fac, this.a);
        GenPolynomial<BigRational> g = PolyUtil.imaginaryPartFromComplex(fac, this.b);
        long ci = cr.indexOfCauchy(l, r, g, f);
        ComplexRootTest.assertTrue((String)"ci >= 0 ", (ci >= -this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testRouth() {
        GenPolynomial<BigRational> g;
        GenPolynomialRing<BigRational> fac;
        GenPolynomial<BigRational> f;
        BigRational pinf;
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> I2 = this.cfac.getIMAG();
        GenPolynomial<Complex<BigRational>> X = this.dfac.univariate(0);
        this.b = X.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(I2.negate())));
        this.c = X.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(I2.multiply((Complex<BigRational>)this.cfac.fromInteger(3L)))));
        this.d = X.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(I2.multiply((Complex<BigRational>)this.cfac.fromInteger(4L)))));
        this.e = X.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(I2.multiply((Complex<BigRational>)this.cfac.fromInteger(5L)))));
        this.a = this.b.multiply((Complex<BigRational>)((Object)this.c)).multiply(this.d).multiply(this.e);
        Complex Mb = cr.rootBound(this.a);
        BigRational M = (BigRational)Mb.getRe();
        BigRational minf = M.negate();
        long[] ri = cr.indexOfRouth(minf, pinf = M, f = PolyUtil.realPartFromComplex(fac = new GenPolynomialRing<BigRational>(pinf, this.dfac), this.a), g = PolyUtil.imaginaryPartFromComplex(fac, this.a));
        long deg = ri[0] + ri[1];
        ComplexRootTest.assertTrue((String)"sum(ri) == deg(a) ", (deg >= this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testWindingNumber() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> I2 = this.cfac.getIMAG();
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Complex Mb = cr.rootBound(this.a);
        BigRational M = (BigRational)Mb.getRe();
        BigRational eps = new BigRational(1L, 1000L);
        Complex[] corner = new Complex[]{new Complex<BigRational>(this.cfac, M.negate(), M), new Complex<BigRational>(this.cfac, M.negate(), M.negate()), new Complex<BigRational>(this.cfac, M, M.negate()), new Complex<BigRational>(this.cfac, M, M)};
        long v = 0L;
        try {
            v = cr.windingNumber(new Rectangle(corner), this.a);
        }
        catch (InvalidBoundaryException e) {
            ComplexRootTest.fail((String)("" + e));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 2 ", (v == 2L ? 1 : 0) != 0);
        corner[0] = new Complex<BigRational>(this.cfac, M.negate(), M);
        corner[1] = new Complex<BigRational>(this.cfac, M.negate(), eps);
        corner[2] = new Complex<BigRational>(this.cfac, M, eps);
        corner[3] = new Complex<BigRational>(this.cfac, M, M);
        try {
            v = cr.windingNumber(new Rectangle(corner), this.a);
        }
        catch (InvalidBoundaryException e) {
            ComplexRootTest.fail((String)("" + e));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 1 ", (v == 1L ? 1 : 0) != 0);
        corner[0] = new Complex<BigRational>(this.cfac, eps.negate(), eps);
        corner[1] = new Complex<BigRational>(this.cfac, eps.negate(), eps.negate());
        corner[2] = new Complex<BigRational>(this.cfac, eps, eps.negate());
        corner[3] = new Complex<BigRational>(this.cfac, eps, eps);
        try {
            v = cr.windingNumber(new Rectangle(corner), this.a);
        }
        catch (InvalidBoundaryException e) {
            ComplexRootTest.fail((String)("" + e));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 0 ", (v == 0L ? 1 : 0) != 0);
    }

    public void testComplexRootsImag() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> I2 = this.cfac.getIMAG();
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Complex Mb = cr.rootBound(this.a);
        BigRational M = (BigRational)Mb.getRe();
        Complex[] corner = new Complex[]{new Complex<BigRational>(this.cfac, M.negate(), M), new Complex<BigRational>(this.cfac, M.negate(), M.negate()), new Complex<BigRational>(this.cfac, M, M.negate()), new Complex<BigRational>(this.cfac, M, M)};
        Rectangle rect = new Rectangle(corner);
        List roots = null;
        try {
            roots = ((ComplexRootsAbstract)cr).complexRoots(rect, this.a);
        }
        catch (InvalidBoundaryException e) {
            ComplexRootTest.fail((String)("" + e));
        }
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootsRand() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> I2 = this.cfac.getIMAG();
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        SquarefreeAbstract<BigRational> engine = SquarefreeFactory.getImplementation(this.cfac);
        this.a = engine.squarefreePart(this.a);
        Complex Mb = cr.rootBound(this.a);
        BigRational M = (BigRational)Mb.getRe();
        Complex[] corner = new Complex[]{new Complex<BigRational>(this.cfac, M.negate(), M), new Complex<BigRational>(this.cfac, M.negate(), M.negate()), new Complex<BigRational>(this.cfac, M, M.negate()), new Complex<BigRational>(this.cfac, M, M)};
        Rectangle rect = new Rectangle(corner);
        List roots = null;
        try {
            roots = ((ComplexRootsAbstract)cr).complexRoots(rect, this.a);
        }
        catch (InvalidBoundaryException e) {
            ComplexRootTest.fail((String)("" + e));
        }
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRoots() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 1, this.q);
        List roots = cr.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootRefinement() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        SquarefreeAbstract<BigRational> engine = SquarefreeFactory.getImplementation(this.cfac);
        this.a = engine.squarefreePart(this.a);
        List roots = cr.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
        BigRational len = new BigRational(1L, 1000L);
        for (Rectangle root : roots) {
            try {
                Rectangle refine = cr.complexRootRefinement(root, this.a, len);
            }
            catch (InvalidBoundaryException e) {
                ComplexRootTest.fail((String)("" + e));
            }
        }
    }

    public void testComplexRootRefinementFull() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        BigRational len = new BigRational(1L, 1000L);
        List refine = cr.complexRoots(this.a, len);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)refine.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testWindingNumberWrong() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> I2 = this.cfac.getIMAG();
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Element Mb = this.cfac.fromInteger(1L);
        BigRational M = (BigRational)((Complex)Mb).getRe();
        BigRational eps = new BigRational(1L, 1000L);
        BigRational zero = new BigRational();
        BigRational one = new BigRational(1L);
        Complex[] corner = new Complex[]{new Complex<BigRational>(this.cfac, M.negate(), M), new Complex<BigRational>(this.cfac, M.negate(), zero), new Complex<BigRational>(this.cfac, M, zero), new Complex<BigRational>(this.cfac, M, M)};
        Rectangle rect = new Rectangle(corner);
        try {
            long v = cr.windingNumber(rect, this.a);
            System.out.println("winding number = " + v);
            ComplexRootTest.fail((String)"wind(rect,a) must throw an exception");
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            // empty catch block
        }
    }

    public void testComplexRootApproximation() {
        ComplexRootsSturm cr = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.parse("( ( x^4-2 ) )");
        this.b = this.dfac.parse("( (x-1)*(x-2)*(x-3) )");
        this.c = this.dfac.parse("( x^4-2 )");
        this.d = this.dfac.parse("( (x - { 0i1 })*(x-5) )");
        SquarefreeAbstract<BigRational> engine = SquarefreeFactory.getImplementation(this.cfac);
        this.a = engine.squarefreePart(this.a);
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        List roots = cr.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Rectangle root : roots) {
            try {
                Complex<BigDecimal> cd = cr.approximateRoot(root, this.a, this.eps);
            }
            catch (NoConvergenceException noConvergenceException) {
                // empty catch block
            }
        }
    }

    public void testComplexRootApproximationFull() {
        ComplexRootsSturm<BigRational> cr = new ComplexRootsSturm<BigRational>(this.cfac);
        this.a = this.dfac.parse("( (x-2)*( x^4-2 ) )");
        this.b = this.dfac.parse("( (x-1)*(x-2)*(x-3) )");
        this.c = this.dfac.parse("( x^4-2 )");
        this.d = this.dfac.parse("( (x - { 0i1 })*(x-5) )");
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        List<Complex<BigDecimal>> roots = cr.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootApproximationWilkinsonFull() {
        int N2 = 4;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        BigDecimal br = new BigDecimal();
        ComplexRing<BigDecimal> cf = new ComplexRing<BigDecimal>(br);
        Complex<BigDecimal> I2 = cf.getIMAG();
        Complex<BigDecimal> cc = null;
        Complex<BigRational> Ir = this.cfac.getIMAG();
        ArrayList<Complex<BigDecimal>> Rn = new ArrayList<Complex<BigDecimal>>(4);
        this.a = this.d;
        int i = 0;
        while (i < 4) {
            cc = ((Complex)cf.fromInteger(i)).multiply(I2);
            Rn.add(cc);
            this.c = ((GenPolynomial)this.dfac.fromInteger(i)).multiply(Ir);
            this.b = this.e.subtract((Complex<BigRational>)((Object)this.c));
            this.a = this.a.multiply((Complex<BigRational>)((Object)this.b));
            ++i;
        }
        Collections.reverse(Rn);
        ComplexRootsSturm<BigRational> cr = new ComplexRootsSturm<BigRational>(this.cfac);
        this.eps = this.eps.multiply(new BigRational(100000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        List<Complex<BigDecimal>> roots = cr.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
        int i2 = 0;
        for (Complex<BigDecimal> dd : roots) {
            Complex di;
            ComplexRootTest.assertTrue((String)"|dd - di| < eps ", (((BigDecimal)((Complex)dd.subtract(di = (Complex)Rn.get(i2++)).norm()).getRe()).compareTo(eps2) <= 0 ? 1 : 0) != 0);
        }
    }

    public void testComplexRootApproximationWilkinsonInverseFull() {
        int N2 = 5;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        BigDecimal br = new BigDecimal();
        ComplexRing<BigDecimal> cf = new ComplexRing<BigDecimal>(br);
        Complex<BigDecimal> I2 = cf.getIMAG();
        MonoidElem cc = null;
        Complex<BigRational> Ir = this.cfac.getIMAG();
        ArrayList<Complex<BigDecimal>> Rn = new ArrayList<Complex<BigDecimal>>(5);
        this.a = this.d;
        int i = 1;
        while (i < 5) {
            cc = ((Complex)cf.fromInteger(i)).multiply(I2);
            cc = cc.inverse();
            Rn.add((Complex<BigDecimal>)cc);
            this.c = ((GenPolynomial)this.dfac.fromInteger(i)).multiply(Ir);
            this.c = this.d.divide(this.c);
            this.b = this.e.subtract((Complex<BigRational>)((Object)this.c));
            this.a = this.a.multiply((Complex<BigRational>)((Object)this.b));
            ++i;
        }
        ComplexRootsSturm<BigRational> cr = new ComplexRootsSturm<BigRational>(this.cfac);
        this.eps = this.eps.multiply(new BigRational(100000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        List<Complex<BigDecimal>> roots = cr.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)roots.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Complex<BigDecimal> dd : roots) {
            boolean t = false;
            for (Complex complex : Rn) {
                boolean bl = t = ((BigDecimal)((Complex)dd.subtract(complex).norm()).getRe()).compareTo(eps2) <= 0;
                if (t) break;
            }
            if (t) continue;
            ComplexRootTest.fail((String)"|dd - di| < eps ");
        }
    }
}

