/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.ComplexRoots;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.Rectangle;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import edu.jas.ufd.Squarefree;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public abstract class ComplexRootsAbstract<C extends RingElem<C> & Rational>
implements ComplexRoots<C> {
    private static final Logger logger = Logger.getLogger(ComplexRootsAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Squarefree<Complex<C>> engine;

    public ComplexRootsAbstract(RingFactory<Complex<C>> cf) {
        this.engine = SquarefreeFactory.getImplementation(cf);
    }

    @Override
    public Complex<C> rootBound(GenPolynomial<Complex<C>> f) {
        if (f == null) {
            return null;
        }
        RingFactory cfac = f.ring.coFac;
        Complex M = (Complex)cfac.getONE();
        if (f.isZERO() || f.isConstant()) {
            return M;
        }
        StarRingElem a = f.leadingBaseCoefficient().norm();
        for (Complex<C> c : f.getMap().values()) {
            Complex d = ((Complex)c.norm()).divide(a);
            if (M.compareTo(d) >= 0) continue;
            M = d;
        }
        M = M.sum((Complex)cfac.getONE());
        return M;
    }

    @Override
    public abstract long complexRootCount(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public abstract List<Rectangle<C>> complexRoots(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> a) {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        ArrayList<Rectangle<C>> roots = new ArrayList<Rectangle<C>>();
        for (GenPolynomial<Complex<C>> p : sa.keySet()) {
            Complex<C> Mb = this.rootBound(p);
            RingElem M = Mb.getRe();
            RingElem M1 = M.sum((RingElem)((RingElem)M.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info((Object)("rootBound = " + M));
            }
            Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
            Rectangle rect = new Rectangle(corner);
            try {
                List rs = this.complexRoots(rect, p);
                long e = (Long)sa.get(p);
                int i = 0;
                while ((long)i < e) {
                    roots.addAll(rs);
                    ++i;
                }
            }
            catch (InvalidBoundaryException e) {
                throw new RuntimeException("this should never happen " + e);
            }
        }
        return roots;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Rectangle<C> complexRootRefinement(Rectangle<C> rect, GenPolynomial<Complex<C>> a, BigRational len) throws InvalidBoundaryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> a, BigRational len) {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        ArrayList<Rectangle<C>> roots = new ArrayList<Rectangle<C>>();
        for (GenPolynomial<Complex<C>> p : sa.keySet()) {
            Complex<C> Mb = this.rootBound(p);
            RingElem M = Mb.getRe();
            RingElem M1 = M.sum((RingElem)((RingElem)M.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info((Object)("rootBound = " + M));
            }
            Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
            Rectangle rect = new Rectangle(corner);
            try {
                List rs = this.complexRoots(rect, p);
                ArrayList rf = new ArrayList(rs.size());
                for (Rectangle r : rs) {
                    Rectangle rr = this.complexRootRefinement(r, p, len);
                    rf.add(rr);
                }
                long e = (Long)sa.get(p);
                int i = 0;
                while ((long)i < e) {
                    roots.addAll(rf);
                    ++i;
                }
            }
            catch (InvalidBoundaryException e) {
                throw new RuntimeException("this should never happen " + e);
            }
        }
        return roots;
    }

    public String toDecimal(Complex<C> a) {
        C r = a.getRe();
        String s = r.toString();
        BigRational rs = new BigRational(s);
        BigDecimal rd = new BigDecimal(rs);
        C i = a.getIm();
        s = i.toString();
        BigRational is = new BigRational(s);
        BigDecimal id = new BigDecimal(is);
        return String.valueOf(rd.toString()) + " i " + id.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Complex<BigDecimal> approximateRoot(Rectangle<C> rt, GenPolynomial<Complex<C>> f, C eps) throws NoConvergenceException {
        if (rt == null) {
            throw new IllegalArgumentException("null interval not allowed");
        }
        d = rt.getDecimalCenter();
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return d;
        }
        if (rt.length().compareTo(eps) < 0) {
            return d;
        }
        cr = d.ring;
        sw = rt.getSW();
        swr = new BigDecimal(((Rational)sw.getRe()).getRational());
        swi = new BigDecimal(((Rational)sw.getIm()).getRational());
        ll = new Complex<BigDecimal>(cr, swr, swi);
        ne = rt.getNE();
        ner = new BigDecimal(((Rational)ne.getRe()).getRational());
        nei = new BigDecimal(((Rational)ne.getIm()).getRational());
        ur = new Complex<BigDecimal>(cr, ner, nei);
        e = new BigDecimal(((Rational)eps).getRational());
        q = new Complex<BigDecimal>(cr, new BigDecimal("0.25"));
        e = e.multiply((BigDecimal)d.norm().getRe());
        dfac = new GenPolynomialRing<Complex<BigDecimal>>(cr, f.ring);
        df = PolyUtil.complexDecimalFromRational(dfac, f);
        fp = PolyUtil.baseDeriviative(f);
        dfp = PolyUtil.complexDecimalFromRational(dfac, fp);
        i = 0;
        MITER = 50;
        dir = -1;
        while (i++ < 50) {
            fx = PolyUtil.evaluateMain(cr, df, d);
            fs = (BigDecimal)fx.norm().getRe();
            if (fx.isZERO()) {
                return d;
            }
            fpx = PolyUtil.evaluateMain(cr, dfp, d);
            if (fpx.isZERO()) {
                throw new NoConvergenceException("zero deriviative should not happen");
            }
            x /* !! */  = fx.divide(fpx);
            dx = d.subtract(x /* !! */ );
            if (((BigDecimal)d.subtract(dx).norm().getRe()).compareTo(e) > 0) ** GOTO lbl96
            return dx;
lbl-1000:
            // 1 sources

            {
                if (i++ > 50) {
                    throw new NoConvergenceException("no convergence after " + i + " steps");
                }
                if (i > 25 && dir == 0) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeSE(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x /* !! */  = cr.getZERO();
                    ComplexRootsAbstract.logger.info((Object)("trying new SE starting point " + d));
                    i = 0;
                    dir = 1;
                }
                if (i > 25 && dir == 1) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeNW(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x /* !! */  = cr.getZERO();
                    ComplexRootsAbstract.logger.info((Object)("trying new NW starting point " + d));
                    i = 0;
                    dir = 2;
                }
                if (i > 25 && dir == 2) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeSW(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x /* !! */  = cr.getZERO();
                    ComplexRootsAbstract.logger.info((Object)("trying new SW starting point " + d));
                    i = 0;
                    dir = 3;
                }
                if (i > 25 && dir == 3) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeNE(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x /* !! */  = cr.getZERO();
                    ComplexRootsAbstract.logger.info((Object)("trying new NE starting point " + d));
                    i = 0;
                    dir = 4;
                }
                if (i > 25 && (dir == -1 || dir == 4 || dir == 5)) {
                    sr = rt.randomPoint();
                    srr = new BigDecimal(((Rational)sr.getRe()).getRational());
                    sri = new BigDecimal(((Rational)sr.getIm()).getRational());
                    sd = new Complex<BigDecimal>(cr, srr, sri);
                    d = sd;
                    x /* !! */  = cr.getZERO();
                    ComplexRootsAbstract.logger.info((Object)("trying new random starting point " + d));
                    if (dir == -1) {
                        i = 0;
                        dir = 0;
                    } else if (dir == 4) {
                        i = 0;
                        dir = 5;
                    } else {
                        dir = 6;
                    }
                }
                x /* !! */  = x /* !! */ .multiply(q);
                dx = d.subtract(x /* !! */ );
lbl96:
                // 2 sources

                ** while (dx.getRe().compareTo((BigDecimal)ll.getRe()) < 0 || dx.getIm().compareTo((BigDecimal)ll.getIm()) < 0 || dx.getRe().compareTo((BigDecimal)ur.getRe()) > 0 || dx.getIm().compareTo((BigDecimal)ur.getIm()) > 0)
            }
lbl97:
            // 1 sources

            d = dx;
        }
        throw new NoConvergenceException("no convergence after " + i + " steps");
    }

    public List<Complex<BigDecimal>> approximateRoots(GenPolynomial<Complex<C>> a, C eps) {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        ArrayList<Complex<BigDecimal>> roots = new ArrayList<Complex<BigDecimal>>();
        for (GenPolynomial<Complex<C>> p : sa.keySet()) {
            ArrayList<Complex<BigDecimal>> rf = null;
            if (p.degree(0) <= 1L) {
                AbelianGroupElem<Complex<C>> tc = p.trailingBaseCoefficient();
                tc = ((Complex)tc).negate();
                BigDecimal rr = new BigDecimal(((Rational)((Complex)tc).getRe()).getRational());
                BigDecimal ri = new BigDecimal(((Rational)((Complex)tc).getIm()).getRational());
                ComplexRing<BigDecimal> crf = new ComplexRing<BigDecimal>(rr);
                Complex<BigDecimal> r = new Complex<BigDecimal>(crf, rr, ri);
                rf = new ArrayList<Complex<BigDecimal>>(1);
                rf.add(r);
            } else {
                Complex<C> Mb = this.rootBound(p);
                RingElem M = Mb.getRe();
                RingElem M1 = M.sum((RingElem)((RingElem)M.factory().fromInteger(1L)));
                if (this.debug) {
                    logger.info((Object)("rootBound = " + M));
                }
                Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
                Rectangle rect = new Rectangle(corner);
                List rs = null;
                try {
                    rs = this.complexRoots(rect, p);
                }
                catch (InvalidBoundaryException e) {
                    throw new RuntimeException("this should never happen " + e);
                }
                rf = new ArrayList(rs.size());
                for (Rectangle r : rs) {
                    Complex<BigDecimal> rr = null;
                    while (rr == null) {
                        try {
                            rr = this.approximateRoot(r, p, eps);
                            rf.add(rr);
                        }
                        catch (NoConvergenceException e) {
                            BigRational len = r.rationalLength();
                            len = len.multiply(new BigRational(1L, 1000L));
                            try {
                                r = this.complexRootRefinement(r, p, len);
                                logger.info((Object)("fall back rootRefinement = " + r));
                            }
                            catch (InvalidBoundaryException ee) {
                                throw new RuntimeException("this should never happen " + ee);
                            }
                        }
                    }
                }
            }
            long e = (Long)sa.get(p);
            int i = 0;
            while ((long)i < e) {
                roots.addAll(rf);
                ++i;
            }
        }
        return roots;
    }
}

