/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Boundary;
import edu.jas.root.ComplexRootsAbstract;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.root.RootUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ComplexRootsSturm<C extends RingElem<C> & Rational>
extends ComplexRootsAbstract<C> {
    private static final Logger logger = Logger.getLogger(ComplexRootsSturm.class);
    private final boolean debug = logger.isDebugEnabled();

    public ComplexRootsSturm(RingFactory<Complex<C>> cf) {
        super(cf);
    }

    public long indexOfCauchy(C a, C b, GenPolynomial<C> f, GenPolynomial<C> g) {
        List<GenPolynomial<C>> S = this.sturmSequence(g, f);
        if (this.debug) {
            logger.info((Object)("sturmSeq = " + S));
        }
        RingFactory cfac = f.ring.coFac;
        List l = PolyUtil.evaluateMain(cfac, S, a);
        List r = PolyUtil.evaluateMain(cfac, S, b);
        long v = RootUtil.signVar(l) - RootUtil.signVar(r);
        return v;
    }

    public long[] indexOfRouth(C a, C b, GenPolynomial<C> f, GenPolynomial<C> g) {
        List<GenPolynomial<C>> S = this.sturmSequence(f, g);
        RingFactory cfac = f.ring.coFac;
        List l = PolyUtil.evaluateMain(cfac, S, a);
        List r = PolyUtil.evaluateMain(cfac, S, b);
        long v = RootUtil.signVar(l) - RootUtil.signVar(r);
        long d = f.degree(0);
        if (d < g.degree(0)) {
            d = g.degree(0);
        }
        long ui = (d - v) / 2L;
        long li = (d + v) / 2L;
        return new long[]{ui, li};
    }

    public List<GenPolynomial<C>> sturmSequence(GenPolynomial<C> f, GenPolynomial<C> g) {
        ArrayList<GenPolynomial<C>> S = new ArrayList<GenPolynomial<C>>();
        if (f == null || f.isZERO()) {
            return S;
        }
        if (f.isConstant()) {
            S.add(f.monic());
            return S;
        }
        GenPolynomial<C> F2 = f;
        S.add(F2);
        AbelianGroupElem<GenPolynomial<C>> G = g;
        while (!G.isZERO()) {
            GenPolynomial<C> r = F2.remainder((GenPolynomial<C>)G);
            F2 = G;
            G = r.negate();
            S.add(F2);
        }
        if (F2.isConstant()) {
            return S;
        }
        ArrayList<GenPolynomial<C>> Sp = new ArrayList<GenPolynomial<C>>(S.size());
        for (GenPolynomial<C> p : S) {
            p = p.divide(F2);
            Sp.add(p);
        }
        return Sp;
    }

    @Override
    public long complexRootCount(Rectangle<C> rect, GenPolynomial<Complex<C>> a) throws InvalidBoundaryException {
        return this.windingNumber(rect, a);
    }

    public long windingNumber(Rectangle<C> rect, GenPolynomial<Complex<C>> A) throws InvalidBoundaryException {
        Boundary<C> bound = new Boundary<C>(rect, A);
        ComplexRing cr = (ComplexRing)A.ring.coFac;
        RingFactory cf = cr.ring;
        RingElem zero = (RingElem)cf.getZERO();
        RingElem one = (RingElem)cf.getONE();
        long ix = 0L;
        int i = 0;
        while (i < 4) {
            long ci = this.indexOfCauchy(zero, one, bound.getRealPart(i), bound.getImagPart(i));
            ix += ci;
            ++i;
        }
        if (ix % 2L != 0L) {
            throw new InvalidBoundaryException("odd winding number " + ix);
        }
        return ix / 2L;
    }

    @Override
    public List<Rectangle<C>> complexRoots(Rectangle<C> rect, GenPolynomial<Complex<C>> a) throws InvalidBoundaryException {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        ArrayList<Rectangle<C>> roots = new ArrayList<Rectangle<C>>();
        long n = this.windingNumber(rect, a);
        if (n < 0L) {
            throw new RuntimeException("negative winding number " + n);
        }
        if (n == 0L) {
            return roots;
        }
        if (n == 1L) {
            roots.add(rect);
            return roots;
        }
        Complex eps = cr.fromInteger(1L);
        eps = eps.divide(cr.fromInteger(1000L));
        Complex delta = rect.corners[3].subtract(rect.corners[1]);
        delta = delta.divide(cr.fromInteger(2L));
        boolean work = true;
        while (work) {
            Complex center = rect.corners[1].sum(delta);
            if (this.debug) {
                logger.info((Object)("new center = " + center));
            }
            try {
                Complex[] cp = ArrayUtil.copyOfComplex(rect.corners, 4);
                cp[1] = new Complex(cr, cp[1].getRe(), center.getIm());
                cp[2] = center;
                cp[3] = new Complex(cr, center.getRe(), cp[3].getIm());
                Rectangle nw = new Rectangle(cp);
                List nwr = this.complexRoots(nw, a);
                roots.addAll(nwr);
                cp = ArrayUtil.copyOfComplex(rect.corners, 4);
                cp[0] = new Complex(cr, cp[0].getRe(), center.getIm());
                cp[2] = new Complex(cr, center.getRe(), cp[2].getIm());
                cp[3] = center;
                Rectangle sw = new Rectangle(cp);
                List swr = this.complexRoots(sw, a);
                roots.addAll(swr);
                cp = ArrayUtil.copyOfComplex(rect.corners, 4);
                cp[0] = center;
                cp[1] = new Complex(cr, center.getRe(), cp[1].getIm());
                cp[3] = new Complex(cr, cp[3].getRe(), center.getIm());
                Rectangle se = new Rectangle(cp);
                List ser = this.complexRoots(se, a);
                roots.addAll(ser);
                cp = ArrayUtil.copyOfComplex(rect.corners, 4);
                cp[0] = new Complex(cr, center.getRe(), cp[0].getIm());
                cp[1] = center;
                cp[2] = new Complex(cr, cp[2].getRe(), center.getIm());
                Rectangle ne = new Rectangle(cp);
                List ner = this.complexRoots(ne, a);
                roots.addAll(ner);
                work = false;
            }
            catch (InvalidBoundaryException e) {
                delta = delta.sum(delta.multiply(eps));
                eps = eps.sum(eps.multiply(cr.getIMAG()));
            }
        }
        return roots;
    }
}

