/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;

public class Interval<C extends RingElem<C> & Rational> {
    public final C left;
    public final C right;

    public Interval(C left, C right) {
        this.left = left;
        this.right = right;
    }

    public Interval(C mid) {
        this(mid, mid);
    }

    public String toString() {
        return "[" + this.left + ", " + this.right + "]";
    }

    public String toScript() {
        return "( " + this.left + ", " + this.right + " ) ";
    }

    public Interval<C> clone() {
        return new Interval<C>(this.left, this.right);
    }

    public boolean equals(Object b) {
        if (!(b instanceof Interval)) {
            return false;
        }
        Interval a = null;
        try {
            a = (Interval)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.left.equals(a.left) && this.right.equals(a.right);
    }

    public int hashCode() {
        return 37 * this.left.hashCode() + this.right.hashCode();
    }

    public C length() {
        RingElem m = (RingElem)this.right.subtract(this.left);
        return (C)((RingElem)m.abs());
    }

    public BigRational rationalLength() {
        return ((Rational)this.length()).getRational();
    }

    public BigDecimal toDecimal() {
        BigDecimal l = new BigDecimal(((Rational)this.left).getRational());
        BigDecimal r = new BigDecimal(((Rational)this.right).getRational());
        BigDecimal two = new BigDecimal(2L);
        BigDecimal v = l.sum(r).divide(two);
        return v;
    }

    public BigRational rationalMiddle() {
        BigRational m = ((Rational)this.left).getRational().sum(((Rational)this.right).getRational());
        BigRational t = new BigRational(1L, 2L);
        m = m.multiply(t);
        return m;
    }

    public C randomPoint() {
        RingElem dr = (RingElem)this.right.subtract(this.left);
        RingFactory fac = (RingFactory)dr.factory();
        RingElem r = (RingElem)fac.random(13);
        if (!(r = (RingElem)r.abs()).isZERO() && r.compareTo((RingElem)fac.getONE()) > 0) {
            r = (RingElem)r.inverse();
        }
        dr = dr.multiply(r);
        RingElem rv = this.left.sum((RingElem)dr);
        return (C)rv;
    }
}

