/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;

public class RealAlgebraicNumber<C extends GcdRingElem<C> & Rational>
implements GcdRingElem<RealAlgebraicNumber<C>>,
Rational {
    public final AlgebraicNumber<C> number;
    public final RealAlgebraicRing<C> ring;

    public RealAlgebraicNumber(RealAlgebraicRing<C> r, GenPolynomial<C> a) {
        this.number = new AlgebraicNumber(r.algebraic, a);
        this.ring = r;
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> r, AlgebraicNumber<C> a) {
        this.number = a;
        this.ring = r;
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> r) {
        this(r, (AlgebraicNumber<C>)r.algebraic.getZERO());
    }

    @Override
    public RealAlgebraicRing<C> factory() {
        return this.ring;
    }

    public RealAlgebraicNumber<C> clone() {
        return new RealAlgebraicNumber<C>(this.ring, this.number);
    }

    @Override
    public BigRational getRational() {
        return this.magnitude();
    }

    @Override
    public boolean isZERO() {
        return this.number.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.number.isONE();
    }

    @Override
    public boolean isUnit() {
        return this.number.isUnit();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return "{ " + this.number.toString() + " }";
        }
        return "Real" + this.number.toString();
    }

    @Override
    public String toScript() {
        return this.number.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((RealAlgebraicRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(RealAlgebraicNumber<C> b) {
        int s = 0;
        if (this.number.ring != b.number.ring) {
            s = this.number.ring.modul.compareTo(b.number.ring.modul);
            System.out.println("s_mod = " + s);
        }
        if (s != 0) {
            return s;
        }
        s = this.subtract(b).signum();
        return s;
    }

    @Override
    public int compareTo(AlgebraicNumber<C> b) {
        int s = this.number.compareTo(b);
        System.out.println("s_algeb = " + s);
        return s;
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof RealAlgebraicNumber)) {
            return false;
        }
        RealAlgebraicNumber a = null;
        try {
            a = (RealAlgebraicNumber)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.number.equals(a.number);
    }

    @Override
    public int hashCode() {
        return 37 * this.number.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> abs() {
        if (this.signum() < 0) {
            return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
        }
        return this;
    }

    @Override
    public RealAlgebraicNumber<C> sum(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<AlgebraicNumber<C>>(this.ring, this.number.sum(S.number));
    }

    @Override
    public RealAlgebraicNumber<C> sum(GenPolynomial<C> c) {
        return new RealAlgebraicNumber<GenPolynomial<C>>(this.ring, this.number.sum(c));
    }

    @Override
    public RealAlgebraicNumber<C> sum(C c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.sum(c));
    }

    @Override
    public RealAlgebraicNumber<C> negate() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
    }

    @Override
    public int signum() {
        Interval v = this.ring.engine.invariantSignInterval(this.ring.root, this.ring.algebraic.modul, this.number.val);
        this.ring.setRoot(v);
        return this.ring.engine.realIntervalSign(v, this.ring.algebraic.modul, this.number.val);
    }

    public BigRational magnitude() {
        Interval v = this.ring.engine.invariantMagnitudeInterval(this.ring.root, this.ring.algebraic.modul, this.number.val, this.ring.eps);
        this.ring.setRoot(v);
        GcdRingElem ev = (GcdRingElem)this.ring.engine.realIntervalMagnitude(v, this.ring.algebraic.modul, this.number.val, this.ring.eps);
        if (ev instanceof BigRational) {
            BigRational er = (BigRational)ev;
            return er;
        }
        throw new RuntimeException("BigRational expected, but was " + ev.getClass());
    }

    @Override
    public RealAlgebraicNumber<C> subtract(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.subtract(S.number));
    }

    @Override
    public RealAlgebraicNumber<C> divide(RealAlgebraicNumber<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> inverse() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> remainder(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.remainder(S.number));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<AlgebraicNumber<C>>(this.ring, this.number.multiply(S.number));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(C c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply(c));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(GenPolynomial<C> c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply(c));
    }

    public RealAlgebraicNumber<C> monic() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.monic());
    }

    @Override
    public RealAlgebraicNumber<C> gcd(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.gcd(S.number));
    }

    public RealAlgebraicNumber<C>[] egcd(RealAlgebraicNumber<C> S) {
        AlgebraicNumber<C>[] aret = this.number.egcd(S.number);
        RealAlgebraicNumber[] ret = new RealAlgebraicNumber[]{new RealAlgebraicNumber<C>(this.ring, aret[0]), new RealAlgebraicNumber<C>(this.ring, aret[1]), new RealAlgebraicNumber<C>(this.ring, aret[2])};
        return ret;
    }
}

