/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RealAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<RealAlgebraicNumber<C>> {
    public final AlgebraicNumberRing<C> algebraic;
    Interval<C> root;
    public final C eps;
    public final RealRootsSturm<C> engine;

    public RealAlgebraicRing(GenPolynomial<C> m, Interval<C> root) {
        this.algebraic = new AlgebraicNumberRing<C>(m);
        this.root = root;
        this.engine = new RealRootsSturm();
        if (m.ring.characteristic().signum() > 0) {
            throw new RuntimeException("characteristic not zero");
        }
        GcdRingElem e = (GcdRingElem)m.ring.coFac.fromInteger(10L);
        e = (GcdRingElem)e.inverse();
        e = Power.positivePower(e, 9L);
        this.eps = e;
    }

    public RealAlgebraicRing(GenPolynomial<C> m, Interval<C> root, boolean isField) {
        this.algebraic = new AlgebraicNumberRing<C>(m, isField);
        this.root = root;
        this.engine = new RealRootsSturm();
        if (m.ring.characteristic().signum() > 0) {
            throw new RuntimeException("characteristic not zero");
        }
        GcdRingElem e = (GcdRingElem)m.ring.coFac.fromInteger(10L);
        e = (GcdRingElem)e.inverse();
        e = Power.positivePower(e, 9L);
        this.eps = e;
    }

    public synchronized Interval<C> getRoot() {
        return this.root;
    }

    public synchronized void setRoot(Interval<C> v) {
        this.root = v;
    }

    @Override
    public boolean isFinite() {
        return this.algebraic.isFinite();
    }

    @Override
    public RealAlgebraicNumber<C> copy(RealAlgebraicNumber<C> c) {
        return new RealAlgebraicNumber(this, c.number);
    }

    @Override
    public RealAlgebraicNumber<C> getZERO() {
        return new RealAlgebraicNumber(this, this.algebraic.getZERO());
    }

    @Override
    public RealAlgebraicNumber<C> getONE() {
        return new RealAlgebraicNumber(this, this.algebraic.getONE());
    }

    public RealAlgebraicNumber<C> getGenerator() {
        return new RealAlgebraicNumber<C>(this, this.algebraic.getGenerator());
    }

    @Override
    public List<RealAlgebraicNumber<C>> generators() {
        ArrayList<RealAlgebraicNumber<C>> gens = new ArrayList<RealAlgebraicNumber<C>>(2);
        gens.add((RealAlgebraicNumber<C>)this.getONE());
        gens.add(this.getGenerator());
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.algebraic.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.algebraic.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.algebraic.isField();
    }

    @Override
    public BigInteger characteristic() {
        return this.algebraic.characteristic();
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(BigInteger a) {
        return new RealAlgebraicNumber(this, this.algebraic.fromInteger(a));
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(long a) {
        return new RealAlgebraicNumber(this, this.algebraic.fromInteger(a));
    }

    public String toString() {
        return "RealAlgebraicRing[ " + this.algebraic.modul.toString() + " in " + this.root + " | isField=" + this.algebraic.isField() + " :: " + this.algebraic.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RealN( " + this.algebraic.modul.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object b) {
        if (!(b instanceof RealAlgebraicRing)) {
            return false;
        }
        RealAlgebraicRing a = null;
        try {
            a = (RealAlgebraicRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.algebraic.equals(a.algebraic) && this.root.equals(a.root);
    }

    public int hashCode() {
        return 37 * this.algebraic.hashCode() + this.root.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> random(int n) {
        return new RealAlgebraicNumber(this, this.algebraic.random(n));
    }

    @Override
    public RealAlgebraicNumber<C> random(int n, Random rnd) {
        return new RealAlgebraicNumber(this, this.algebraic.random(n, rnd));
    }

    @Override
    public RealAlgebraicNumber<C> parse(String s) {
        return new RealAlgebraicNumber(this, this.algebraic.parse(s));
    }

    @Override
    public RealAlgebraicNumber<C> parse(Reader r) {
        return new RealAlgebraicNumber(this, this.algebraic.parse(r));
    }
}

