/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RealAlgebraicTest
extends TestCase {
    RealAlgebraicRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    RealAlgebraicNumber<BigRational> a;
    RealAlgebraicNumber<BigRational> b;
    RealAlgebraicNumber<BigRational> c;
    RealAlgebraicNumber<BigRational> d;
    RealAlgebraicNumber<BigRational> e;
    RealAlgebraicNumber<BigRational> alpha;
    int rl = 1;
    int kl = 10;
    int ll;
    int el = this.ll = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RealAlgebraicTest.suite());
    }

    public RealAlgebraicTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RealAlgebraicTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational l = new BigRational(1L);
        BigRational r = new BigRational(2L);
        Interval<BigRational> positiv = new Interval<BigRational>(l, r);
        String[] vars = new String[]{"alpha"};
        this.mfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, vars);
        GenPolynomial<BigRational> mo = this.mfac.univariate(0, 2L);
        mo = mo.subtract((BigRational)this.mfac.fromInteger(2L));
        this.fac = new RealAlgebraicRing<BigRational>(mo, positiv);
        this.alpha = this.fac.getGenerator();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.alpha = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RealAlgebraicTest.assertTrue((String)"length( c ) = 1", (this.c.number.getVal().length() == 1 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RealAlgebraicTest.assertTrue((String)"length( d ) = 0", (this.d.number.getVal().length() == 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RealAlgebraicTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.el);
            if (!this.a.isZERO() && !this.a.isONE()) {
                RealAlgebraicTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.number.getVal().length() >= 0 ? 1 : 0) != 0);
                RealAlgebraicTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                RealAlgebraicTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.c.subtract(this.b);
        RealAlgebraicTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.b.sum((BigRational)((Object)this.a));
        RealAlgebraicTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((BigRational)((Object)this.a.sum((BigRational)((Object)this.b))));
        this.e = this.c.sum((BigRational)((Object)this.a)).sum(this.b);
        RealAlgebraicTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((BigRational)this.fac.getZERO());
        this.d = this.a.subtract((RealAlgebraicNumber<BigRational>)this.fac.getZERO());
        RealAlgebraicTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((RealAlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((RealAlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        RealAlgebraicTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RealAlgebraicTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        RealAlgebraicTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RealAlgebraicTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RealAlgebraicTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RealAlgebraicTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RealAlgebraicTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((RealAlgebraicNumber)this.fac.getONE()).multiply(this.a);
        RealAlgebraicTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply((BigRational)((Object)this.a));
        RealAlgebraicTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((RealAlgebraicNumber)this.fac.getZERO()).inverse();
        }
        catch (NotInvertibleException expected) {
            return;
        }
        RealAlgebraicTest.fail((String)"0 invertible");
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).sum((RealAlgebraicNumber<BigRational>)this.a.multiply((BigRational)((Object)this.c)));
        RealAlgebraicTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSignum() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        int sa = this.a.signum();
        int sb = this.b.signum();
        int sc = this.c.signum();
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.a.multiply((BigRational)((Object)this.c));
        int sd = this.d.signum();
        int se = this.e.signum();
        RealAlgebraicTest.assertEquals((String)"sign(a*b) = sign(a)*sign(b) ", (int)(sa * sb), (int)sd);
        RealAlgebraicTest.assertEquals((String)"sign(a*c) = sign(a)*sign(c) ", (int)(sa * sc), (int)se);
        this.b = this.a.negate();
        sb = this.b.signum();
        RealAlgebraicTest.assertEquals((String)"sign(-a) = -sign(a) ", (int)(-sa), (int)sb);
    }

    public void testCompare() {
        this.a = ((RealAlgebraicNumber)this.fac.random(this.ll)).abs();
        this.b = this.a.sum((BigRational)this.fac.getONE());
        this.c = this.b.sum((BigRational)this.fac.getONE());
        int ab = this.a.compareTo(this.b);
        int bc = this.b.compareTo(this.c);
        int ac = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (ab < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (bc < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (ac < 0 ? 1 : 0) != 0);
        this.a = this.a.negate();
        this.b = this.a.sum((BigRational)this.fac.getONE());
        this.c = this.b.sum((BigRational)this.fac.getONE());
        ab = this.a.compareTo(this.b);
        bc = this.b.compareTo(this.c);
        ac = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (ab < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (bc < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (ac < 0 ? 1 : 0) != 0);
    }

    public void testMagnitude() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        BigDecimal ad = new BigDecimal(this.a.magnitude());
        BigDecimal bd = new BigDecimal(this.b.magnitude());
        BigDecimal cd = new BigDecimal(this.c.magnitude());
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.a.sum((BigRational)((Object)this.b));
        BigDecimal dd = new BigDecimal(this.d.magnitude());
        BigDecimal ed = new BigDecimal(this.e.magnitude());
        BigDecimal dd1 = new BigDecimal(this.a.magnitude().multiply(this.b.magnitude()));
        BigDecimal ed1 = new BigDecimal(this.a.magnitude().sum(this.b.magnitude()));
        BigRational eps = Power.positivePower(new BigRational(1L, 10L), 8L);
        BigDecimal epsd = new BigDecimal(eps);
        RealAlgebraicTest.assertTrue((String)"mag(a*b) = mag(a)*mag(b)", (dd.subtract(dd1).abs().compareTo(epsd) <= 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"mag(a+b) = mag(a)+mag(b)", (ed.subtract(ed1).abs().compareTo(epsd) <= 0 ? 1 : 0) != 0);
        this.d = this.a.divide(this.b);
        this.e = this.a.subtract(this.b);
        dd = new BigDecimal(this.d.magnitude());
        ed = new BigDecimal(this.e.magnitude());
        dd1 = new BigDecimal(this.a.magnitude().divide(this.b.magnitude()));
        ed1 = new BigDecimal(this.a.magnitude().subtract(this.b.magnitude()));
        RealAlgebraicTest.assertTrue((String)"mag(a/b) = mag(a)/mag(b)", (dd.subtract(dd1).abs().compareTo(epsd) <= 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"mag(a-b) = mag(a)-mag(b)", (ed.subtract(ed1).abs().compareTo(epsd) <= 0 ? 1 : 0) != 0);
    }

    public void notestRealRootIsolation() {
        System.out.println();
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(this.fac, 1);
        GenPolynomial<BigRational> ar = dfac.random(3, 5, 7, this.q);
        System.out.println("ar = " + ar);
        RealRootsSturm<Rational> rrr = new RealRootsSturm<Rational>();
        List<Interval<Object>> R = rrr.realRoots(ar);
        System.out.println("R = " + R);
        RealAlgebraicTest.assertTrue((String)"#roots >= 0 ", (R.size() >= 0 ? 1 : 0) != 0);
        BigRational eps = Power.positivePower(new BigRational(1L, 10L), 50L);
        RealAlgebraicNumber<BigRational> epsr = ((RealAlgebraicNumber)dfac.coFac.getONE()).multiply(eps);
        R = rrr.refineIntervals(R, ar, epsr);
        for (Interval<Object> v : R) {
            BigDecimal dd = v.toDecimal();
            System.out.println("v = " + dd);
        }
    }

    public void testRealRootIsolationWilkinson() {
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(this.fac, 1);
        RealRootsSturm<RingElem<GenPolynomial<RealAlgebraicNumber<BigRational>>>> rrr = new RealRootsSturm<RingElem<GenPolynomial<RealAlgebraicNumber<BigRational>>>>();
        int N2 = 3;
        GenPolynomial<GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>>> dr = dfac.getONE();
        GenPolynomial<BigRational> er = dfac.univariate(0);
        ArrayList<Interval<RealAlgebraicNumber<BigRational>>> Rn = new ArrayList<Interval<RealAlgebraicNumber<BigRational>>>(3);
        GenPolynomial<GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>>> ar = dr;
        int i = 0;
        while (i < 3) {
            GenPolynomial<RealAlgebraicNumber<BigRational>> cr = ((GenPolynomial)dfac.fromInteger(i)).multiply(this.alpha);
            Rn.add(new Interval<RealAlgebraicNumber<BigRational>>(cr.leadingBaseCoefficient()));
            GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>> br = er.subtract((BigRational)((Object)cr));
            ar = ar.multiply(br);
            ++i;
        }
        List<Interval<Object>> R = rrr.realRoots(ar);
        RealAlgebraicTest.assertTrue((String)"#roots = 3 ", (R.size() == 3 ? 1 : 0) != 0);
        BigRational eps = Power.positivePower(new BigRational(1L, 10L), 50L);
        BigDecimal eps1 = new BigDecimal(eps);
        RealAlgebraicNumber<BigRational> epsr = ((RealAlgebraicNumber)dfac.coFac.getONE()).multiply(eps);
        R = rrr.refineIntervals(R, ar, epsr);
        int i2 = 0;
        for (Interval<Object> interval : R) {
            BigDecimal di;
            BigDecimal dd = interval.toDecimal();
            RealAlgebraicTest.assertTrue((String)"|dd - di| < eps ", (dd.compareTo(di = ((Interval)Rn.get(i2++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }
}

