/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealRoots;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class RealRootAbstract<C extends RingElem<C> & Rational>
implements RealRoots<C> {
    private static final Logger logger = Logger.getLogger(RealRootAbstract.class);
    private static boolean debug = logger.isDebugEnabled();

    @Override
    public C realRootBound(GenPolynomial<C> f) {
        if (f == null) {
            return null;
        }
        RingFactory cfac = f.ring.coFac;
        RingElem M = (RingElem)cfac.getONE();
        if (f.isZERO() || f.isConstant()) {
            return (C)M;
        }
        RingElem a = (RingElem)f.leadingBaseCoefficient().abs();
        for (RingElem c : f.getMap().values()) {
            RingElem d = ((RingElem)c.abs()).divide(a);
            if (M.compareTo(d) >= 0) continue;
            M = d;
        }
        if (M instanceof RealAlgebraicNumber) {
            RealAlgebraicNumber Mr = (RealAlgebraicNumber)M;
            BigRational r = Mr.magnitude();
            M = ((RingElem)cfac.fromInteger(r.numerator())).divide((RingElem)cfac.fromInteger(r.denominator()));
        }
        M = M.sum((RingElem)f.ring.coFac.getONE());
        return (C)M;
    }

    public C magnitudeBound(Interval<C> iv, GenPolynomial<C> f) {
        RingFactory cfac;
        RingElem B;
        if (f == null) {
            return null;
        }
        if (f.isZERO()) {
            return (C)((RingElem)f.ring.coFac.getONE());
        }
        if (f.isConstant()) {
            return (C)((RingElem)f.leadingBaseCoefficient().abs());
        }
        GenPolynomial<C> fa = f.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C a) {
                return (RingElem)a.abs();
            }
        });
        RingElem M = (RingElem)iv.left.abs();
        if (M.compareTo((RingElem)iv.right.abs()) < 0) {
            M = (RingElem)iv.right.abs();
        }
        if ((B = PolyUtil.evaluateMain(cfac = f.ring.coFac, fa, M)) instanceof RealAlgebraicNumber) {
            RealAlgebraicNumber Br = (RealAlgebraicNumber)B;
            BigRational r = Br.magnitude();
            B = ((RingElem)cfac.fromInteger(r.numerator())).divide((RingElem)cfac.fromInteger(r.denominator()));
        }
        return (C)B;
    }

    public C bisectionPoint(Interval<C> iv, GenPolynomial<C> f) {
        if (f == null) {
            return null;
        }
        RingFactory cfac = f.ring.coFac;
        RingElem two = (RingElem)cfac.fromInteger(2L);
        RingElem c = (RingElem)iv.left.sum(iv.right);
        c = c.divide(two);
        if (f.isZERO() || f.isConstant()) {
            return (C)c;
        }
        RingElem m = PolyUtil.evaluateMain(cfac, f, c);
        while (m.isZERO()) {
            RingElem d = iv.left.sum((RingElem)c);
            if ((d = d.divide(two)).equals(c)) {
                d = iv.right.sum((RingElem)c);
                if ((d = d.divide(two)).equals(c)) {
                    throw new RuntimeException("should not happen " + iv);
                }
            }
            c = d;
            m = PolyUtil.evaluateMain(cfac, f, c);
        }
        return (C)c;
    }

    @Override
    public abstract List<Interval<C>> realRoots(GenPolynomial<C> var1);

    @Override
    public List<Interval<C>> realRoots(GenPolynomial<C> f, C eps) {
        List<Interval<C>> iv = this.realRoots(f);
        return this.refineIntervals(iv, f, eps);
    }

    @Override
    public boolean signChange(Interval<C> iv, GenPolynomial<C> f) {
        if (f == null) {
            return false;
        }
        RingFactory cfac = f.ring.coFac;
        Object l = PolyUtil.evaluateMain(cfac, f, iv.left);
        Object r = PolyUtil.evaluateMain(cfac, f, iv.right);
        return l.signum() * r.signum() < 0;
    }

    @Override
    public abstract long realRootCount(Interval<C> var1, GenPolynomial<C> var2);

    @Override
    public Interval<C> refineInterval(Interval<C> iv, GenPolynomial<C> f, C eps) {
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return iv;
        }
        if (iv.length().compareTo(eps) < 0) {
            return iv;
        }
        RingFactory cfac = f.ring.coFac;
        RingElem two = (RingElem)cfac.fromInteger(2L);
        Interval<Object> v = iv;
        while (v.length().compareTo(eps) >= 0) {
            RingElem c = (RingElem)v.left.sum(v.right);
            if (PolyUtil.evaluateMain(cfac, f, c = c.divide(two)).isZERO()) {
                v = new Interval<RingElem>(c, c);
                break;
            }
            Interval<RingElem> iv1 = new Interval<RingElem>((RingElem)v.left, c);
            v = this.signChange(iv1, f) ? iv1 : new Interval<RingElem>(c, (RingElem)v.right);
        }
        return v;
    }

    @Override
    public List<Interval<C>> refineIntervals(List<Interval<C>> V, GenPolynomial<C> f, C eps) {
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return V;
        }
        ArrayList<Interval<C>> IV = new ArrayList<Interval<C>>();
        for (Interval<C> v : V) {
            Interval<C> iv = this.refineInterval(v, f, eps);
            IV.add(iv);
        }
        return IV;
    }

    public abstract Interval<C> invariantSignInterval(Interval<C> var1, GenPolynomial<C> var2, GenPolynomial<C> var3);

    public int realIntervalSign(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g) {
        if (g == null || g.isZERO()) {
            return 0;
        }
        if (f == null || f.isZERO() || f.isConstant()) {
            return g.signum();
        }
        if (g.isConstant()) {
            return g.signum();
        }
        RingFactory cfac = f.ring.coFac;
        RingElem c = (RingElem)iv.left.sum(iv.right);
        c = c.divide((RingElem)cfac.fromInteger(2L));
        RingElem ev = PolyUtil.evaluateMain(cfac, g, c);
        return ev.signum();
    }

    @Override
    public int realSign(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g) {
        if (g == null || g.isZERO()) {
            return 0;
        }
        if (f == null || f.isZERO() || f.isConstant()) {
            return g.signum();
        }
        if (g.isConstant()) {
            return g.signum();
        }
        Interval<C> v = this.invariantSignInterval(iv, f, g);
        return this.realIntervalSign(v, f, g);
    }

    public Interval<C> invariantMagnitudeInterval(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g, C eps) {
        Interval<Object> v = iv;
        if (g == null || g.isZERO()) {
            return v;
        }
        if (g.isConstant()) {
            return v;
        }
        if (f == null || f.isZERO() || f.isConstant()) {
            return v;
        }
        GenPolynomial<C> gp = PolyUtil.baseDeriviative(g);
        C B = this.magnitudeBound(iv, gp);
        RingFactory cfac = f.ring.coFac;
        RingElem two = (RingElem)cfac.fromInteger(2L);
        while (((RingElem)B.multiply(v.length())).compareTo(eps) >= 0) {
            RingElem c = (RingElem)v.left.sum(v.right);
            Interval<RingElem> im = new Interval<RingElem>(c = c.divide(two), (RingElem)v.right);
            v = this.signChange(im, f) ? im : new Interval<RingElem>((RingElem)v.left, c);
        }
        return v;
    }

    public C realIntervalMagnitude(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g, C eps) {
        if (g.isZERO() || g.isConstant()) {
            return g.leadingBaseCoefficient();
        }
        RingFactory cfac = g.ring.coFac;
        RingElem c = (RingElem)iv.left.sum(iv.right);
        c = c.divide((RingElem)cfac.fromInteger(2L));
        RingElem ev = PolyUtil.evaluateMain(cfac, g, c);
        return (C)ev;
    }

    @Override
    public C realMagnitude(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g, C eps) {
        if (g.isZERO() || g.isConstant()) {
            return g.leadingBaseCoefficient();
        }
        Interval<C> v = this.invariantMagnitudeInterval(iv, f, g, eps);
        return this.realIntervalMagnitude(v, f, g, eps);
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal approximateRoot(Interval<C> iv, GenPolynomial<C> f, C eps) throws NoConvergenceException {
        if (iv == null) {
            throw new IllegalArgumentException("null interval not allowed");
        }
        d = iv.toDecimal();
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return d;
        }
        if (iv.length().compareTo(eps) < 0) {
            return d;
        }
        left = new BigDecimal(((Rational)iv.left).getRational());
        right = new BigDecimal(((Rational)iv.right).getRational());
        e = new BigDecimal(((Rational)eps).getRational());
        q = new BigDecimal("0.25");
        e = e.multiply(d);
        dc = BigDecimal.ONE;
        dfac = new GenPolynomialRing<BigDecimal>(dc, f.ring);
        df = PolyUtil.decimalFromRational(dfac, f);
        fp = PolyUtil.baseDeriviative(f);
        dfp = PolyUtil.decimalFromRational(dfac, fp);
        i = 0;
        MITER = 50;
        dir = 0;
        while (i++ < 50) {
            fx = PolyUtil.evaluateMain(dc, df, d);
            if (fx.isZERO()) {
                return d;
            }
            fpx = PolyUtil.evaluateMain(dc, dfp, d);
            if (fpx.isZERO()) {
                throw new NoConvergenceException("zero deriviative should not happen");
            }
            x = fx.divide(fpx);
            dx = d.subtract(x);
            if (d.subtract(dx).abs().compareTo(e) > 0) ** GOTO lbl47
            return dx;
lbl-1000:
            // 1 sources

            {
                if (i++ > 50) {
                    throw new NoConvergenceException("no convergence after " + i + " steps");
                }
                if (i > 25 && dir == 0) {
                    d = sd = new BigDecimal(((Rational)iv.randomPoint()).getRational());
                    x = sd.getZERO();
                    RealRootAbstract.logger.info((Object)("trying new random starting point " + d));
                    i = 0;
                    dir = 1;
                }
                if (i > 25 && dir == 1) {
                    d = sd = new BigDecimal(((Rational)iv.randomPoint()).getRational());
                    x = sd.getZERO();
                    RealRootAbstract.logger.info((Object)("trying new random starting point " + d));
                    dir = 2;
                }
                x = x.multiply(q);
                dx = d.subtract(x);
lbl47:
                // 2 sources

                ** while (dx.compareTo((BigDecimal)left) < 0 || dx.compareTo((BigDecimal)right) > 0)
            }
lbl48:
            // 1 sources

            d = dx;
        }
        throw new NoConvergenceException("no convergence after " + i + " steps");
    }

    public List<BigDecimal> approximateRoots(GenPolynomial<C> f, C eps) {
        List<Interval<C>> iv = this.realRoots(f);
        ArrayList<BigDecimal> roots = new ArrayList<BigDecimal>(iv.size());
        for (Interval<C> i : iv) {
            BigDecimal r = null;
            while (r == null) {
                try {
                    r = this.approximateRoot(i, f, eps);
                    roots.add(r);
                }
                catch (NoConvergenceException e) {
                    RingElem len = i.length();
                    len = len.divide((RingElem)((RingElem)f.ring.coFac.fromInteger(1000L)));
                    i = this.refineInterval(i, f, len);
                    logger.info((Object)("fall back rootRefinement = " + i));
                }
            }
        }
        return roots;
    }

    public boolean isApproximateRoot(BigDecimal x, GenPolynomial<C> f, C eps) {
        if (x == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return true;
        }
        BigDecimal e = new BigDecimal(((Rational)eps).getRational());
        e = e.multiply(new BigDecimal("1000"));
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(dc, f.ring);
        GenPolynomial<BigDecimal> df = PolyUtil.decimalFromRational(dfac, f);
        GenPolynomial<C> fp = PolyUtil.baseDeriviative(f);
        GenPolynomial<BigDecimal> dfp = PolyUtil.decimalFromRational(dfac, fp);
        return this.isApproximateRoot(x, df, dfp, e);
    }

    public boolean isApproximateRoot(BigDecimal x, GenPolynomial<BigDecimal> f, GenPolynomial<BigDecimal> fp, BigDecimal eps) {
        if (x == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return true;
        }
        BigDecimal dc = BigDecimal.ONE;
        BigDecimal fx = PolyUtil.evaluateMain(dc, f, x);
        if (fx.isZERO()) {
            return true;
        }
        BigDecimal fpx = PolyUtil.evaluateMain(dc, fp, x);
        if (fpx.isZERO()) {
            return false;
        }
        BigDecimal d = fx.divide(fpx);
        if (d.isZERO()) {
            return true;
        }
        if (d.abs().compareTo(eps) <= 0) {
            return true;
        }
        System.out.println("x     = " + x);
        System.out.println("d     = " + d);
        return false;
    }

    public boolean isApproximateRoot(List<BigDecimal> R, GenPolynomial<C> f, C eps) {
        if (R == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return true;
        }
        BigDecimal e = new BigDecimal(((Rational)eps).getRational());
        e = e.multiply(new BigDecimal("1000"));
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(dc, f.ring);
        GenPolynomial<BigDecimal> df = PolyUtil.decimalFromRational(dfac, f);
        GenPolynomial<C> fp = PolyUtil.baseDeriviative(f);
        GenPolynomial<BigDecimal> dfp = PolyUtil.decimalFromRational(dfac, fp);
        for (BigDecimal x : R) {
            if (this.isApproximateRoot(x, df, dfp, e)) continue;
            return false;
        }
        return true;
    }
}

