/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.root.Interval;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.RealRootAbstract;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.Power;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RealRootTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    BigRational eps;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 1;
    int kl = 5;
    int ll = 7;
    int el = 7;
    float q = 0.7f;

    public static void main(String[] args) {
        TestRunner.run((Test)RealRootTest.suite());
    }

    public RealRootTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RealRootTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        String[] vars = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, vars);
        this.eps = Power.positivePower(new BigRational(1L, 10L), 50L);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.eps = null;
    }

    public void testSturmSequence() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        RealRootsSturm<BigRational> rrs = new RealRootsSturm<BigRational>();
        List<GenPolynomial<BigRational>> S = rrs.sturmSequence(this.a);
        try {
            this.b = this.a.remainder(S.get(0));
        }
        catch (Exception e) {
            RealRootTest.fail((String)("not S(0)|f " + e));
        }
        RealRootTest.assertTrue((String)"a mod S(0) == 0 ", (boolean)this.b.isZERO());
        RealRootTest.assertTrue((String)"S(-1) == 1 ", (boolean)S.get(S.size() - 1).isConstant());
    }

    public void testRootBound() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        BigRational M = rr.realRootBound(this.a);
        RealRootTest.assertTrue((String)"M >= 1 ", (M.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
        this.a = this.a.monic();
        M = rr.realRootBound(this.a);
        RealRootTest.assertTrue((String)"M >= 1 ", (M.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
    }

    public void testRealRootIsolation() {
        this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 2, this.q);
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> R = rr.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots >= 0 ", (R.size() >= 0 ? 1 : 0) != 0);
    }

    public void testRealRootIsolationWilkinson() {
        int N2 = 10;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        int i = 0;
        while (i < 10) {
            this.c = this.dfac.fromInteger(i);
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        List<Interval<Object>> R = rr.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 10 ", (R.size() == 10 ? 1 : 0) != 0);
        BigDecimal eps1 = new BigDecimal(this.eps);
        R = rr.refineIntervals(R, this.a, this.eps);
        int i2 = 0;
        for (Interval<Object> interval : R) {
            BigDecimal di;
            BigDecimal dd = interval.toDecimal();
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.compareTo(di = ((Interval)Rn.get(i2++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }

    public void testRealRootIsolationWilkinsonInverse() {
        int N2 = 9;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(9);
        this.a = this.d;
        int i = 1;
        while (i < 9) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        Collections.reverse(Rn);
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        List<Interval<Object>> R = rr.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 8 ", (R.size() == 8 ? 1 : 0) != 0);
        BigDecimal eps1 = new BigDecimal(this.eps);
        R = rr.refineIntervals(R, this.a, this.eps);
        int i2 = 0;
        for (Interval<Object> v : R) {
            BigDecimal di;
            BigDecimal dd = v.toDecimal();
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.compareTo(di = ((Interval)Rn.get(i2++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }

    public void testRealAlgebraicNumberSign() {
        int asn;
        this.d = this.dfac.fromInteger(2L);
        this.e = this.dfac.univariate(0);
        this.a = this.e.multiply((BigRational)((Object)this.e));
        this.a = this.a.subtract((BigRational)((Object)this.d));
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        this.ai = new BigRational(1L);
        this.bi = new BigRational(2L);
        Interval<BigRational> iv = new Interval<BigRational>(this.ai, this.bi);
        RealRootTest.assertTrue((String)"sign change", (boolean)rr.signChange(iv, this.a));
        this.b = this.dfac.random(this.kl, (int)this.a.degree() + 1, (int)this.a.degree(), 1.0f);
        if (this.b.isZERO()) {
            int s = rr.realSign(iv, this.a, this.b);
            RealRootTest.assertTrue((String)"algebraic sign", (s == 0 ? 1 : 0) != 0);
            return;
        }
        int as = rr.realSign(iv, this.a, this.b);
        RealRootTest.assertTrue((String)"algebraic sign", (as != (asn = rr.realSign(iv, this.a, (GenPolynomial<BigRational>)this.b.negate())) ? 1 : 0) != 0);
        iv = new Interval<BigRational>(this.bi.negate(), this.ai.negate());
        RealRootTest.assertTrue((String)"sign change", (boolean)rr.signChange(iv, this.a));
        int as1 = rr.realSign(iv, this.a, this.b);
        int asn1 = rr.realSign(iv, this.a, (GenPolynomial<BigRational>)this.b.negate());
        RealRootTest.assertTrue((String)"algebraic sign", (as1 != asn1 ? 1 : 0) != 0);
        RealRootTest.assertTrue((String)"algebraic sign", (as * as1 == asn * asn1 ? 1 : 0) != 0);
    }

    public void testRealRootIsolationDecimalWilkinson() {
        int N2 = 10;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        int i = 0;
        while (i < 10) {
            this.c = this.dfac.fromInteger(i);
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> R = ((RealRootAbstract)rr).realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 10 ", (R.size() == 10 ? 1 : 0) != 0);
        this.eps = this.eps.multiply(new BigRational(10000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("100"));
        try {
            int i2 = 0;
            for (Interval<BigRational> v : R) {
                BigDecimal di;
                BigDecimal dd = rr.approximateRoot(v, this.a, this.eps);
                RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.subtract(di = ((Interval)Rn.get(i2++)).toDecimal()).abs().compareTo(eps2) <= 0 ? 1 : 0) != 0);
            }
        }
        catch (NoConvergenceException e) {
            RealRootTest.fail((String)e.toString());
        }
    }

    public void testRealRootIsolationDecimalWilkinsonInverse() {
        int N2 = 10;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        int i = 1;
        while (i < 10) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        Collections.reverse(Rn);
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> R = ((RealRootAbstract)rr).realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 9 ", (R.size() == 9 ? 1 : 0) != 0);
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        try {
            int i2 = 0;
            for (Interval<BigRational> v : R) {
                BigDecimal di;
                BigDecimal dd = rr.approximateRoot(v, this.a, this.eps);
                RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.subtract(di = ((Interval)Rn.get(i2++)).toDecimal()).abs().compareTo(eps2) <= 0 ? 1 : 0) != 0);
            }
        }
        catch (NoConvergenceException e) {
            RealRootTest.fail((String)e.toString());
        }
    }

    public void testRealRootIsolationDecimalWilkinsonAll() {
        int N2 = 10;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        int i = 0;
        while (i < 10) {
            this.c = this.dfac.fromInteger(i);
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        this.eps = this.eps.multiply(new BigRational(10000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("100"));
        List<BigDecimal> R = null;
        R = rr.approximateRoots(this.a, this.eps);
        RealRootTest.assertTrue((String)"#roots = 10 ", (R.size() == 10 ? 1 : 0) != 0);
        int i2 = 0;
        for (BigDecimal dd : R) {
            BigDecimal di;
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.subtract(di = ((Interval)Rn.get(i2++)).toDecimal()).abs().compareTo(eps2) <= 0 ? 1 : 0) != 0);
        }
        boolean t = rr.isApproximateRoot(R, this.a, this.eps);
        RealRootTest.assertTrue((String)"some |a(dd)| < eps ", (boolean)t);
    }

    public void testRealRootIsolationDecimalWilkinsonInverseAll() {
        int N2 = 10;
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> Rn = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        int i = 1;
        while (i < 10) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            Rn.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
            ++i;
        }
        Collections.reverse(Rn);
        RealRootsSturm<BigRational> rr = new RealRootsSturm<BigRational>();
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal eps1 = new BigDecimal(this.eps);
        BigDecimal eps2 = eps1.multiply(new BigDecimal("10"));
        List<BigDecimal> R = null;
        R = rr.approximateRoots(this.a, this.eps);
        RealRootTest.assertTrue((String)"#roots = 9 ", (R.size() == 9 ? 1 : 0) != 0);
        int i2 = 0;
        for (BigDecimal dd : R) {
            BigDecimal di;
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (dd.subtract(di = ((Interval)Rn.get(i2++)).toDecimal()).abs().compareTo(eps2) <= 0 ? 1 : 0) != 0);
        }
        boolean t = rr.isApproximateRoot(R, this.a, this.eps);
        RealRootTest.assertTrue((String)"some |a(dd)| < eps ", (boolean)t);
    }
}

