/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.RealRootAbstract;
import edu.jas.root.RootUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RealRootsSturm<C extends RingElem<C> & Rational>
extends RealRootAbstract<C> {
    private static final Logger logger = Logger.getLogger(RealRootsSturm.class);
    private static boolean debug = logger.isDebugEnabled();

    public List<GenPolynomial<C>> sturmSequence(GenPolynomial<C> f) {
        ArrayList<GenPolynomial<C>> S = new ArrayList<GenPolynomial<C>>();
        if (f == null || f.isZERO()) {
            return S;
        }
        if (f.isConstant()) {
            S.add(f.monic());
            return S;
        }
        GenPolynomial<C> F2 = f;
        S.add(F2);
        AbelianGroupElem<GenPolynomial<C>> G = PolyUtil.baseDeriviative(f);
        while (!G.isZERO()) {
            GenPolynomial<C> r = F2.remainder((GenPolynomial<C>)G);
            F2 = G;
            G = r.negate();
            S.add(F2);
        }
        if (F2.isConstant()) {
            return S;
        }
        ArrayList<GenPolynomial<C>> Sp = new ArrayList<GenPolynomial<C>>(S.size());
        for (GenPolynomial<C> p : S) {
            p = p.divide(F2);
            Sp.add(p);
        }
        return Sp;
    }

    @Override
    public List<Interval<C>> realRoots(GenPolynomial<C> f) {
        ArrayList<Interval<C>> R = new ArrayList<Interval<C>>();
        if (f == null) {
            return R;
        }
        if (f.isZERO()) {
            RingElem z = (RingElem)f.ring.coFac.getZERO();
            R.add(new Interval<RingElem>(z));
            return R;
        }
        GenPolynomial<C> F2 = f;
        C M = this.realRootBound(F2);
        Interval<RingElem> iv = new Interval<RingElem>((RingElem)M.negate(), (RingElem)M);
        List<GenPolynomial<C>> S = this.sturmSequence(F2);
        List<Interval<RingElem>> Rp = this.realRoots(iv, S);
        R.addAll(Rp);
        return R;
    }

    @Override
    public List<Interval<C>> realRoots(Interval<C> iv, List<GenPolynomial<C>> S) {
        ArrayList<Interval<C>> R = new ArrayList<Interval<C>>();
        GenPolynomial<C> f = S.get(0);
        long v = this.realRootCount(iv, S);
        if (v == 0L) {
            return R;
        }
        if (v == 1L) {
            R.add(iv);
            return R;
        }
        C c = this.bisectionPoint(iv, f);
        Interval iv1 = new Interval(iv.left, c);
        Interval<C> iv2 = new Interval<C>(c, iv.right);
        List R1 = this.realRoots(iv1, S);
        if (debug) {
            logger.info((Object)("R1 = " + R1));
        }
        List<Interval<C>> R2 = this.realRoots(iv2, S);
        if (debug) {
            logger.info((Object)("R2 = " + R2));
        }
        if (R1.isEmpty()) {
            R.addAll(R2);
            return R;
        }
        if (R2.isEmpty()) {
            R.addAll(R1);
            return R;
        }
        iv1 = R1.get(R1.size() - 1);
        iv2 = R2.get(0);
        if (iv1.right.compareTo(iv2.left) < 0) {
            R.addAll(R1);
            R.addAll(R2);
            return R;
        }
        R1.remove(iv1);
        R2.remove(iv2);
        while (iv1.right.equals(iv2.left)) {
            Object d1 = this.bisectionPoint(iv1, f);
            C d2 = this.bisectionPoint(iv2, f);
            Interval iv11 = new Interval(iv1.left, d1);
            Interval iv12 = new Interval(d1, iv1.right);
            Interval iv21 = new Interval(iv2.left, d2);
            Interval<C> iv22 = new Interval<C>(d2, iv2.right);
            boolean b11 = this.signChange(iv11, f);
            boolean b12 = this.signChange(iv12, f);
            boolean b21 = this.signChange(iv21, f);
            boolean b22 = this.signChange(iv22, f);
            if (b11) {
                iv1 = iv11;
                if (b22) {
                    iv2 = iv22;
                    break;
                }
                iv2 = iv21;
                break;
            }
            if (b22) {
                iv2 = iv22;
                if (b12) {
                    iv1 = iv12;
                    break;
                }
                iv1 = iv11;
                break;
            }
            iv1 = iv12;
            iv2 = iv21;
        }
        R.addAll(R1);
        R.add(iv1);
        R.add(iv2);
        R.addAll(R2);
        return R;
    }

    @Override
    public long realRootCount(Interval<C> iv, List<GenPolynomial<C>> S) {
        GenPolynomial<C> f = S.get(0);
        RingFactory cfac = f.ring.coFac;
        List l = PolyUtil.evaluateMain(cfac, S, iv.left);
        List r = PolyUtil.evaluateMain(cfac, S, iv.right);
        long v = RootUtil.signVar(l) - RootUtil.signVar(r);
        if (v < 0L) {
            v = -v;
        }
        return v;
    }

    @Override
    public long realRootCount(Interval<C> iv, GenPolynomial<C> f) {
        if (f == null || f.isZERO() || f.isConstant()) {
            return 0L;
        }
        List<GenPolynomial<C>> S = this.sturmSequence(f);
        return this.realRootCount(iv, S);
    }

    @Override
    public Interval<C> invariantSignInterval(Interval<C> iv, GenPolynomial<C> f, GenPolynomial<C> g) {
        Interval<Object> v = iv;
        if (g == null || g.isZERO()) {
            return v;
        }
        if (g.isConstant()) {
            return v;
        }
        if (f == null || f.isZERO() || f.isConstant()) {
            return v;
        }
        RingFactory cfac = f.ring.coFac;
        RingElem two = (RingElem)cfac.fromInteger(2L);
        List<GenPolynomial<C>> Sg = this.sturmSequence(g);
        g = Sg.get(0);
        long n;
        while ((n = this.realRootCount(v, Sg)) != 0L) {
            RingElem c = (RingElem)v.left.sum(v.right);
            Interval<RingElem> im = new Interval<RingElem>(c = c.divide(two), (RingElem)v.right);
            if (this.signChange(im, f)) {
                v = im;
                continue;
            }
            v = new Interval<RingElem>((RingElem)v.left, c);
        }
        return v;
    }
}

