/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;

public class Rectangle<C extends RingElem<C> & Rational> {
    public final Complex<C>[] corners;

    public Rectangle(Complex<C>[] c) {
        if (c.length < 5) {
            this.corners = new Complex[5];
            int i = 0;
            while (i < 4) {
                this.corners[i] = c[i];
                ++i;
            }
        } else {
            this.corners = c;
        }
        if (this.corners[4] == null) {
            this.corners[4] = this.corners[0];
        }
    }

    public Rectangle(Complex<C> nw, Complex<C> sw, Complex<C> se, Complex<C> ne) {
        this(new Complex[]{nw, sw, se, ne});
    }

    public String toString() {
        return "[" + this.corners[0] + ", " + this.corners[1] + ", " + this.corners[2] + ", " + this.corners[3] + "]";
    }

    public String toScript() {
        return "(" + this.corners[0] + ", " + this.corners[1] + ", " + this.corners[2] + ", " + this.corners[3] + ")";
    }

    public Complex<C> getNW() {
        return this.corners[0];
    }

    public Complex<C> getSW() {
        return this.corners[1];
    }

    public Complex<C> getSE() {
        return this.corners[2];
    }

    public Complex<C> getNE() {
        return this.corners[3];
    }

    public Rectangle<C> exchangeNW(Complex<C> c) {
        Complex<C> d = this.getSE();
        Complex<C> sw = new Complex<C>(c.factory(), c.getRe(), d.getIm());
        Complex<C> ne = new Complex<C>(c.factory(), d.getRe(), c.getIm());
        return new Rectangle<C>(c, sw, d, ne);
    }

    public Rectangle<C> exchangeSW(Complex<C> c) {
        Complex<C> d = this.getNE();
        Complex<C> nw = new Complex<C>(c.factory(), c.getRe(), d.getIm());
        Complex<C> se = new Complex<C>(c.factory(), d.getRe(), c.getIm());
        return new Rectangle<C>(nw, c, se, d);
    }

    public Rectangle<C> exchangeSE(Complex<C> c) {
        Complex<C> d = this.getNW();
        Complex<C> sw = new Complex<C>(c.factory(), d.getRe(), c.getIm());
        Complex<C> ne = new Complex<C>(c.factory(), c.getRe(), d.getIm());
        return new Rectangle<C>(d, sw, c, ne);
    }

    public Rectangle<C> exchangeNE(Complex<C> c) {
        Complex<C> d = this.getSW();
        Complex<C> nw = new Complex<C>(c.factory(), d.getRe(), c.getIm());
        Complex<C> se = new Complex<C>(c.factory(), c.getRe(), d.getIm());
        return new Rectangle<C>(nw, d, se, c);
    }

    public boolean contains(Complex<C> c) {
        Complex<C> ll = this.getSW();
        Complex<C> ur = this.getSW();
        return c.getRe().compareTo(ll.getRe()) < 0 || c.getIm().compareTo(ll.getIm()) < 0 || c.getRe().compareTo(ur.getRe()) > 0 || c.getIm().compareTo(ur.getIm()) > 0;
    }

    public Complex<C> randomPoint() {
        Complex<RingElem> sw = this.getSW();
        Complex<C> se = this.getSE();
        Complex<C> nw = this.getNW();
        Element r = ((ComplexRing)sw.factory()).random(13);
        RingElem dr = (RingElem)se.getRe().subtract(sw.getRe());
        RingElem di = (RingElem)nw.getIm().subtract(sw.getIm());
        RingElem rr = (RingElem)((Complex)r).getRe().abs();
        RingElem ri = (RingElem)((Complex)r).getIm().abs();
        RingElem one = (RingElem)((RingFactory)dr.factory()).getONE();
        if (!rr.isZERO() && rr.compareTo(one) > 0) {
            rr = (RingElem)rr.inverse();
        }
        if (!ri.isZERO() && ri.compareTo(one) > 0) {
            ri = (RingElem)ri.inverse();
        }
        rr = rr.multiply(dr);
        ri = ri.multiply(di);
        Complex<RingElem> rp = new Complex<RingElem>((ComplexRing<RingElem>)sw.factory(), rr, ri);
        rp = sw.sum(rp);
        return rp;
    }

    public Rectangle<C> clone() {
        return new Rectangle<C>(this.corners);
    }

    public boolean equals(Object b) {
        if (!(b instanceof Rectangle)) {
            return false;
        }
        Rectangle a = null;
        try {
            a = (Rectangle)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int i = 0;
        while (i < 4) {
            if (!this.corners[i].equals(a.corners[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        int i = 0;
        while (i < 3) {
            hc += 37 * this.corners[i].hashCode();
            ++i;
        }
        return 37 * hc + this.corners[3].hashCode();
    }

    public Complex<C> getCenter() {
        RingElem r = (RingElem)this.corners[2].getRe().subtract(this.corners[1].getRe());
        RingElem m = (RingElem)this.corners[0].getIm().subtract(this.corners[1].getIm());
        ElemFactory rf = r.factory();
        RingElem two = (RingElem)rf.fromInteger(2L);
        r = r.divide(two);
        m = m.divide(two);
        r = this.corners[1].getRe().sum((RingElem)r);
        m = this.corners[1].getIm().sum((RingElem)m);
        return new Complex<RingElem>((ComplexRing<RingElem>)this.corners[0].factory(), r, m);
    }

    public Complex<BigRational> getRationalCenter() {
        Complex<C> cm = this.getCenter();
        BigRational rs = ((Rational)cm.getRe()).getRational();
        BigRational ms = ((Rational)cm.getIm()).getRational();
        ComplexRing<BigRational> cf = new ComplexRing<BigRational>(rs.factory());
        Complex<BigRational> c = new Complex<BigRational>(cf, rs, ms);
        return c;
    }

    public Complex<BigDecimal> getDecimalCenter() {
        Complex<BigRational> rc = this.getRationalCenter();
        BigDecimal rd = new BigDecimal(rc.getRe());
        BigDecimal md = new BigDecimal(rc.getIm());
        ComplexRing<BigDecimal> cf = new ComplexRing<BigDecimal>(rd.factory());
        Complex<BigDecimal> c = new Complex<BigDecimal>(cf, rd, md);
        return c;
    }

    public String centerApprox() {
        Complex<BigDecimal> c = this.getDecimalCenter();
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        s.append(c.getRe().toString());
        s.append(" i ");
        s.append(c.getIm().toString());
        s.append(" ]");
        return s.toString();
    }

    public C length() {
        Complex<C> m = this.corners[3].subtract(this.corners[1]);
        return ((Complex)m.norm()).getRe();
    }

    public BigRational rationalLength() {
        BigRational r = new BigRational(this.length().toString());
        return r;
    }
}

