/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RootFactory {
    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> f) {
        RealRootsSturm<C> rr = new RealRootsSturm<C>();
        SquarefreeAbstract<GenPolynomial<C>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        Set<GenPolynomial<C>> S = engine.squarefreeFactors(f).keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial<C> sp : S) {
            List<Interval<C>> iv = rr.realRoots(sp);
            for (Interval<C> I2 : iv) {
                RealAlgebraicRing<C> rar = new RealAlgebraicRing<C>(sp, I2);
                RealAlgebraicNumber<C> rn = rar.getGenerator();
                list.add(rn);
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> f) {
        RealRootsSturm rr = new RealRootsSturm();
        FactorAbstract<C> engine = FactorFactory.getImplementation(f.ring.coFac);
        Set S = engine.baseFactors(f).keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = rr.realRoots(sp);
            for (Interval I2 : iv) {
                RealAlgebraicRing rar = new RealAlgebraicRing(sp, I2, true);
                RealAlgebraicNumber rn = rar.getGenerator();
                list.add(rn);
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> f) {
        RealRootsSturm<C> rr = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> iv = rr.realRoots(f);
        for (Interval<C> I2 : iv) {
            RealAlgebraicRing<C> rar = new RealAlgebraicRing<C>(f, I2, true);
            RealAlgebraicNumber<C> rn = rar.getGenerator();
            list.add(rn);
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<Complex<C>> f) {
        ComplexRootsSturm<C> cr = new ComplexRootsSturm<C>(f.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        Set<GenPolynomial<Complex<C>>> S = engine.squarefreeFactors(f).keySet();
        ArrayList<ComplexAlgebraicNumber<C>> list = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (GenPolynomial<Complex<C>> sp : S) {
            List<Rectangle<C>> iv = cr.complexRoots(sp);
            for (Rectangle<C> I2 : iv) {
                ComplexAlgebraicRing<C> car = new ComplexAlgebraicRing<C>(sp, I2);
                ComplexAlgebraicNumber<C> cn = car.getGenerator();
                list.add(cn);
            }
        }
        return list;
    }
}

