/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RootFactory;
import edu.jas.root.RootUtil;
import edu.jas.structure.Power;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RootUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    BigRational eps;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 1;
    int kl = 5;
    int ll = 7;
    int el = 7;
    float q = 0.7f;

    public static void main(String[] args) {
        TestRunner.run((Test)RootUtilTest.suite());
    }

    public RootUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RootUtilTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        String[] vars = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, vars);
        this.eps = Power.positivePower(new BigRational(1L, 10L), 50L);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.eps = null;
        ComputerThreads.terminate();
    }

    public void testSignVar() {
        int[] nArray = new int[12];
        nArray[0] = 1;
        nArray[3] = -1;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[7] = 1;
        nArray[11] = -1;
        int[] li = nArray;
        ArrayList<BigRational> Li = new ArrayList<BigRational>();
        this.ai = new BigRational();
        int i = 0;
        while (i < li.length) {
            this.bi = this.ai.fromInteger(li[i]);
            Li.add(this.bi);
            ++i;
        }
        long v = RootUtil.signVar(Li);
        RootUtilTest.assertEquals((String)"varSign(Li)", (long)v, (long)3L);
        ArrayList<BigRational> Mi = new ArrayList<BigRational>();
        int i2 = 0;
        while (i2 < 7) {
            this.bi = this.ai.random(this.kl);
            Mi.add(this.bi);
            ++i2;
        }
        long vv = v = RootUtil.signVar(Mi);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=0", (v >= 0L ? 1 : 0) != 0);
        ArrayList<BigRational> Ni = new ArrayList<BigRational>(Mi);
        Ni.addAll(Li);
        v = RootUtil.signVar(Ni);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=3", (v >= 3L + vv ? 1 : 0) != 0);
        Ni = new ArrayList(Ni);
        Ni.addAll(Mi);
        v = RootUtil.signVar(Ni);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=3", (v >= 3L + vv ? 1 : 0) != 0);
    }

    public void testRealAlgebraicFactory() {
        this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 2, this.q);
        List<RealAlgebraicNumber<BigRational>> lrn = RootFactory.realAlgebraicNumbers(this.a);
        RootUtilTest.assertTrue((String)"#roots >= 0 ", (lrn.size() >= 0 ? 1 : 0) != 0);
    }

    public void testComplexAlgebraicFactory() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        ComplexRing<BigRational> cf = new ComplexRing<BigRational>(new BigRational());
        GenPolynomialRing<BigRational> cfac = new GenPolynomialRing<BigRational>(cf, this.dfac);
        GenPolynomial ca = PolyUtil.toComplex(cfac, this.a);
        List lcn = RootFactory.complexAlgebraicNumbers(ca);
        RootUtilTest.assertTrue((String)"#roots == deg(a) ", ((long)lcn.size() == this.a.degree(0) ? 1 : 0) != 0);
    }
}

