/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import org.apache.log4j.BasicConfigurator;

public class Examples {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Examples.example10();
        ComputerThreads.terminate();
    }

    public static void example6() {
        System.out.println("\n\nexample 6");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D2 = pfac.parse("x^7 + x + 1");
        GenPolynomial N2 = PolyUtil.baseDeriviative(D2);
        FactorRational engine = new FactorRational();
        PartialFraction F2 = engine.baseAlgebraicPartialFraction(N2, D2);
        System.out.println("\nintegral " + F2);
    }

    public static void example9() {
        System.out.println("\n\nexample 9");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D2 = pfac.parse("( x^5 + x - 7 )");
        MonoidElem N2 = pfac.getONE();
        FactorRational engine = new FactorRational();
        PartialFraction F2 = engine.baseAlgebraicPartialFraction(N2, D2);
        System.out.println("\nintegral " + F2);
    }

    public static void example10() {
        System.out.println("\n\nexample 10");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] var_w2 = new String[]{"w2"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, var_w2);
        System.out.println("pfac   = " + pfac.toScript());
        Element w2 = pfac.parse(" w2^2 - 2 ");
        System.out.println("w2     = " + w2);
        AlgebraicNumberRing a2fac = new AlgebraicNumberRing(w2, true);
        System.out.println("a2fac  = " + a2fac.toScript());
        String[] var_x = new String[]{"x"};
        GenPolynomialRing apfac = new GenPolynomialRing(a2fac, 1, to, var_x);
        System.out.println("apfac  = " + apfac.toScript());
        QuotientRing qfac = new QuotientRing(apfac);
        System.out.println("qfac   = " + qfac.toScript());
        String[] var_wx = new String[]{"wx"};
        GenPolynomialRing pqfac = new GenPolynomialRing(qfac, 1, to, var_wx);
        System.out.println("pqfac  = " + pqfac.toScript());
        Element wx = pqfac.parse(" wx^2 - { x } ");
        System.out.println("wx     = " + wx);
        AlgebraicNumberRing axfac = new AlgebraicNumberRing(wx, true);
        System.out.println("axfac  = " + axfac.toScript());
        String[] var_y = new String[]{"y"};
        GenPolynomialRing apqfac = new GenPolynomialRing(axfac, 1, to, var_y);
        System.out.println("apqfac = " + apqfac.toScript());
        Element f = apqfac.parse(" ( y^2 - { { x } } ) * ( y^2 - 2 )^2 ");
        System.out.println("f      = " + f);
        FactorAbstract engine = FactorFactory.getImplementation(axfac);
        System.out.println("engine = " + engine);
        SortedMap F2 = engine.factors(f);
        System.out.println("factors(f) = " + F2);
    }
}

