/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.TimeStatus;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Factorization;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class FactorAbstract<C extends GcdRingElem<C>>
implements Factorization<C> {
    private static final Logger logger = Logger.getLogger(FactorAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SquarefreeAbstract<C> sengine;

    protected FactorAbstract() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbstract(RingFactory<C> cfac) {
        this.engine = GCDFactory.getProxy(cfac);
        this.sengine = SquarefreeFactory.getImplementation(cfac);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean isIrreducible(GenPolynomial<C> P) {
        if (!this.isSquarefree(P)) {
            return false;
        }
        List<GenPolynomial<C>> F2 = this.factorsSquarefree(P);
        if (F2.size() == 1) {
            return true;
        }
        if (F2.size() > 2) {
            return false;
        }
        boolean cnst = false;
        for (GenPolynomial<C> p : F2) {
            if (!p.isConstant()) continue;
            cnst = true;
        }
        return cnst;
    }

    @Override
    public boolean isReducible(GenPolynomial<C> P) {
        return !this.isIrreducible(P);
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> P) {
        GenPolynomial<C> S = this.squarefreePart(P);
        GenPolynomial<C> Ps = this.basePrimitivePart(P);
        return Ps.equals(S);
    }

    @Override
    public List<GenPolynomial<C>> factorsSquarefree(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList<GenPolynomial<C>> factors = new ArrayList<GenPolynomial<C>>();
        if (P.isZERO()) {
            return factors;
        }
        long d = P.degree() + 1L;
        GenPolynomial<C> kr = PolyUfdUtil.substituteKronecker(P, d);
        GenPolynomialRing ufac = kr.ring;
        ufac.setVars(ufac.newVars("zz"));
        if (this.debug) {
            logger.info((Object)("subs(P,d=" + d + ") = " + kr));
        }
        if (kr.degree(0) > 100L) {
            logger.warn((Object)"Kronecker substitution has to high degree");
            TimeStatus.checkTime("degree > 100");
        }
        List ulist = new ArrayList<GenPolynomial<C>>();
        SortedMap<GenPolynomial<C>, Long> slist = this.baseFactors(kr);
        if (this.debug && !this.isFactorization(kr, slist)) {
            System.out.println("kr    = " + kr);
            System.out.println("slist = " + slist);
            throw new ArithmeticException("no factorization");
        }
        for (GenPolynomial<C> g : slist.keySet()) {
            long e = (Long)slist.get(g);
            int i = 0;
            while ((long)i < e) {
                ulist.add(g);
                ++i;
            }
        }
        if (ulist.size() == 1 && ((GenPolynomial)ulist.get(0)).degree() == P.degree()) {
            factors.add(P);
            return factors;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ulist = " + ulist));
        }
        int dl = ulist.size() - 1;
        int ti = 0;
        GenPolynomial<C> u = P;
        long deg = (u.degree() + 1L) / 2L;
        int j = 1;
        while (j <= dl) {
            KsubSet ps = new KsubSet(ulist, j);
            for (List flist : ps) {
                GenPolynomial<C> rem;
                GenPolynomial<GenPolynomial> utrial = ufac.getONE();
                int k = 0;
                while (k < flist.size()) {
                    utrial = utrial.multiply((GenPolynomial)flist.get(k));
                    ++k;
                }
                GenPolynomial trial = PolyUfdUtil.backSubstituteKronecker(pfac, utrial, d);
                if (trial.degree() > deg || trial.isConstant()) continue;
                trial = trial.monic();
                if (++ti % 1000 == 0) {
                    System.out.print("ti(" + ti + ") ");
                    TimeStatus.checkTime(String.valueOf(ti) + " % 1000 == 0");
                    if (ti % 10000 == 0) {
                        System.out.println("\ndl   = " + dl + ", deg(u) = " + deg);
                        System.out.println("ulist = " + ulist);
                        System.out.println("kr    = " + kr);
                        System.out.println("u     = " + u);
                    }
                }
                if (!(rem = PolyUtil.basePseudoRemainder(u, trial)).isZERO()) continue;
                logger.info((Object)("trial = " + trial));
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                if (u.isConstant()) {
                    j = dl + 1;
                    break;
                }
                if ((ulist = FactorAbstract.removeOnce(ulist, flist)) == null) continue;
                dl = (ulist.size() + 1) / 2;
                j = 0;
                break;
            }
            ++j;
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred u = " + u));
            factors.add(P);
        }
        return factors;
    }

    private static <T> List<T> removeOnce(List<T> a, List<T> b) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(a);
        for (T e : b) {
            boolean bl = res.remove(e);
        }
        return res;
    }

    public List<GenPolynomial<C>> baseFactorsRadical(GenPolynomial<C> P) {
        return new ArrayList<GenPolynomial<C>>(this.baseFactors(P).keySet());
    }

    public SortedMap<GenPolynomial<C>, Long> baseFactors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " only for univariate polynomials");
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("base facs for P = " + P));
        }
        if ((facs = this.sengine.baseSquarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
        }
        if (logger.isInfoEnabled() && (facs.size() > 1 || facs.size() == 1 && (Long)facs.get(facs.firstKey()) > 1L)) {
            logger.info((Object)("squarefree facs   = " + facs));
        }
        for (GenPolynomial<C> g : facs.keySet()) {
            Long k = (Long)facs.get(g);
            if (pfac.coFac.isField() && !((GcdRingElem)g.leadingBaseCoefficient()).isONE()) {
                g = g.monic();
                logger.warn((Object)("squarefree facs mon = " + g));
            }
            if (g.degree(0) <= 1L) {
                if (g.isONE()) continue;
                factors.put(g, k);
                continue;
            }
            List<GenPolynomial<C>> sfacs = this.baseFactorsSquarefree(g);
            if (this.debug) {
                logger.info((Object)("factors of squarefree = " + sfacs));
            }
            for (GenPolynomial<C> h : sfacs) {
                Long j = (Long)factors.get(h);
                if (j != null) {
                    k = k + j;
                }
                if (h.isONE()) continue;
                factors.put(h, k);
            }
        }
        return factors;
    }

    public abstract List<GenPolynomial<C>> baseFactorsSquarefree(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> factorsRadical(GenPolynomial<C> P) {
        return new ArrayList<GenPolynomial<C>>(this.factors(P).keySet());
    }

    @Override
    public List<GenPolynomial<C>> factorsRadical(List<GenPolynomial<C>> L) {
        TreeSet<GenPolynomial<C>> facs = new TreeSet<GenPolynomial<C>>();
        for (GenPolynomial<C> p : L) {
            List<GenPolynomial<C>> fs = this.factorsRadical(p);
            facs.addAll(fs);
        }
        return new ArrayList<GenPolynomial<C>>(facs);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> factors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("squarefree mfacs P = " + P));
        }
        if ((facs = this.sengine.squarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
        }
        if (logger.isInfoEnabled()) {
            if (facs.size() > 1) {
                logger.info((Object)("squarefree mfacs   = " + facs));
            } else if (facs.size() == 1 && (Long)facs.get(facs.firstKey()) > 1L) {
                logger.info((Object)("squarefree mfacs   = " + facs));
            } else {
                logger.warn((Object)("squarefree mfacs empty = " + facs));
            }
        }
        for (GenPolynomial<C> g : facs.keySet()) {
            Long d = (Long)facs.get(g);
            List<GenPolynomial<C>> sfacs = this.factorsSquarefree(g);
            if (this.debug) {
                logger.info((Object)("factors of squarefree = " + sfacs));
            }
            for (GenPolynomial<C> h : sfacs) {
                Long j = (Long)factors.get(h);
                if (j != null) {
                    d = d + j;
                }
                factors.put(h, d);
            }
        }
        return factors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        return this.sengine.squarefreePart(P);
    }

    public GenPolynomial<C> primitivePart(GenPolynomial<C> P) {
        return this.engine.primitivePart(P);
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> P) {
        return this.engine.basePrimitivePart(P);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        return this.sengine.squarefreeFactors(P);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, List<GenPolynomial<C>> F2) {
        return this.sengine.isFactorization(P, F2);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F2) {
        return this.sengine.isFactorization(P, F2);
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> P, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> F2) {
        return this.sengine.isRecursiveFactorization(P, F2);
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursiveFactorsSquarefree(GenPolynomial<GenPolynomial<C>> P) {
        GenPolynomialRing pfac;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P == null");
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> factors = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing qi = (GenPolynomialRing)pfac.coFac;
        pfac = P.ring;
        GenPolynomialRing ifac = qi.extend(pfac.getVars());
        GenPolynomial Pi2 = PolyUtil.distribute(ifac, P);
        GcdRingElem ldcf = (GcdRingElem)Pi2.leadingBaseCoefficient();
        if (!ldcf.isONE() && ldcf.isUnit()) {
            Pi2 = Pi2.monic();
        }
        List ifacts = this.factorsSquarefree(Pi2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + ifacts));
        }
        if (ifacts.size() <= 1) {
            factors.add(P);
            return factors;
        }
        if (!ldcf.isONE() && ldcf.isUnit()) {
            GenPolynomial<GcdRingElem> r = ifacts.get(0);
            ifacts.remove(r);
            r = r.multiply(ldcf);
            ifacts.add(0, r);
        }
        List rfacts = PolyUtil.recursive(pfac, ifacts);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("rfacts = " + rfacts));
        }
        factors.addAll(rfacts);
        return factors;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveFactors(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> factors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.put(P, 1L);
            return factors;
        }
        GenPolynomialRing qi = (GenPolynomialRing)pfac.coFac;
        GenPolynomialRing ifac = qi.extend(pfac.getVars());
        GenPolynomial Pi2 = PolyUtil.distribute(ifac, P);
        GcdRingElem ldcf = (GcdRingElem)Pi2.leadingBaseCoefficient();
        if (!ldcf.isONE() && ldcf.isUnit()) {
            Pi2 = Pi2.monic();
        }
        SortedMap dfacts = this.factors(Pi2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dfacts = " + dfacts));
        }
        if (!ldcf.isONE() && ldcf.isUnit()) {
            GenPolynomial<GcdRingElem> r = dfacts.firstKey();
            Long E2 = (Long)dfacts.remove(r);
            r = r.multiply(ldcf);
            dfacts.put(r, E2);
        }
        for (GenPolynomial f : dfacts.keySet()) {
            Long E3 = (Long)dfacts.get(f);
            GenPolynomial rp = PolyUtil.recursive(pfac, f);
            factors.put(rp, E3);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("factors = " + factors));
        }
        return factors;
    }
}

