/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.PolyUfdUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorAlgebraic<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorAlgebraic.class);
    private final boolean debug;
    public final FactorAbstract<C> factorCoeff;

    protected FactorAlgebraic() {
        this.debug = true;
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> fac) {
        super(fac);
        this.debug = true;
        this.factorCoeff = FactorFactory.getImplementation(fac.ring.coFac);
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> P) {
        long k;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        AlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        long ks = k = 0L;
        GenPolynomial<C> res = null;
        boolean sqf = false;
        int[] nArray = new int[7];
        nArray[1] = -1;
        nArray[2] = -2;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = -3;
        nArray[6] = 3;
        int[] klist = nArray;
        int ki = 0;
        while (!sqf) {
            if (ki >= klist.length) break;
            k = klist[ki];
            ++ki;
            ks = k;
            res = PolyUfdUtil.norm(P, ks);
            if (res.isZERO() || res.isConstant()) continue;
            sqf = this.factorCoeff.isSquarefree(res);
        }
        if (!sqf) {
            System.out.println("sqf(" + ks + ") = " + sqf);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("res = " + res));
        }
        List<GenPolynomial<C>> nfacs = this.factorCoeff.baseFactorsRadical(res);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("res facs = " + nfacs));
        }
        if (nfacs.size() == 1) {
            factors.add(P);
            return factors;
        }
        GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> Pp = P;
        for (GenPolynomial<C> nfi : nfacs) {
            GenPolynomial<AlgebraicNumber<C>> pni;
            GenPolynomial Ni = PolyUfdUtil.substituteConvertToAlgebraicCoefficients(pfac, nfi, ks);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Ni = " + Ni));
            }
            if (!(pni = this.engine.gcd(Ni, Pp)).leadingBaseCoefficient().isONE()) {
                pni = pni.monic();
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("gcd(Ni,Pp) = " + pni));
            }
            if (pni.isONE()) continue;
            factors.add(pni);
            Pp = Pp.divide(pni);
        }
        if (!Pp.isZERO() && !Pp.isONE()) {
            factors.add(Pp);
        }
        return factors;
    }
}

