/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorAlgebraic;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorAlgebraicTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorAlgebraicTest.suite());
    }

    public FactorAlgebraicTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorAlgebraicTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testAlgebraicFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, alpha);
        GenPolynomial<BigRational> agen = pfac.univariate(0, 2L);
        agen = agen.sum((BigRational)pfac.getONE());
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(agen, true);
        GenPolynomialRing<BigRational> apfac = new GenPolynomialRing<BigRational>(afac, 1, to, vars);
        FactorAlgebraic<BigRational> fac = new FactorAlgebraic<BigRational>(afac);
        int i = 1;
        while (i < 2) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigRational> c = apfac.random(2, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigRational>> b = apfac.random(2, this.ll + i, this.el + i, this.q);
            if (b.degree() == 0L) {
                b = b.multiply((RingElem<BigRational>)apfac.univariate(0));
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.baseFactors(a = c.multiply((BigRational)((Object)b)))).size() >= facs) {
                FactorAlgebraicTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + facs);
            }
            boolean t = fac.isFactorization(a, sm);
            FactorAlgebraicTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            ++i;
        }
    }
}

