/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorsMap;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorComplexTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorComplexTest.suite());
    }

    public FactorComplexTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorComplexTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testComplexFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational rfac = new BigRational(1L);
        ComplexRing<BigRational> cfac = new ComplexRing<BigRational>(rfac);
        GenPolynomialRing<BigRational> cpfac = new GenPolynomialRing<BigRational>(cfac, 1, to);
        FactorComplex<BigRational> fac = new FactorComplex<BigRational>(cfac);
        int i = 1;
        while (i < 3) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigRational> c = cpfac.random(2, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigRational>> b = cpfac.random(2, this.ll + i, this.el + i, this.q);
            if (b.degree() == 0L) {
                b = b.multiply((RingElem<BigRational>)cpfac.univariate(0));
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if ((b = b.multiply((RingElem<BigRational>)b)).degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.baseFactors(a = c.multiply((BigRational)((Object)b)))).size() >= facs) {
                FactorComplexTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + facs);
            }
            boolean t = fac.isFactorization(a, sm);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            ++i;
        }
    }

    public void testComplexAbsoluteFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational rfac = new BigRational(1L);
        ComplexRing<BigRational> cfac = new ComplexRing<BigRational>(rfac);
        GenPolynomialRing<BigRational> cpfac = new GenPolynomialRing<BigRational>(cfac, 1, to);
        FactorComplex<BigRational> fac = new FactorComplex<BigRational>(cfac);
        int i = 1;
        while (i < 2) {
            int facs = 0;
            GenPolynomial<BigRational> c = cpfac.random(2, this.ll, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> b = cpfac.random(2, this.ll, this.el, this.q);
            if (b.degree() == 0L) {
                b = b.multiply((RingElem<BigRational>)cpfac.univariate(0));
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if ((b = b.multiply((RingElem<BigRational>)b)).degree() > 0L) {
                ++facs;
            }
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> a = c.multiply((BigRational)((Object)b));
            FactorsMap<GenPolynomial<RingElem<BigRational>>> sm = fac.baseFactorsAbsolute(a);
            boolean t = fac.isAbsoluteFactorization(sm);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            ++i;
        }
    }

    public void testBivariateComplexFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational rfac = new BigRational(1L);
        ComplexRing<BigRational> cfac = new ComplexRing<BigRational>(rfac);
        GenPolynomialRing<BigRational> cpfac = new GenPolynomialRing<BigRational>(cfac, 2, to);
        FactorComplex<BigRational> fac = new FactorComplex<BigRational>(cfac);
        int i = 1;
        while (i < 2) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigRational> c = cpfac.random(2, this.ll + i, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> b = cpfac.random(2, this.ll + i, this.el, this.q);
            if (b.degree() == 0L) {
                b = b.multiply((RingElem<BigRational>)cpfac.univariate(0));
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.factors(a = c.multiply((BigRational)((Object)b)))).size() >= facs) {
                FactorComplexTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + facs);
            }
            boolean t = fac.isFactorization(a, sm);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            ++i;
        }
    }
}

