/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorGenericTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorGenericTest.suite());
    }

    public FactorGenericTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorGenericTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void xtestDummy() {
    }

    public void testGenericFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] var_w2 = new String[]{"w2"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, var_w2);
        Element w2 = pfac.parse(" w2^2 - 2 ");
        AlgebraicNumberRing a2fac = new AlgebraicNumberRing(w2, true);
        String[] var_x = new String[]{"x"};
        GenPolynomialRing apfac = new GenPolynomialRing(a2fac, 1, to, var_x);
        QuotientRing qfac = new QuotientRing(apfac);
        String[] var_wx = new String[]{"wx"};
        GenPolynomialRing pqfac = new GenPolynomialRing(qfac, 1, to, var_wx);
        Element wx = pqfac.parse(" wx^2 - { x } ");
        AlgebraicNumberRing axfac = new AlgebraicNumberRing(wx, true);
        String[] var_y = new String[]{"y"};
        GenPolynomialRing apqfac = new GenPolynomialRing(axfac, 1, to, var_y);
        Element f = apqfac.parse(" ( y^2 - { { x } } ) * ( y^2 - 2 )^2 ");
        FactorAbstract engine = FactorFactory.getImplementation(axfac);
        SortedMap F2 = engine.factors(f);
        FactorGenericTest.assertTrue((String)"#facs >= 4", (F2.size() >= 4 ? 1 : 0) != 0);
        boolean t = engine.isFactorization(f, F2);
        FactorGenericTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }
}

