/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorInteger<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbstract<BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorInteger.class);
    private final boolean debug;
    protected final FactorAbstract<MOD> mfactor;
    protected final GreatestCommonDivisorAbstract<MOD> mengine;

    public FactorInteger() {
        this(BigInteger.ONE);
    }

    public FactorInteger(RingFactory<BigInteger> cfac) {
        super(cfac);
        this.debug = true;
        ModularRingFactory mcofac = new ModLongRing(13L, true);
        this.mfactor = FactorFactory.getImplementation(mcofac);
        this.mengine = GCDFactory.getImplementation(mcofac);
    }

    @Override
    public List<GenPolynomial<BigInteger>> baseFactorsSquarefree(GenPolynomial<BigInteger> P) {
        int s;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P == null");
        }
        List<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " only for univariate polynomials");
        }
        if (P.degree(0) <= 1L) {
            factors.add(P);
            return factors;
        }
        BigInteger an = P.maxNorm();
        BigInteger ac = P.leadingBaseCoefficient();
        ExpVector degv = P.degreeVector();
        int degi = (int)P.degree(0);
        BigInteger M = an.multiply(PolyUtil.factorBound(degv));
        M = M.multiply(ac.multiply(ac.fromInteger(8L)));
        PrimeList primes = new PrimeList(PrimeList.Range.small);
        int pn = 30;
        Iterable<ModLong> cofac = null;
        GenPolynomial<MonoidElem> am = null;
        GenPolynomialRing<ModLong> mfac = null;
        int TT = 5;
        List[] modfac = new List[5];
        List[] intfac = new List[5];
        BigInteger[] plist = new BigInteger[5];
        List mlist = null;
        List ilist = null;
        int i = 0;
        if (this.debug) {
            logger.debug((Object)("an  = " + an));
            logger.debug((Object)("ac  = " + ac));
            logger.debug((Object)("M   = " + M));
            logger.info((Object)("degv = " + degv));
        }
        Iterator<java.math.BigInteger> pit = primes.iterator();
        pit.next();
        pit.next();
        MonoidElem nf = null;
        int k = 0;
        while (k < 5) {
            if (k == 4) {
                primes = new PrimeList(PrimeList.Range.medium);
                pit = primes.iterator();
            }
            if (k == 6) {
                primes = new PrimeList(PrimeList.Range.large);
                pit = primes.iterator();
            }
            while (pit.hasNext()) {
                java.math.BigInteger p = pit.next();
                if (++i >= pn) {
                    logger.error((Object)("prime list exhausted, pn = " + pn));
                    throw new ArithmeticException("prime list exhausted");
                }
                cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                logger.info((Object)("prime = " + cofac));
                nf = (GcdRingElem)cofac.fromInteger(ac.getVal());
                if (nf.isZERO()) {
                    logger.info((Object)("unlucky prime (nf) = " + p));
                    continue;
                }
                mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), pfac);
                am = PolyUtil.fromIntegerCoefficients(mfac, P);
                if (!am.degreeVector().equals(degv)) {
                    logger.info((Object)("unlucky prime (deg) = " + p));
                    continue;
                }
                GenPolynomial<MonoidElem> ap = PolyUtil.baseDeriviative(am);
                if (ap.isZERO()) {
                    logger.info((Object)("unlucky prime (a')= " + p));
                    continue;
                }
                GenPolynomial<MonoidElem> g = this.mengine.baseGcd(am, ap);
                if (!g.isONE()) continue;
                logger.info((Object)("**lucky prime = " + p));
                break;
            }
            if (!nf.isONE()) {
                am = am.divide(nf);
            }
            mlist = this.mfactor.baseFactorsSquarefree(am);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("modlist  = " + mlist));
            }
            if (mlist.size() <= 1) {
                factors.add(P);
                return factors;
            }
            if (!nf.isONE()) {
                GenPolynomial<MonoidElem> mp = mfac.getONE();
                mp = mp.multiply(nf);
                mlist.add(0, mp);
            }
            modfac[k] = mlist;
            plist[k] = cofac.getIntegerModul();
            ++k;
        }
        int min = Integer.MAX_VALUE;
        BitSet AD = null;
        int k2 = 0;
        while (k2 < 5) {
            List<ExpVector> ev = PolyUtil.leadingExpVector(modfac[k2]);
            BitSet D2 = this.factorDegrees(ev, degi);
            if (AD == null) {
                AD = D2;
            } else {
                AD.and(D2);
            }
            s = modfac[k2].size();
            logger.info((Object)("mod(" + plist[k2] + ") #s = " + s + ", D = " + D2));
            if (s < min) {
                min = s;
                mlist = modfac[k2];
            }
            ++k2;
        }
        logger.info((Object)("min = " + min + ", AD = " + AD));
        if (mlist.size() <= 1) {
            logger.info((Object)"mlist.size() = 1");
            factors.add(P);
            return factors;
        }
        if (AD.cardinality() <= 2) {
            logger.info((Object)("degree set cardinality = " + AD.cardinality()));
            factors.add(P);
            return factors;
        }
        boolean allLists = false;
        if (allLists) {
            int k3 = 0;
            while (k3 < 5) {
                mlist = modfac[k3];
                if (this.debug) {
                    logger.info((Object)("lifting from " + mlist));
                }
                intfac[k3] = factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                ++k3;
            }
        } else {
            if (this.debug) {
                logger.info((Object)("lifting shortest from " + mlist));
            }
            if (P.leadingBaseCoefficient().isONE()) {
                long t = System.currentTimeMillis();
                try {
                    mlist = PolyUtil.monic(mlist);
                    factors = this.searchFactorsMonic(P, M, mlist, AD);
                    t = System.currentTimeMillis() - t;
                }
                catch (RuntimeException e) {
                    t = System.currentTimeMillis();
                    factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                    t = System.currentTimeMillis() - t;
                }
            } else {
                long t = System.currentTimeMillis();
                factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                t = System.currentTimeMillis() - t;
            }
            return factors;
        }
        int max = 0;
        int k4 = 0;
        while (k4 < 5) {
            s = intfac[k4].size();
            logger.info((Object)("int s = " + s));
            if (s > max) {
                max = s;
                ilist = intfac[k4];
            }
            ++k4;
        }
        factors = ilist;
        return factors;
    }

    public BitSet factorDegrees(List<ExpVector> E2, int deg) {
        BitSet D2 = new BitSet(deg + 1);
        D2.set(0);
        for (ExpVector e : E2) {
            int i = (int)e.getVal(0);
            BitSet s = new BitSet(deg + 1);
            int k = 0;
            while (k < deg + 1 - i) {
                s.set(i + k, D2.get(k));
                ++k;
            }
            D2.or(s);
        }
        return D2;
    }

    public static <C extends RingElem<C>> long degreeSum(List<GenPolynomial<C>> L) {
        long s = 0L;
        for (GenPolynomial<C> p : L) {
            ExpVector e = p.leadingExpVector();
            long d = e.getVal(0);
            s += d;
        }
        return s;
    }

    List<GenPolynomial<BigInteger>> searchFactorsMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F2, BitSet D2) {
        List<GenPolynomial<MOD>> lift;
        if (C == null || C.isZERO() || F2 == null || F2.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>(F2.size());
        List<GenPolynomial<MOD>> mlist = F2;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        }
        ModularRingFactory mcfac = (ModularRingFactory)ct.ring.coFac;
        BigInteger m = mcfac.getIntegerModul();
        long k = 1L;
        BigInteger pi = m;
        while (pi.compareTo(M) < 0) {
            ++k;
            pi = pi.multiply(m);
        }
        logger.info((Object)("p^k = " + m + "^" + k));
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        try {
            lift = HenselUtil.liftHenselMonic(PP, mlist, k);
        }
        catch (NoLiftingException e) {
            throw new RuntimeException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("lifted modlist = " + lift));
        }
        GenPolynomialRing mpfac = lift.get((int)0).ring;
        int dl = (lift.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        int j = 1;
        while (j <= dl) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(lift, j);
            for (List list : ps) {
                if (!D2.get((int)FactorInteger.degreeSum(list))) {
                    logger.info((Object)("skipped by degree set " + D2 + ", deg = " + FactorInteger.degreeSum(list)));
                    continue;
                }
                GenPolynomial mtrial = mpfac.getONE();
                int kk = 0;
                while (kk < list.size()) {
                    GenPolynomial fk = list.get(kk);
                    mtrial = mtrial.multiply((GenPolynomial)fk);
                    ++kk;
                }
                if (mtrial.degree(0) > deg) {
                    logger.info((Object)("degree > deg " + deg + ", degree = " + mtrial.degree(0)));
                }
                GenPolynomial<BigInteger> trial = PolyUtil.integerFromModularCoefficients(pfac, mtrial);
                if (!PolyUtil.basePseudoRemainder(u, trial = this.engine.basePrimitivePart(trial)).isZERO()) continue;
                logger.info((Object)("successful trial = " + trial));
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                if (lift.removeAll(list)) {
                    logger.info((Object)("new lift= " + lift));
                    dl = (lift.size() + 1) / 2;
                    j = 0;
                    break;
                }
                logger.error((Object)("error removing flist from lift = " + lift));
            }
            ++j;
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred u = " + u));
            factors.add(PP);
        }
        return factors;
    }

    List<GenPolynomial<BigInteger>> searchFactorsNonMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F2, BitSet D2) {
        if (C == null || C.isZERO() || F2 == null || F2.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>(F2.size());
        List<GenPolynomial<MOD>> mlist = F2;
        GcdRingElem nf = null;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            nf = (GcdRingElem)ct.leadingBaseCoefficient();
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        } else {
            nf = (GcdRingElem)ct.ring.coFac.getONE();
        }
        GenPolynomialRing mfac = ct.ring;
        GenPolynomial<GcdRingElem> Pm = PolyUtil.fromIntegerCoefficients(mfac, C);
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        int dl = (mlist.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        GenPolynomial<GcdRingElem> um = Pm;
        HenselApprox<GcdRingElem> ilist = null;
        int j = 1;
        while (j <= dl) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(mlist, j);
            for (List list : ps) {
                if (!D2.get((int)FactorInteger.degreeSum(list))) {
                    logger.info((Object)("skipped by degree set " + D2 + ", deg = " + FactorInteger.degreeSum(list)));
                    continue;
                }
                GenPolynomial trial = ((GenPolynomial)mfac.getONE()).multiply(nf);
                int kk = 0;
                while (kk < list.size()) {
                    GenPolynomial fk = list.get(kk);
                    trial = trial.multiply(fk);
                    ++kk;
                }
                if (trial.degree(0) > deg) {
                    logger.info((Object)("degree > deg " + deg + ", degree = " + trial.degree(0)));
                }
                GenPolynomial<GcdRingElem> cofactor = um.divide(trial);
                try {
                    ilist = HenselUtil.liftHenselQuadratic(PP, M, trial, cofactor);
                }
                catch (NoLiftingException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.info((Object)("no liftable factors " + e));
                    e.printStackTrace();
                    continue;
                }
                GenPolynomial<BigInteger> itrial = ilist.A;
                GenPolynomial<BigInteger> icofactor = ilist.B;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("       modlist = " + trial + ", cofactor " + cofactor));
                    logger.info((Object)("lifted intlist = " + itrial + ", cofactor " + icofactor));
                }
                if (!PolyUtil.basePseudoRemainder(u, itrial = this.engine.basePrimitivePart(itrial)).isZERO()) continue;
                logger.info((Object)("successful trial = " + itrial));
                factors.add(itrial);
                PP = u = icofactor;
                um = cofactor;
                if (mlist.removeAll(list)) {
                    logger.info((Object)("new mlist= " + mlist));
                    dl = (mlist.size() + 1) / 2;
                    j = 0;
                    break;
                }
                logger.error((Object)("error removing flist from ilist = " + mlist));
            }
            ++j;
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred u = " + u));
            factors.add(PP);
        }
        return factors;
    }
}

