/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorIntegerTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 5;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorIntegerTest.suite());
    }

    public FactorIntegerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorIntegerTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testIntegerMonicFactorization() {
        TermOrder to = new TermOrder(2);
        BigInteger cfac = new BigInteger(4L);
        BigInteger one = cfac.getONE();
        GenPolynomialRing<BigInteger> pfac = new GenPolynomialRing<BigInteger>(cfac, 1, to, new String[]{"x"});
        FactorInteger fac = new FactorInteger();
        int i = 1;
        while (i < 3) {
            int facs = 0;
            GenPolynomial<GenPolynomial<BigInteger>> a = null;
            GenPolynomial<BigInteger> b = pfac.random(this.kl * 2, this.ll * i, this.el * (i + 1), this.q);
            GenPolynomial<BigInteger> c = pfac.random(this.kl, this.ll * i, this.el * (i + 2), this.q);
            if (!b.isZERO() && !c.isZERO()) {
                ExpVector e;
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if (!c.leadingBaseCoefficient().isUnit()) {
                    e = c.leadingExpVector();
                    c.doPutToMap(e, one);
                }
                if (!b.leadingBaseCoefficient().isUnit()) {
                    e = b.leadingExpVector();
                    b.doPutToMap(e, one);
                }
                if (!(a = c.multiply((BigInteger)((Object)b))).isConstant()) {
                    GreatestCommonDivisorAbstract<BigInteger> engine = GCDFactory.getProxy(cfac);
                    SortedMap sm = fac.baseFactors(a);
                    if (sm.size() >= facs) {
                        FactorIntegerTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                    } else {
                        long sf = 0L;
                        for (Long e2 : sm.values()) {
                            sf += e2.longValue();
                        }
                        FactorIntegerTest.assertTrue((String)("#facs < " + facs + ", " + b + " * " + c), (sf >= (long)facs ? 1 : 0) != 0);
                    }
                    boolean t = fac.isFactorization(a, sm);
                    FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
                }
            }
            ++i;
        }
    }

    public void testIntegerFactorization() {
        TermOrder to = new TermOrder(2);
        BigInteger cfac = new BigInteger(4L);
        BigInteger one = cfac.getONE();
        GenPolynomialRing<BigInteger> pfac = new GenPolynomialRing<BigInteger>(cfac, 1, to);
        FactorInteger fac = new FactorInteger();
        int i = 1;
        while (i < 2) {
            int facs = 0;
            GenPolynomial<GenPolynomial<BigInteger>> a = null;
            GenPolynomial<BigInteger> b = pfac.random(this.kl * 2, this.ll * i, this.el * (i + 1), this.q);
            GenPolynomial<BigInteger> c = pfac.random(this.kl, this.ll * i, this.el * (i + 2), this.q);
            if (!b.isZERO() && !c.isZERO()) {
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if (!(a = c.multiply((BigInteger)((Object)b))).isConstant()) {
                    GreatestCommonDivisorAbstract<BigInteger> engine = GCDFactory.getProxy(cfac);
                    SortedMap sm = fac.baseFactors(a);
                    if (sm.size() >= facs) {
                        FactorIntegerTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                    } else {
                        long sf = 0L;
                        for (Long e : sm.values()) {
                            sf += e.longValue();
                        }
                        FactorIntegerTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
                    }
                    boolean t = fac.isFactorization(a, sm);
                    FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
                }
            }
            ++i;
        }
    }

    public void testIntegerFactorizationIrred() {
        TermOrder to = new TermOrder(2);
        BigInteger cfac = new BigInteger(4L);
        BigInteger one = cfac.getONE();
        GenPolynomialRing<BigInteger> pfac = new GenPolynomialRing<BigInteger>(cfac, 1, to, new String[]{"x"});
        FactorInteger fac = new FactorInteger();
        int i = 1;
        while (i < 2) {
            int facs = 0;
            Element a = pfac.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            a = pfac.parse("( x^8 - 40 x^6 + 352 x^4 - 960 x^2 + 576 )");
            if (!((GenPolynomial)a).isConstant()) {
                SortedMap sm = fac.baseFactors(a);
                if (sm.size() >= 1) {
                    FactorIntegerTest.assertTrue((String)("#facs < " + facs), (sm.size() >= 1 ? 1 : 0) != 0);
                }
                boolean t = fac.isFactorization(a, sm);
                FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            }
            ++i;
        }
    }

    public void testMultivariate2IntegerFactorization() {
        TermOrder to = new TermOrder(2);
        BigInteger cfac = new BigInteger(1L);
        GenPolynomialRing<BigInteger> pfac = new GenPolynomialRing<BigInteger>(cfac, 2, to);
        FactorInteger fac = new FactorInteger();
        int i = 1;
        while (i < 2) {
            GenPolynomial<BigInteger> b = pfac.random(this.kl, 3, this.el, this.q / 2.0f);
            GenPolynomial<BigInteger> c = pfac.random(this.kl, 2, this.el, this.q);
            GenPolynomial<GenPolynomial<BigInteger>> a = b.multiply((BigInteger)((Object)c));
            SortedMap sm = fac.factors(a);
            boolean t = fac.isFactorization(a, sm);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            ++i;
        }
    }
}

