/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorsMap;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorModularTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorModularTest.suite());
    }

    public FactorModularTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorModularTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testModularFactorization() {
        PrimeList pl = new PrimeList(PrimeList.Range.medium);
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(pl.get(3));
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, 1, to);
        FactorModular<ModInteger> fac = new FactorModular<ModInteger>(cfac);
        int i = 1;
        while (i < 4) {
            int facs = 0;
            GenPolynomial<GenPolynomial<ModInteger>> a = null;
            GenPolynomial<ModInteger> b = pfac.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> c = pfac.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (!b.isZERO() && !c.isZERO()) {
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if (!(a = c.multiply((ModInteger)((Object)b))).isConstant()) {
                    SortedMap sm = fac.baseFactors(a = a.monic());
                    if (sm.size() >= facs) {
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                    } else {
                        long sf = 0L;
                        for (Long e : sm.values()) {
                            sf += e.longValue();
                        }
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
                    }
                    boolean t = fac.isFactorization(a, sm);
                    FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
                }
            }
            ++i;
        }
    }

    public void testModularFactorizationExam() {
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(7L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, 1, to, vars);
        FactorModular<ModInteger> fac = new FactorModular<ModInteger>(cfac);
        int facs = 3;
        GenPolynomial a = pfac.parse("(x^12+5)");
        SortedMap sm = fac.baseFactors(a = a.monic());
        if (sm.size() >= facs) {
            FactorModularTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
        } else {
            long sf = 0L;
            for (Long e : sm.values()) {
                sf += e.longValue();
            }
            FactorModularTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
        }
        boolean t = fac.isFactorization(a, sm);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }

    public void testModular2Factorization() {
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, 1, to);
        FactorModular<ModInteger> fac = new FactorModular<ModInteger>(cfac);
        int i = 1;
        while (i < 4) {
            int facs = 0;
            GenPolynomial<GenPolynomial<ModInteger>> a = null;
            GenPolynomial<ModInteger> b = pfac.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> c = pfac.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (!b.isZERO() && !c.isZERO()) {
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if (!(a = c.multiply((ModInteger)((Object)b))).isConstant()) {
                    SortedMap sm = fac.baseFactors(a = a.monic());
                    if (sm.size() >= facs) {
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                    } else {
                        long sf = 0L;
                        for (Long e : sm.values()) {
                            sf += e.longValue();
                        }
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
                    }
                    boolean t = fac.isFactorization(a, sm);
                    FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
                }
            }
            ++i;
        }
    }

    public void testMultivariateModularFactorization() {
        PrimeList pl = new PrimeList(PrimeList.Range.small);
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(13L);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, this.rl, to);
        FactorModular<ModInteger> fac = new FactorModular<ModInteger>(cfac);
        int i = 1;
        while (i < 2) {
            int facs = 0;
            GenPolynomial<GenPolynomial<ModInteger>> a = null;
            GenPolynomial<ModInteger> b = pfac.random(this.kl, 2, this.el, this.q);
            GenPolynomial<ModInteger> c = pfac.random(this.kl, 2, this.el, this.q);
            if (!b.isZERO() && !c.isZERO()) {
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if (!(a = c.multiply((ModInteger)((Object)b))).isConstant()) {
                    SortedMap sm = fac.factors(a);
                    if (sm.size() >= facs) {
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                    } else {
                        long sf = 0L;
                        for (Long e : sm.values()) {
                            sf += e.longValue();
                        }
                        FactorModularTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
                    }
                    boolean t = fac.isFactorization(a, sm);
                    FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
                }
            }
            ++i;
        }
    }

    public void testBaseModularAbsoluteFactorization() {
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(17L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"z"};
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, 1, to, alpha);
        GenPolynomial<ModInteger> agen = pfac.univariate(0, 4L);
        agen = agen.sum((ModInteger)pfac.fromInteger(1L));
        FactorModular<ModInteger> engine = new FactorModular<ModInteger>(cfac);
        FactorsMap<ModInteger> F2 = engine.baseFactorsAbsolute(agen);
        boolean t = engine.isAbsoluteFactorization(F2);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }
}

