/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorMoreTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorMoreTest.suite());
    }

    public FactorMoreTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorMoreTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testIntegralFunctionFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] qvars = new String[]{"t"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, qvars);
        GenPolynomial<BigRational> t = pfac.univariate(0);
        FactorRational fac = new FactorRational();
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pqfac = new GenPolynomialRing<BigRational>(pfac, 1, to, vars);
        GenPolynomial<BigRational> x = pqfac.univariate(0);
        GenPolynomial<BigRational> x2 = pqfac.univariate(0, 2L);
        int i = 1;
        while (i < 3) {
            GenPolynomial a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigRational> b = pqfac.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> c = pqfac.random(2, 3, this.el, this.q);
            if (c.degree() < 1L) {
                c = x2.subtract((BigRational)((Object)((GenPolynomial)pqfac.getONE()).multiply(t)));
            }
            if (b.degree() < 1L) {
                b = x.sum((BigRational)pqfac.getONE());
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.recursiveFactors(a = c.multiply((RingElem<BigRational>)b))).size() >= facs) {
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                long sf = 0L;
                for (Long e : sm.values()) {
                    sf += e.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
            }
            boolean tt = fac.isRecursiveFactorization(a, sm);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)tt);
            ++i;
        }
        ComputerThreads.terminate();
    }

    public void testIntegerIntegralFunctionFactorization() {
        TermOrder to = new TermOrder(2);
        BigInteger cfac = new BigInteger(1L);
        String[] qvars = new String[]{"t"};
        GenPolynomialRing<BigInteger> pfac = new GenPolynomialRing<BigInteger>(cfac, 1, to, qvars);
        GenPolynomial<BigInteger> t = pfac.univariate(0);
        FactorInteger fac = new FactorInteger();
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigInteger> pqfac = new GenPolynomialRing<BigInteger>(pfac, 1, to, vars);
        GenPolynomial<BigInteger> x = pqfac.univariate(0);
        GenPolynomial<BigInteger> x2 = pqfac.univariate(0, 2L);
        int i = 1;
        while (i < 3) {
            GenPolynomial a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigInteger> b = pqfac.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigInteger>> c = pqfac.random(2, 3, this.el, this.q);
            if (c.degree() < 1L) {
                c = x2.subtract((BigInteger)((Object)((GenPolynomial)pqfac.getONE()).multiply(t)));
            }
            if (b.degree() < 1L) {
                b = x.sum((BigInteger)pqfac.getONE());
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.recursiveFactors(a = c.multiply((RingElem<BigInteger>)b))).size() >= facs) {
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                long sf = 0L;
                for (Long e : sm.values()) {
                    sf += e.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
            }
            boolean tt = fac.isRecursiveFactorization(a, sm);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)tt);
            ++i;
        }
        ComputerThreads.terminate();
    }

    public void testRationalFunctionFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] qvars = new String[]{"t"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, qvars);
        QuotientRing<BigRational> qfac = new QuotientRing<BigRational>(pfac);
        Quotient<BigRational> t = qfac.generators().get(1);
        FactorQuotient<BigRational> fac = new FactorQuotient<BigRational>(qfac);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pqfac = new GenPolynomialRing<BigRational>(qfac, 1, to, vars);
        GenPolynomial<BigRational> x = pqfac.univariate(0);
        GenPolynomial<BigRational> x2 = pqfac.univariate(0, 2L);
        int i = 1;
        while (i < 3) {
            GenPolynomial<GenPolynomial<BigRational>> a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<BigRational> b = pqfac.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> c = pqfac.random(2, 3, this.el, this.q);
            if (c.degree() < 1L) {
                c = x2.subtract((BigRational)((Object)((GenPolynomial)pqfac.getONE()).multiply(t)));
            }
            if (b.degree() < 1L) {
                b = x.sum((BigRational)pqfac.getONE());
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.factors(a = c.multiply((RingElem<BigRational>)b))).size() >= facs) {
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                long sf = 0L;
                for (Long e : sm.values()) {
                    sf += e.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
            }
            boolean tt = fac.isFactorization(a, sm);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)tt);
            ++i;
        }
        ComputerThreads.terminate();
    }

    public void testModularRationalFunctionFactorization() {
        TermOrder to = new TermOrder(2);
        ModIntegerRing cfac = new ModIntegerRing(19L, true);
        String[] qvars = new String[]{"t"};
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(cfac, 1, to, qvars);
        QuotientRing<ModInteger> qfac = new QuotientRing<ModInteger>(pfac);
        Quotient<ModInteger> t = qfac.generators().get(1);
        FactorQuotient<ModInteger> fac = new FactorQuotient<ModInteger>(qfac);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<ModInteger> pqfac = new GenPolynomialRing<ModInteger>(qfac, 1, to, vars);
        GenPolynomial<ModInteger> x = pqfac.univariate(0);
        GenPolynomial<ModInteger> x2 = pqfac.univariate(0, 2L);
        int i = 1;
        while (i < 3) {
            GenPolynomial<GenPolynomial<ModInteger>> a;
            SortedMap sm;
            int facs = 0;
            GenPolynomial<ModInteger> b = pqfac.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<ModInteger>> c = pqfac.random(2, 3, this.el, this.q);
            if (c.degree() < 1L) {
                c = x2.subtract((ModInteger)((Object)((GenPolynomial)pqfac.getONE()).multiply(t)));
            }
            if (b.degree() < 1L) {
                b = x.sum((ModInteger)pqfac.getONE());
            }
            if (c.degree() > 0L) {
                ++facs;
            }
            if (b.degree() > 0L) {
                ++facs;
            }
            if ((sm = fac.factors(a = c.multiply((RingElem<ModInteger>)b))).size() >= facs) {
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
            } else {
                long sf = 0L;
                for (Long e : sm.values()) {
                    sf += e.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + facs), (sf >= (long)facs ? 1 : 0) != 0);
            }
            boolean tt = fac.isFactorization(a, sm);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)tt);
            ++i;
        }
        ComputerThreads.terminate();
    }
}

