/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorQuotientTest
extends TestCase {
    int rl = 1;
    int kl = 3;
    int ll = 3;
    int el = 3;
    float q = 0.4f;
    QuotientRing<BigRational> efac;
    GenPolynomialRing<BigRational> mfac;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorQuotientTest.suite());
    }

    public FactorQuotientTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorQuotientTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational cfac = new BigRational(1L);
        TermOrder to = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigRational>(cfac, this.rl, to);
        this.efac = new QuotientRing<BigRational>(this.mfac);
    }

    protected void tearDown() {
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void xtestDummy() {
    }

    public void testQuotientFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] var_x = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(this.efac, 1, to, var_x);
        GenPolynomial<BigRational> a = pfac.random(this.kl, this.ll, this.el, this.q);
        FactorAbstract<Quotient<BigRational>> engine = FactorFactory.getImplementation(this.efac);
        SortedMap sm = engine.factors(a);
        FactorQuotientTest.assertTrue((String)"#facs >= 1", (sm.size() >= 1 ? 1 : 0) != 0);
        boolean t = engine.isFactorization(a, sm);
        FactorQuotientTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }
}

