/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.FactorsMap;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorRationalTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorRationalTest.suite());
    }

    public FactorRationalTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorRationalTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testRationalFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to);
        FactorRational fac = new FactorRational();
        int i = 1;
        while (i < 3) {
            int facs = 0;
            GenPolynomial<BigRational> c = pfac.random(this.kl - 2, this.ll * i, this.el + i, this.q);
            GenPolynomial<BigRational> b = pfac.random(this.kl - 2, this.ll, this.el, this.q);
            if (!b.isZERO() && !c.isZERO()) {
                GenPolynomial<GenPolynomial<BigRational>> a;
                SortedMap sm;
                if (c.degree() > 0L) {
                    ++facs;
                }
                if (b.degree() > 0L) {
                    ++facs;
                }
                if ((sm = fac.baseFactors(a = c.multiply((BigRational)((Object)b)))).size() >= facs) {
                    FactorRationalTest.assertTrue((String)("#facs < " + facs), (sm.size() >= facs ? 1 : 0) != 0);
                } else {
                    long sf = 0L;
                    for (Long e : sm.values()) {
                        sf += e.longValue();
                    }
                    FactorRationalTest.assertTrue((String)("#facs < " + facs + ", b = " + b + ", c = " + c + ", sm = " + sm), (sf >= (long)facs ? 1 : 0) != 0);
                }
                boolean t = fac.isFactorization(a, sm);
                FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
            }
            ++i;
        }
    }

    public void testBaseRationalAbsoluteFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, alpha);
        GenPolynomial<BigRational> agen = pfac.univariate(0, 4L);
        agen = agen.sum((BigRational)pfac.fromInteger(4L));
        FactorRational engine = new FactorRational();
        FactorsMap<BigRational> F2 = engine.baseFactorsAbsolute(agen);
        boolean t = engine.isAbsoluteFactorization(F2);
        FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }

    public void testRationalAbsoluteFactorization() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 2, to, vars);
        GenPolynomial<BigRational> xp = pfac.univariate(0, 2L);
        GenPolynomial<BigRational> yp = pfac.univariate(1, 2L);
        GenPolynomial<GenPolynomial<BigRational>> g = xp.sum((BigRational)((Object)yp));
        FactorRational engine = new FactorRational();
        FactorsMap<GenPolynomial<BigRational>> F2 = engine.factorsAbsolute(g);
        boolean t = engine.isAbsoluteFactorization(F2);
        FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)t);
    }
}

