/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)FactorTest.suite());
    }

    public FactorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FactorTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testFactory() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> ufdm = FactorFactory.getImplementation(mi);
        FactorTest.assertTrue((String)("ufd != Modular " + ufdm), (boolean)(ufdm instanceof FactorModular));
        ModLongRing ml = new ModLongRing(19L, true);
        FactorAbstract<ModLong> ufdml = FactorFactory.getImplementation(ml);
        FactorTest.assertTrue((String)("ufd != Modular " + ufdml), (boolean)(ufdml instanceof FactorModular));
        BigInteger bi = new BigInteger(1L);
        FactorAbstract<BigInteger> ufdi = FactorFactory.getImplementation(bi);
        FactorTest.assertTrue((String)("ufd != Integer " + ufdi), (boolean)(ufdi instanceof FactorInteger));
        BigRational br = new BigRational(1L);
        FactorAbstract<BigRational> ufdr = FactorFactory.getImplementation(br);
        FactorTest.assertTrue((String)("ufd != Rational " + ufdr), (boolean)(ufdr instanceof FactorRational));
        GenPolynomialRing<ModInteger> pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        GenPolynomial<ModInteger> pm = pmfac.univariate(0);
        AlgebraicNumberRing<ModInteger> am = new AlgebraicNumberRing<ModInteger>(pm, true);
        FactorAbstract<AlgebraicNumber<ModInteger>> ufdam = FactorFactory.getImplementation(am);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + ufdam), (boolean)(ufdam instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> prfac = new GenPolynomialRing<BigRational>(br, 1);
        GenPolynomial<BigRational> pr = prfac.univariate(0);
        AlgebraicNumberRing<BigRational> ar = new AlgebraicNumberRing<BigRational>(pr, true);
        FactorAbstract<AlgebraicNumber<BigRational>> ufdar = FactorFactory.getImplementation(ar);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + ufdar), (boolean)(ufdar instanceof FactorAlgebraic));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        QuotientRing<BigRational> qrfac = new QuotientRing<BigRational>(prfac);
        FactorAbstract<Quotient<BigRational>> ufdqr = FactorFactory.getImplementation(qrfac);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + ufdqr), (boolean)(ufdqr instanceof FactorQuotient));
    }

    public void testFactoryGeneric() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> ufdm = FactorFactory.getImplementation(mi);
        FactorTest.assertTrue((String)("ufd != Modular " + ufdm), (boolean)(ufdm instanceof FactorModular));
        BigInteger bi = new BigInteger(1L);
        FactorAbstract<BigInteger> ufdi = FactorFactory.getImplementation(bi);
        FactorTest.assertTrue((String)("ufd != Integer " + ufdi), (boolean)(ufdi instanceof FactorInteger));
        BigRational br = new BigRational(1L);
        FactorAbstract<BigRational> ufdr = FactorFactory.getImplementation(br);
        FactorTest.assertTrue((String)("ufd != Rational " + ufdr), (boolean)(ufdr instanceof FactorRational));
        GenPolynomialRing<ModInteger> pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        GenPolynomial<ModInteger> pm = pmfac.univariate(0);
        AlgebraicNumberRing<ModInteger> am = new AlgebraicNumberRing<ModInteger>(pm, true);
        FactorAbstract<ModInteger> ufdam = FactorFactory.getImplementation(am);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + ufdam), (boolean)(ufdam instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> prfac = new GenPolynomialRing<BigRational>(br, 1);
        GenPolynomial<BigRational> pr = prfac.univariate(0);
        AlgebraicNumberRing<BigRational> ar = new AlgebraicNumberRing<BigRational>(pr, true);
        FactorAbstract<BigRational> ufdar = FactorFactory.getImplementation(ar);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + ufdar), (boolean)(ufdar instanceof FactorAlgebraic));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        QuotientRing<BigRational> qrfac = new QuotientRing<BigRational>(prfac);
        FactorAbstract<BigRational> ufdqr = FactorFactory.getImplementation(qrfac);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + ufdqr), (boolean)(ufdqr instanceof FactorQuotient));
        pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        QuotientRing<ModInteger> qmfac = new QuotientRing<ModInteger>(pmfac);
        FactorAbstract<ModInteger> ufdqm = FactorFactory.getImplementation(qmfac);
        FactorTest.assertTrue((String)("ufd != Quotient<ModInteger> " + ufdqm), (boolean)(ufdqm instanceof FactorQuotient));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        GenPolynomialRing<BigRational> rrfac = new GenPolynomialRing<BigRational>(prfac, 1);
        FactorAbstract<BigRational> ufdrr = FactorFactory.getImplementation(rrfac);
        FactorTest.assertTrue((String)("ufd != GenPolynomial<GenPolynomialBigRational>> " + ufdrr), (boolean)(ufdrr instanceof FactorRational));
    }

    public void testFactorySpecific() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> ufdm = FactorFactory.getImplementation(mi);
        FactorTest.assertTrue((String)("ufd != Modular " + ufdm), (boolean)(ufdm instanceof FactorModular));
        BigInteger bi = new BigInteger(1L);
        FactorAbstract<BigInteger> ufdi = FactorFactory.getImplementation(bi);
        FactorTest.assertTrue((String)("ufd != Integer " + ufdi), (boolean)(ufdi instanceof FactorInteger));
        BigRational br = new BigRational(1L);
        FactorAbstract<BigRational> ufdr = FactorFactory.getImplementation(br);
        FactorTest.assertTrue((String)("ufd != Rational " + ufdr), (boolean)(ufdr instanceof FactorRational));
        GenPolynomialRing<ModInteger> pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        GenPolynomial<ModInteger> pm = pmfac.univariate(0);
        AlgebraicNumberRing<ModInteger> am = new AlgebraicNumberRing<ModInteger>(pm, true);
        FactorAbstract<AlgebraicNumber<ModInteger>> ufdam = FactorFactory.getImplementation(am);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + ufdam), (boolean)(ufdam instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> prfac = new GenPolynomialRing<BigRational>(br, 1);
        GenPolynomial<BigRational> pr = prfac.univariate(0);
        AlgebraicNumberRing<BigRational> ar = new AlgebraicNumberRing<BigRational>(pr, true);
        FactorAbstract<AlgebraicNumber<BigRational>> ufdar = FactorFactory.getImplementation(ar);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + ufdar), (boolean)(ufdar instanceof FactorAlgebraic));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        QuotientRing<BigRational> qrfac = new QuotientRing<BigRational>(prfac);
        FactorAbstract<Quotient<BigRational>> ufdqr = FactorFactory.getImplementation(qrfac);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + ufdqr), (boolean)(ufdqr instanceof FactorQuotient));
        pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        QuotientRing<ModInteger> qmfac = new QuotientRing<ModInteger>(pmfac);
        FactorAbstract<Quotient<ModInteger>> ufdqm = FactorFactory.getImplementation(qmfac);
        FactorTest.assertTrue((String)("ufd != Quotient<ModInteger> " + ufdqm), (boolean)(ufdqm instanceof FactorQuotient));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        GenPolynomialRing<BigRational> rrfac = new GenPolynomialRing<BigRational>(prfac, 1);
        FactorAbstract<BigRational> ufdrr = FactorFactory.getImplementation(prfac);
        FactorTest.assertTrue((String)("ufd != GenPolynomial<GenPolynomialBigRational>> " + ufdrr), (boolean)(ufdrr instanceof FactorRational));
    }

    public void xtestBaseRationalAbsoluteFactorizationRoT() {
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        GenPolynomial<BigRational> agen = pfac.univariate(0, 4L);
        agen = agen.sum((BigRational)pfac.fromInteger(4L));
        GenPolynomial<BigRational> x2 = pfac.univariate(0, 2L);
        agen = x2.subtract((BigRational)pfac.fromInteger(2L));
        MonoidElem N2 = pfac.getONE();
        FactorRational engine = new FactorRational();
        PartialFraction<BigRational> F2 = engine.baseAlgebraicPartialFraction(N2, agen);
    }
}

