/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDProxy;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import org.apache.log4j.Logger;

public class GCDFactory {
    private static final Logger logger = Logger.getLogger(GCDFactory.class);

    protected GCDFactory() {
    }

    public static GreatestCommonDivisorAbstract<ModLong> getImplementation(ModLongRing fac) {
        if (fac.isField()) {
            GreatestCommonDivisorModEval<ModLong> ufd = new GreatestCommonDivisorModEval<ModLong>();
            return ufd;
        }
        GreatestCommonDivisorSubres<ModLong> ufd = new GreatestCommonDivisorSubres<ModLong>();
        return ufd;
    }

    public static GreatestCommonDivisorAbstract<ModLong> getProxy(ModLongRing fac) {
        GreatestCommonDivisorSubres ufd1 = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract ufd2 = fac.isField() ? new GreatestCommonDivisorModEval() : new GreatestCommonDivisorSimple();
        return new GCDProxy<ModLong>(ufd1, ufd2);
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        if (fac.isField()) {
            GreatestCommonDivisorModEval<ModInteger> ufd = new GreatestCommonDivisorModEval<ModInteger>();
            return ufd;
        }
        GreatestCommonDivisorSubres<ModInteger> ufd = new GreatestCommonDivisorSubres<ModInteger>();
        return ufd;
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getProxy(ModIntegerRing fac) {
        GreatestCommonDivisorSubres ufd1 = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract ufd2 = fac.isField() ? new GreatestCommonDivisorModEval() : new GreatestCommonDivisorSimple();
        return new GCDProxy<ModInteger>(ufd1, ufd2);
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getImplementation(BigInteger fac) {
        GreatestCommonDivisorModular ufd = new GreatestCommonDivisorModular();
        return ufd;
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getProxy(BigInteger fac) {
        GreatestCommonDivisorSubres ufd1 = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModular ufd2 = new GreatestCommonDivisorModular();
        return new GCDProxy<BigInteger>(ufd1, ufd2);
    }

    public static GreatestCommonDivisorAbstract<BigRational> getImplementation(BigRational fac) {
        GreatestCommonDivisorPrimitive<BigRational> ufd = new GreatestCommonDivisorPrimitive<BigRational>();
        return ufd;
    }

    public static GreatestCommonDivisorAbstract<BigRational> getProxy(BigRational fac) {
        GreatestCommonDivisorSubres ufd1 = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorSimple ufd2 = new GreatestCommonDivisorSimple();
        return new GCDProxy<BigRational>(ufd1, ufd2);
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getImplementation(RingFactory<C> fac) {
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        int t = 0;
        RingFactory<C> ofac = fac;
        if (ofac instanceof BigInteger) {
            t = 1;
        }
        if (ofac instanceof ModIntegerRing) {
            t = 2;
        }
        if (ofac instanceof BigRational) {
            t = 3;
        }
        if (ofac instanceof ModLongRing) {
            t = 4;
        }
        GreatestCommonDivisorAbstract ufd = t == 1 ? new GreatestCommonDivisorModular() : (t == 2 ? new GreatestCommonDivisorModEval() : (t == 3 ? new GreatestCommonDivisorSubres() : (t == 4 ? new GreatestCommonDivisorModEval() : (fac.isField() ? new GreatestCommonDivisorSimple() : new GreatestCommonDivisorSubres()))));
        logger.debug((Object)("ufd = " + ufd));
        return ufd;
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getProxy(RingFactory<C> fac) {
        if (ComputerThreads.NO_THREADS) {
            return GCDFactory.getImplementation(fac);
        }
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        int t = 0;
        RingFactory<C> ofac = fac;
        if (ofac instanceof BigInteger) {
            t = 1;
        }
        if (ofac instanceof ModIntegerRing) {
            t = 2;
        }
        if (ofac instanceof BigRational) {
            t = 3;
        }
        if (ofac instanceof ModLongRing) {
            t = 4;
        }
        GCDProxy<BigInteger> ufd = t == 1 ? new GCDProxy<BigInteger>(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorModular()) : (t == 2 ? new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorModEval()) : (t == 3 ? new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorSimple()) : (t == 4 ? new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorModEval()) : (fac.isField() ? new GCDProxy(new GreatestCommonDivisorSimple(), new GreatestCommonDivisorSubres()) : new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorPrimitive())))));
        logger.debug((Object)("ufd = " + ufd));
        return ufd;
    }
}

