/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDFactoryTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDFactoryTest.suite());
    }

    public GCDFactoryTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDFactoryTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bi = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getImplementation(bi);
        GCDFactoryTest.assertTrue((String)("ufd = Modular " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorModular));
    }

    public void testModInteger() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> ufd = GCDFactory.getImplementation(mi);
        GCDFactoryTest.assertTrue((String)("ufd != ModEval " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorModEval));
        mi = new ModIntegerRing(30L);
        ufd = GCDFactory.getImplementation(mi);
        GCDFactoryTest.assertTrue((String)("ufd != Subres " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSubres));
    }

    public void testBigRational() {
        BigRational b = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> ufd = GCDFactory.getImplementation(b);
        GCDFactoryTest.assertTrue((String)("ufd = Primitive " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex b = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> ufd = GCDFactory.getImplementation(b);
        GCDFactoryTest.assertTrue((String)("ufd != Simple " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational b = new BigRational();
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(b, 1);
        GenPolynomial<BigRational> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isZERO() || mo.isONE() || mo.isConstant()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(mo);
        GreatestCommonDivisorAbstract<BigRational> ufd = GCDFactory.getImplementation(afac);
        GCDFactoryTest.assertTrue((String)("ufd = Subres " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSubres));
        mo = fac.univariate(0).subtract((BigRational)fac.getONE());
        afac = new AlgebraicNumberRing<BigRational>(mo, true);
        ufd = GCDFactory.getImplementation(afac);
        GCDFactoryTest.assertTrue((String)("ufd = Simple " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing b = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> fac = new GenPolynomialRing<ModInteger>(b, 1);
        GenPolynomial<ModInteger> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isZERO() || mo.isONE() || mo.isConstant()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> afac = new AlgebraicNumberRing<ModInteger>(mo);
        MonoidElem a = afac.getONE();
        GreatestCommonDivisorAbstract<ModInteger> ufd = GCDFactory.getImplementation(afac);
        GCDFactoryTest.assertTrue((String)("ufd = Subres " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSubres));
    }
}

