/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorHensel;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDHenselTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    GreatestCommonDivisorAbstract<BigInteger> ufd1;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger cofac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<BigInteger> ac;
    GenPolynomial<BigInteger> bc;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    GenPolynomial<GenPolynomial<BigInteger>> arc;
    GenPolynomial<GenPolynomial<BigInteger>> brc;
    int rl = 3;
    int kl = 34;
    int ll = 5;
    int el = 4;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDHenselTest.suite());
    }

    public GCDHenselTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDHenselTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.cofac = new BigInteger();
        this.ufd = new GreatestCommonDivisorHensel();
        this.dfac = new GenPolynomialRing<BigInteger>(this.cofac, this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(this.cofac, this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testHenselSubresGcd() {
        GenPolynomialRing<BigInteger> dfac = new GenPolynomialRing<BigInteger>(this.cofac, this.rl, this.to);
        int i = 0;
        while (i < 1) {
            GenPolynomial<RingElem<BigInteger>> a = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> b = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> c = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            c = c.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)dfac.univariate(0)))));
            if (!(a.isZERO() || b.isZERO() || c.isZERO())) {
                GCDHenselTest.assertTrue((String)("length( c" + i + " ) <> 0"), (c.length() > 0 ? 1 : 0) != 0);
                a = a.multiply((BigInteger)c);
                b = b.multiply((BigInteger)c);
                GenPolynomial<BigInteger> d = this.ufd.gcd(a, b);
                c = this.ufd.basePrimitivePart((GenPolynomial<BigInteger>)c).abs();
                GenPolynomial<BigInteger> e = PolyUtil.basePseudoRemainder(d, c);
                GCDHenselTest.assertTrue((String)("c | gcd(ac,bc): " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(a, d);
                GCDHenselTest.assertTrue((String)("gcd(a,b) | a: " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(b, d);
                GCDHenselTest.assertTrue((String)("gcd(a,b) | b: " + e), (boolean)e.isZERO());
            }
            ++i;
        }
    }

    public void testHenselLinearSubresGcd() {
        this.ufd1 = new GreatestCommonDivisorHensel(false);
        GenPolynomialRing<BigInteger> dfac = new GenPolynomialRing<BigInteger>(this.cofac, this.rl, this.to);
        int i = 0;
        while (i < 1) {
            GenPolynomial<RingElem<BigInteger>> a = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> b = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> c = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            c = c.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)dfac.univariate(0)))));
            if (!(a.isZERO() || b.isZERO() || c.isZERO())) {
                GCDHenselTest.assertTrue((String)("length( c" + i + " ) <> 0"), (c.length() > 0 ? 1 : 0) != 0);
                a = a.multiply((BigInteger)c);
                b = b.multiply((BigInteger)c);
                long t = System.currentTimeMillis();
                GenPolynomial<BigInteger> d = this.ufd1.gcd(a, b);
                t = System.currentTimeMillis() - t;
                long tq = System.currentTimeMillis();
                tq = System.currentTimeMillis() - tq;
                c = this.ufd.basePrimitivePart((GenPolynomial<BigInteger>)c).abs();
                GenPolynomial<BigInteger> e = PolyUtil.basePseudoRemainder(d, c);
                GCDHenselTest.assertTrue((String)("c | gcd(ac,bc): " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(a, d);
                GCDHenselTest.assertTrue((String)("gcd(a,b) | a: " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(b, d);
                GCDHenselTest.assertTrue((String)("gcd(a,b) | b: " + e), (boolean)e.isZERO());
            }
            ++i;
        }
    }
}

