/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDModLongEvalTest
extends TestCase {
    GreatestCommonDivisorAbstract<ModLong> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<ModLong> dfac;
    GenPolynomialRing<ModLong> cfac;
    GenPolynomialRing<GenPolynomial<ModLong>> rfac;
    PrimeList primes = new PrimeList();
    ModLongRing mi;
    ModLong ai;
    ModLong bi;
    ModLong ci;
    ModLong di;
    ModLong ei;
    GenPolynomial<ModLong> a;
    GenPolynomial<ModLong> b;
    GenPolynomial<ModLong> c;
    GenPolynomial<ModLong> d;
    GenPolynomial<ModLong> e;
    GenPolynomial<GenPolynomial<ModLong>> ar;
    GenPolynomial<GenPolynomial<ModLong>> br;
    GenPolynomial<GenPolynomial<ModLong>> cr;
    GenPolynomial<GenPolynomial<ModLong>> dr;
    GenPolynomial<GenPolynomial<ModLong>> er;
    int rl = 3;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDModLongEvalTest.suite());
    }

    public GCDModLongEvalTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDModLongEvalTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new ModLongRing(19L, true);
        this.ufd = new GreatestCommonDivisorModEval<ModLong>();
        String[] vars = ExpVector.STDVARS(this.rl);
        String[] cvars = ExpVector.STDVARS(this.rl - 1);
        String[] rvars = new String[]{vars[this.rl - 1]};
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, this.rl, this.to, vars);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, this.rl - 1, this.to, cvars);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to, rvars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testModEvalGcd() {
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.c = this.c.multiply((ModLong)((Object)this.dfac.univariate(0)));
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((ModLong)((Object)this.c));
                this.b = this.b.multiply((ModLong)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.c = this.ufd.basePrimitivePart(this.c).abs();
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDModLongEvalTest.assertTrue((String)("gcd(a,b) | a" + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDModLongEvalTest.assertTrue((String)("gcd(a,b) | b" + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testBaseQR() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            do {
                this.ci = this.mi.random(this.kl * (i + 2));
                this.ci = this.ci.sum(this.mi.getONE());
            } while (this.ci.isZERO());
            if (!this.a.isZERO() && !this.c.isZERO()) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.b = this.a.multiply((ModLong)((Object)this.c));
                this.d = PolyUtil.basePseudoRemainder(this.b, this.c);
                GCDModLongEvalTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
                this.b = this.a.multiply(this.ci);
                this.d = this.b.divide(this.ci);
                GCDModLongEvalTest.assertEquals((String)"a == ac/c", this.a, this.d);
                this.b = this.a.multiply((ModLong)((Object)this.c));
                this.d = PolyUtil.basePseudoDivide(this.b, this.c);
                GCDModLongEvalTest.assertEquals((String)"a == ac/c", this.a, this.d);
            }
            ++i;
        }
    }

    public void testBaseContentPP() {
        int i = 0;
        while (i < 13) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.c = this.c.multiply(this.mi.random(this.kl * (i + 2)));
            if (!this.c.isZERO()) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.ci = this.ufd.baseContent(this.c);
                this.d = this.ufd.basePrimitivePart(this.c);
                this.a = this.d.multiply(this.ci);
                GCDModLongEvalTest.assertEquals((String)"c == cont(c)pp(c)", this.c, this.a);
            }
            ++i;
        }
    }

    public void testBaseGcd() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((ModLong)((Object)this.c));
                this.b = this.b.multiply((ModLong)((Object)this.c));
                this.d = this.ufd.baseGcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveQR() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.a = this.ufd.basePrimitivePart(this.a).abs();
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.c = this.ufd.basePrimitivePart(this.a).abs();
            this.cr = PolyUtil.recursive(this.rfac, this.c);
            this.c = this.cfac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.ar = PolyUtil.recursive(this.rfac, this.a);
            if (!this.cr.isZERO() && !this.c.isZERO()) {
                GCDModLongEvalTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.br = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
                this.dr = PolyUtil.recursivePseudoRemainder(this.br, this.cr);
                this.d = PolyUtil.distribute(this.dfac, this.dr);
                GCDModLongEvalTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
                this.br = this.ar.multiply(this.c);
                this.dr = PolyUtil.recursiveDivide(this.br, this.c);
                this.d = PolyUtil.distribute(this.dfac, this.dr);
                GCDModLongEvalTest.assertEquals((String)"a == ac/c", this.a, this.d);
            }
            ++i;
        }
    }

    public void testRecursiveContentPP() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            GCDModLongEvalTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.c = this.ufd.recursiveContent(this.cr);
            this.dr = this.ufd.recursivePrimitivePart(this.cr);
            this.ar = this.dr.multiply(this.c);
            GCDModLongEvalTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
            ++i;
        }
    }

    public void testRecursiveGCD() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 2) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
                this.br = this.br.multiply((GenPolynomial<ModLong>)this.cr);
                this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testArbitraryRecursiveGCD() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 2) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
                this.br = this.br.multiply((GenPolynomial<ModLong>)this.cr);
                this.dr = this.ufd.recursiveGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testContentPP() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        int i = 0;
        while (i < 3) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            if (!this.c.isZERO()) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.ufd.content(this.c);
                this.e = this.a.extend(this.dfac, 0, 0L);
                this.b = this.ufd.primitivePart(this.c);
                this.d = this.e.multiply((ModLong)((Object)this.b));
                GCDModLongEvalTest.assertEquals((String)"c == cont(c)pp(c)", this.d, this.c);
            }
            ++i;
        }
    }

    public void testGCD3() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        int i = 0;
        while (i < 4) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((ModLong)((Object)this.c));
                this.b = this.b.multiply((ModLong)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testGCD() {
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((ModLong)((Object)this.c));
                this.b = this.b.multiply((ModLong)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongEvalTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDModLongEvalTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDModLongEvalTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testLCM() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, 3, 2, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongEvalTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((ModLong)((Object)this.c));
                this.b = this.b.multiply((ModLong)((Object)this.c));
                this.c = this.ufd.gcd(this.a, this.b);
                this.d = this.ufd.lcm(this.a, this.b);
                this.e = this.c.multiply((ModLong)((Object)this.d));
                this.c = this.a.multiply((ModLong)((Object)this.b));
                GCDModLongEvalTest.assertEquals((String)"ab == gcd(a,b)lcm(ab)", this.c, this.e);
            }
            ++i;
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDModLongEvalTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        ArrayList F2 = new ArrayList(5);
        F2.add(this.d);
        F2.add(this.a);
        F2.add(this.b);
        F2.add(this.c);
        F2.add(this.e);
        List<GenPolynomial<Object>> P = this.ufd.coPrime(F2);
        GCDModLongEvalTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDModLongEvalTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
        P = this.ufd.coPrimeRec(F2);
        GCDModLongEvalTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDModLongEvalTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
    }
}

