/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.PrimeList;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDModLongTest
extends TestCase {
    GreatestCommonDivisorAbstract<ModLong> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<ModLong> dfac;
    GenPolynomialRing<ModLong> cfac;
    GenPolynomialRing<GenPolynomial<ModLong>> rfac;
    PrimeList primes = new PrimeList();
    ModLongRing mi;
    ModLong ai;
    ModLong bi;
    ModLong ci;
    ModLong di;
    ModLong ei;
    GenPolynomial<ModLong> a;
    GenPolynomial<ModLong> b;
    GenPolynomial<ModLong> c;
    GenPolynomial<ModLong> d;
    GenPolynomial<ModLong> e;
    GenPolynomial<ModLong> ac;
    GenPolynomial<ModLong> bc;
    GenPolynomial<GenPolynomial<ModLong>> ar;
    GenPolynomial<GenPolynomial<ModLong>> br;
    GenPolynomial<GenPolynomial<ModLong>> cr;
    GenPolynomial<GenPolynomial<ModLong>> dr;
    GenPolynomial<GenPolynomial<ModLong>> er;
    GenPolynomial<GenPolynomial<ModLong>> arc;
    GenPolynomial<GenPolynomial<ModLong>> brc;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDModLongTest.suite());
    }

    public GCDModLongTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDModLongTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new ModLongRing(5L, true);
        this.ufd = new GreatestCommonDivisorPrimitive<ModLong>();
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, this.rl, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testModularEvaluationGcd() {
        GreatestCommonDivisorModular ufd_m = new GreatestCommonDivisorModular();
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> ufd = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> dfac = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        int i = 0;
        while (i < 2) {
            GenPolynomial<RingElem<BigInteger>> a = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> b = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> c = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            c = c.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)dfac.univariate(0)))));
            if (!(a.isZERO() || b.isZERO() || c.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (c.length() > 0 ? 1 : 0) != 0);
                a = a.multiply((BigInteger)c);
                b = b.multiply((BigInteger)c);
                GenPolynomial<BigInteger> d = ((GreatestCommonDivisorAbstract)ufd_m).gcd(a, b);
                c = ufd.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)c).abs();
                GenPolynomial<BigInteger> e = PolyUtil.basePseudoRemainder(d, c);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(a, d);
                GCDModLongTest.assertTrue((String)("gcd(a,b) | a" + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(b, d);
                GCDModLongTest.assertTrue((String)("gcd(a,b) | b" + e), (boolean)e.isZERO());
            }
            ++i;
        }
    }

    public void testModularSimpleGcd() {
        GreatestCommonDivisorModular ufd_m = new GreatestCommonDivisorModular(true);
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> ufd = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> dfac = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        int i = 0;
        while (i < 1) {
            GenPolynomial<RingElem<BigInteger>> a = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> b = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> c = dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            c = c.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)dfac.univariate(0)))));
            if (!(a.isZERO() || b.isZERO() || c.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (c.length() > 0 ? 1 : 0) != 0);
                a = a.multiply((BigInteger)c);
                b = b.multiply((BigInteger)c);
                GenPolynomial<BigInteger> d = ((GreatestCommonDivisorAbstract)ufd_m).gcd(a, b);
                c = ufd.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)c).abs();
                GenPolynomial<BigInteger> e = PolyUtil.basePseudoRemainder(d, c);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(a, d);
                GCDModLongTest.assertTrue((String)("gcd(a,b) | a" + e), (boolean)e.isZERO());
                e = PolyUtil.basePseudoRemainder(b, d);
                GCDModLongTest.assertTrue((String)("gcd(a,b) | b" + e), (boolean)e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveContentPPmodular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        GreatestCommonDivisorPrimitive ufd = new GreatestCommonDivisorPrimitive();
        int i = 0;
        while (i < 1) {
            this.a = this.cfac.random(this.kl, this.ll + 2 * i, this.el + i, this.q).monic();
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.cr = PolyUtil.monic(this.cr);
            this.cr = this.cr.multiply(this.a);
            if (!this.cr.isZERO()) {
                GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.c = ufd.recursiveContent(this.cr).monic();
                this.dr = ufd.recursivePrimitivePart(this.cr);
                this.dr = PolyUtil.monic(this.dr);
                this.ar = this.dr.multiply(this.c);
                GCDModLongTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
            }
            ++i;
        }
    }

    public void testGCDbaseModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        GreatestCommonDivisorPrimitive<ModLong> ufd = new GreatestCommonDivisorPrimitive<ModLong>();
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.ac = this.a.multiply((ModLong)((Object)this.c));
                this.bc = this.b.multiply((ModLong)((Object)this.c));
                this.d = ((GreatestCommonDivisorAbstract)ufd).baseGcd(this.ac, this.bc);
                this.d = this.d.monic();
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 1) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.arc = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
                this.brc = this.br.multiply((GenPolynomial<ModLong>)this.cr);
                this.dr = this.ufd.recursiveUnivariateGcd(this.arc, this.brc);
                this.dr = PolyUtil.monic(this.dr);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testArbitraryRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 1) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.arc = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
                this.brc = this.br.multiply((GenPolynomial<ModLong>)this.cr);
                this.dr = this.ufd.recursiveGcd(this.arc, this.brc);
                this.dr = PolyUtil.monic(this.dr);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testGcdModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 4, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.ac = this.a.multiply((ModLong)((Object)this.c));
                this.bc = this.b.multiply((ModLong)((Object)this.c));
                this.d = this.ufd.gcd(this.ac, this.bc);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.ac, this.d);
                GCDModLongTest.assertTrue((String)("gcd(ac,bc) | ac " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.bc, this.d);
                GCDModLongTest.assertTrue((String)("gcd(ac,bc) | bc " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDModLongTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        ArrayList F2 = new ArrayList(5);
        F2.add(this.a);
        F2.add(this.b);
        F2.add(this.c);
        F2.add(this.d);
        F2.add(this.e);
        List<GenPolynomial<Object>> P = this.ufd.coPrime(F2);
        GCDModLongTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDModLongTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
        P = this.ufd.coPrimeRec(F2);
        GCDModLongTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDModLongTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
    }
}

