/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDPartFracRatTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigRational> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    GenPolynomialRing<BigRational> cfac;
    GenPolynomialRing<GenPolynomial<BigRational>> rfac;
    BigRational mi;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomial<GenPolynomial<BigRational>> ar;
    GenPolynomial<GenPolynomial<BigRational>> br;
    GenPolynomial<GenPolynomial<BigRational>> cr;
    GenPolynomial<GenPolynomial<BigRational>> dr;
    GenPolynomial<GenPolynomial<BigRational>> er;
    int rl = 3;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDPartFracRatTest.suite());
    }

    public GCDPartFracRatTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDPartFracRatTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new BigRational(1L);
        this.ufd = new GreatestCommonDivisorSubres<BigRational>();
        String[] vars = ExpVector.STDVARS(this.rl);
        String[] cvars = ExpVector.STDVARS(this.rl - 1);
        String[] rvars = new String[]{vars[this.rl - 1]};
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, this.rl, this.to, vars);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, this.rl - 1, this.to, cvars);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to, rvars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBaseQR() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            do {
                this.ci = this.mi.random(this.kl * (i + 2));
                this.ci = this.ci.sum(this.mi.getONE());
            } while (this.ci.isZERO());
            if (!this.a.isZERO() && !this.c.isZERO()) {
                GCDPartFracRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.b = this.a.multiply((BigRational)((Object)this.c));
                this.d = PolyUtil.basePseudoRemainder(this.b, this.c);
                GCDPartFracRatTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
                this.b = this.a.multiply(this.ci);
                this.d = this.b.divide(this.ci);
                GCDPartFracRatTest.assertEquals((String)"a == ac/c", this.a, this.d);
                this.b = this.a.multiply((BigRational)((Object)this.c));
                this.d = PolyUtil.basePseudoDivide(this.b, this.c);
                GCDPartFracRatTest.assertEquals((String)"a == ac/c", this.a, this.d);
                this.b = this.a.multiply((BigRational)((Object)this.c)).sum((GenPolynomial<BigRational>)this.dfac.getONE());
                GenPolynomial<BigRational>[] qr = PolyUtil.basePseudoQuotientRemainder(this.b, this.c);
                this.d = qr[0];
                this.e = qr[1];
                this.e = this.d.multiply((BigRational)((Object)this.c)).sum(this.e);
                GCDPartFracRatTest.assertEquals((String)"b == b/c + b%c ", this.b, this.e);
            }
            ++i;
        }
    }

    public void testBaseExtGcd() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDPartFracRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigRational)((Object)this.c));
                this.b = this.b.multiply((BigRational)((Object)this.c));
                GenPolynomial<BigRational>[] egcd = this.ufd.baseExtendedGcd(this.a, this.b);
                this.d = egcd[0];
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDPartFracRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = egcd[1].multiply((BigRational)((Object)this.a)).sum((GenPolynomial<BigRational>)egcd[2].multiply((BigRational)((Object)this.b)));
                GCDPartFracRatTest.assertEquals((String)"gcd(a,b) = s a + t b ", this.d, this.e);
                GenPolynomial<BigRational>[] diop = this.ufd.baseGcdDiophant(this.a, this.b, this.d);
                this.e = diop[0].multiply((BigRational)((Object)this.a)).sum((GenPolynomial<BigRational>)diop[1].multiply((BigRational)((Object)this.b)));
                GCDPartFracRatTest.assertEquals((String)"d*gcd(a,b) = s a + t b ", this.d, this.e);
            }
            ++i;
        }
    }

    public void testBasePartFrac() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            if (!(this.b.isZERO() || this.c.isZERO() || this.b.isConstant() || this.c.isConstant())) {
                GenPolynomial<BigRational> gcd = this.ufd.baseGcd(this.b, this.c);
                if (!gcd.isONE()) {
                    this.b = PolyUtil.basePseudoDivide(this.b, gcd);
                    this.c = PolyUtil.basePseudoDivide(this.c, gcd);
                }
                GenPolynomial<BigRational>[] pf = this.ufd.basePartialFraction(this.a, this.b, this.c);
                this.d = pf[0].multiply((BigRational)((Object)this.b)).multiply(this.c);
                this.e = this.c.multiply((BigRational)((Object)pf[1])).sum((GenPolynomial<BigRational>)this.b.multiply((BigRational)((Object)pf[2])));
                this.d = this.d.sum((BigRational)((Object)this.e));
                GCDPartFracRatTest.assertEquals((String)"a = a0*b*c + s * c + t * b ", this.a, this.d);
                ArrayList D2 = new ArrayList(2);
                D2.add(this.b);
                D2.add(this.c);
                List F2 = this.ufd.basePartialFraction(this.a, D2);
                boolean t = this.ufd.isBasePartialFraction(this.a, D2, F2);
                GCDPartFracRatTest.assertTrue((String)"a/D = a0 + sum(fi/di)", (boolean)t);
            }
            ++i;
        }
    }

    public void testBasePartFracList() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            List<GenPolynomial<Object>> D2 = new ArrayList();
            int j = 0;
            while (j < i * 3) {
                this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
                if (!this.b.isZERO() && !this.b.isConstant()) {
                    D2.add(this.b);
                }
                ++j;
            }
            D2 = this.ufd.coPrime(D2);
            List F2 = this.ufd.basePartialFraction(this.a, D2);
            boolean t = this.ufd.isBasePartialFraction(this.a, D2, F2);
            GCDPartFracRatTest.assertTrue((String)"a = a0*b*c + s * c + t * b ", (boolean)t);
            ++i;
        }
    }

    public void testBasePartFracExponent() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            if (!this.b.isZERO() && !this.b.isConstant()) {
                List F2 = this.ufd.basePartialFraction(this.a, this.b, 3);
                boolean t = this.ufd.isBasePartialFraction(this.a, this.b, 3, F2);
                GCDPartFracRatTest.assertTrue((String)"a/b^e = a0 + sum(ai/p^i) ", (boolean)t);
            }
            ++i;
        }
    }

    public void testBasePartFracListExponent() {
        SquarefreeAbstract<BigRational> sqf = SquarefreeFactory.getImplementation(this.mi);
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            List<GenPolynomial<Object>> D2 = new ArrayList();
            int j = 0;
            while (j < i * 3) {
                this.b = this.dfac.random(this.kl, this.ll + 1 + i, this.el + i, this.q);
                if (!this.b.isZERO() && !this.b.isConstant()) {
                    D2.add(this.b);
                }
                ++j;
            }
            D2 = this.ufd.coPrime(D2);
            TreeMap Ds = new TreeMap();
            long j2 = 1L;
            for (GenPolynomial<Object> p : D2) {
                Ds.put(p, j2);
                ++j2;
            }
            List F2 = sqf.basePartialFraction(this.a, Ds);
            boolean t = sqf.isBasePartialFraction(this.a, Ds, F2);
            GCDPartFracRatTest.assertTrue((String)"a/prod(b_i^i) = a0 + sum(aij/b_i^j) ", (boolean)t);
            ++i;
        }
    }
}

