/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDPrimitiveTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDPrimitiveTest.suite());
    }

    public GCDPrimitiveTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDPrimitiveTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        String[] vars = ExpVector.STDVARS(this.rl);
        String[] cvars = ExpVector.STDVARS(this.rl - 1);
        String[] rvars = new String[]{vars[this.rl - 1]};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to, vars);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to, cvars);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to, rvars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBaseQR() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.ci = this.di.random(this.kl * (i + 2));
            this.ci = this.ci.sum(this.di.getONE());
            if (!this.a.isZERO() && !this.c.isZERO()) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.b = this.a.multiply((BigInteger)((Object)this.c));
                this.d = PolyUtil.basePseudoRemainder(this.b, this.c);
                GCDPrimitiveTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
                this.b = this.a.multiply(this.ci);
                this.d = this.b.divide(this.ci);
                GCDPrimitiveTest.assertEquals((String)"a == ac/c", this.a, this.d);
                this.b = this.a.multiply((BigInteger)((Object)this.c));
                this.d = PolyUtil.basePseudoDivide(this.b, this.c);
                GCDPrimitiveTest.assertEquals((String)"a == ac/c", this.a, this.d);
            }
            ++i;
        }
    }

    public void testBaseContentPP() {
        this.di = new BigInteger(1L);
        int i = 0;
        while (i < 13) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.c = this.c.multiply(this.di.random(this.kl * (i + 2)));
            if (!this.c.isZERO()) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.ci = this.ufd.baseContent(this.c);
                this.d = this.ufd.basePrimitivePart(this.c);
                this.a = this.d.multiply(this.ci);
                GCDPrimitiveTest.assertEquals((String)"c == cont(c)pp(c)", this.c, this.a);
            }
            ++i;
        }
    }

    public void testBaseGcd() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.baseGcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveQR() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.a = this.ufd.basePrimitivePart(this.a).abs();
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.c = this.ufd.basePrimitivePart(this.a).abs();
            this.cr = PolyUtil.recursive(this.rfac, this.c);
            this.c = this.cfac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.ar = PolyUtil.recursive(this.rfac, this.a);
            if (!this.cr.isZERO() && !this.c.isZERO()) {
                GCDPrimitiveTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.br = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = PolyUtil.recursivePseudoRemainder(this.br, this.cr);
                this.d = PolyUtil.distribute(this.dfac, this.dr);
                GCDPrimitiveTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
                this.br = this.ar.multiply(this.c);
                this.dr = PolyUtil.recursiveDivide(this.br, this.c);
                this.d = PolyUtil.distribute(this.dfac, this.dr);
                GCDPrimitiveTest.assertEquals((String)"a == ac/c", this.a, this.d);
            }
            ++i;
        }
    }

    public void testRecursiveContentPP() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            GCDPrimitiveTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.c = this.ufd.recursiveContent(this.cr);
            this.dr = this.ufd.recursivePrimitivePart(this.cr);
            this.ar = this.dr.multiply(this.c);
            GCDPrimitiveTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
            ++i;
        }
    }

    public void testRecursiveGCD() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 2) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testArbitraryRecursiveGCD() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 2) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testContentPP() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        int i = 0;
        while (i < 3) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.ufd.content(this.c);
            this.e = this.a.extend(this.dfac, 0, 0L);
            this.b = this.ufd.primitivePart(this.c);
            this.d = this.e.multiply((BigInteger)((Object)this.b));
            GCDPrimitiveTest.assertEquals((String)"c == cont(c)pp(c)", this.d, this.c);
            ++i;
        }
    }

    public void testGCD3() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        int i = 0;
        while (i < 4) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testGCD() {
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testGCDfield() {
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), 3, this.to);
        GreatestCommonDivisorPrimitive<BigRational> ufd = new GreatestCommonDivisorPrimitive<BigRational>();
        int i = 0;
        while (i < 1) {
            GenPolynomial<RingElem<BigRational>> a = dfac.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> b = dfac.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<BigRational> c = dfac.random(this.kl, this.ll, this.el, this.q);
            if (!(a.isZERO() || b.isZERO() || c.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( c" + i + " ) <> 0"), (c.length() > 0 ? 1 : 0) != 0);
                a = a.multiply((BigRational)((Object)c));
                b = b.multiply((BigRational)((Object)c));
                GenPolynomial<BigRational> d = ufd.gcd(a, b);
                GenPolynomial<BigRational> e = PolyUtil.basePseudoRemainder(d, c);
                GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + e), (boolean)e.isZERO());
            }
            ++i;
        }
    }

    public void testLCM() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, 3, 2, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDPrimitiveTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.c = this.ufd.gcd(this.a, this.b);
                this.d = this.ufd.lcm(this.a, this.b);
                this.e = this.c.multiply((BigInteger)((Object)this.d));
                this.c = this.a.multiply((BigInteger)((Object)this.b));
                GCDPrimitiveTest.assertEquals((String)"ab == gcd(a,b)lcm(ab)", this.c, this.e);
            }
            ++i;
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDPrimitiveTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((BigInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.c);
        ArrayList F2 = new ArrayList(5);
        F2.add(this.d);
        F2.add(this.a);
        F2.add(this.b);
        F2.add(this.c);
        F2.add(this.e);
        List<GenPolynomial<Object>> P = this.ufd.coPrime(F2);
        GCDPrimitiveTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDPrimitiveTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
        P = this.ufd.coPrimeRec(F2);
        GCDPrimitiveTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(P));
        GCDPrimitiveTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(P, F2));
    }
}

