/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class GCDProxy<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = Logger.getLogger(GCDProxy.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GreatestCommonDivisorAbstract<C> e1;
    public final GreatestCommonDivisorAbstract<C> e2;
    protected ExecutorService pool;

    public GCDProxy(GreatestCommonDivisorAbstract<C> e1, GreatestCommonDivisorAbstract<C> e2) {
        this.e1 = e1;
        this.e2 = e2;
        if (this.pool == null) {
            this.pool = ComputerThreads.getPool();
        }
    }

    @Override
    public String toString() {
        return "GCDProxy[ " + this.e1.getClass().getName() + ", " + this.e2.getClass().getName() + " ]";
    }

    @Override
    public GenPolynomial<C> baseGcd(final GenPolynomial<C> P, final GenPolynomial<C> S) {
        if (this.debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomial g = null;
        ArrayList cs = new ArrayList(2);
        cs.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e1.baseGcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e1 " + GCDProxy.this.e1.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e1 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e1 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e1 " + e);
                }
            }
        });
        cs.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e2.baseGcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e2 " + GCDProxy.this.e2.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e2 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e2 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e2 " + e);
                }
            }
        });
        try {
            g = (GenPolynomial)this.pool.invokeAny(cs);
        }
        catch (InterruptedException ignored) {
            logger.info((Object)("InterruptedException " + ignored));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.info((Object)("ExecutionException " + e));
            Thread.currentThread().interrupt();
        }
        return g;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(final GenPolynomial<GenPolynomial<C>> P, final GenPolynomial<GenPolynomial<C>> S) {
        if (this.debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomial g = null;
        ArrayList cs = new ArrayList(2);
        cs.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e1.recursiveUnivariateGcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e1 " + GCDProxy.this.e1.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e1 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e1 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e1 " + e);
                }
            }
        });
        cs.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e2.recursiveUnivariateGcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e2 " + GCDProxy.this.e2.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e2 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e2 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e2 " + e);
                }
            }
        });
        try {
            g = (GenPolynomial)this.pool.invokeAny(cs);
        }
        catch (InterruptedException ignored) {
            logger.info((Object)("InterruptedException " + ignored));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.info((Object)("ExecutionException " + e));
            Thread.currentThread().interrupt();
        }
        return g;
    }

    @Override
    public GenPolynomial<C> gcd(final GenPolynomial<C> P, final GenPolynomial<C> S) {
        if (this.debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomial g = null;
        ArrayList cs = new ArrayList(2);
        cs.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e1.gcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e1 " + GCDProxy.this.e1.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e1 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e1 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e1 " + e);
                }
            }
        });
        cs.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial g = GCDProxy.this.e2.gcd(P, S);
                    if (GCDProxy.this.debug) {
                        logger.info((Object)("GCDProxy done e2 " + GCDProxy.this.e2.getClass().getName()));
                    }
                    return g;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GCDProxy e2 pre " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GCDProxy e2 " + e));
                    logger.info((Object)("GCDProxy P = " + P));
                    logger.info((Object)("GCDProxy S = " + S));
                    throw new RuntimeException("GCDProxy e2 " + e);
                }
            }
        });
        try {
            g = (GenPolynomial)this.pool.invokeAny(cs);
        }
        catch (InterruptedException ignored) {
            logger.info((Object)("InterruptedException " + ignored));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.info((Object)("ExecutionException " + e));
            Thread.currentThread().interrupt();
        }
        return g;
    }
}

