/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDProxyTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 5;
    int ll = 7;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDProxyTest.suite());
    }

    public GCDProxyTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDProxyTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    public void testBigInteger() {
        BigInteger bi = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> ufd_par = GCDFactory.getProxy(bi);
        GCDProxyTest.assertTrue((String)("ufd_par != null " + ufd_par), (ufd_par != null ? 1 : 0) != 0);
        GreatestCommonDivisorSubres<BigInteger> ufd = new GreatestCommonDivisorSubres<BigInteger>();
        GCDProxyTest.assertTrue((String)("ufd != null " + ufd), (ufd != null ? 1 : 0) != 0);
        this.dfac = new GenPolynomialRing<BigInteger>(bi, 4, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.b = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.c = this.dfac.random(this.kl + 2, this.ll, this.el, this.q);
            this.c = ufd.primitivePart(this.c).abs();
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                long t = System.currentTimeMillis();
                this.d = ufd_par.gcd(this.a, this.b);
                t = System.currentTimeMillis() - t;
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
        ComputerThreads.terminate();
    }

    public void testModInteger() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> ufd_par = GCDFactory.getProxy(mi);
        GCDProxyTest.assertTrue((String)("ufd_par != null " + ufd_par), (ufd_par != null ? 1 : 0) != 0);
        GreatestCommonDivisorSubres<ModInteger> ufd = new GreatestCommonDivisorSubres<ModInteger>();
        GCDProxyTest.assertTrue((String)("ufd != null " + ufd), (ufd != null ? 1 : 0) != 0);
        GenPolynomialRing<ModInteger> dfac = new GenPolynomialRing<ModInteger>(mi, 4, this.to);
        int i = 0;
        while (i < 1) {
            GenPolynomial<AbelianGroupElem<ModInteger>> a = dfac.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            GenPolynomial<AbelianGroupElem<ModInteger>> b = dfac.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            AbelianGroupElem c = dfac.random(this.kl, this.ll, this.el, this.q);
            c = ufd.primitivePart((GenPolynomial<ModInteger>)c).abs();
            if (!(a.isZERO() || b.isZERO() || ((GenPolynomial)c).isZERO())) {
                GCDProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (((GenPolynomial)c).length() > 0 ? 1 : 0) != 0);
                a = a.multiply((ModInteger)c);
                b = b.multiply((ModInteger)c);
                long t = System.currentTimeMillis();
                GenPolynomial<ModInteger> d = ufd_par.gcd(a, b);
                t = System.currentTimeMillis() - t;
                GenPolynomial e = PolyUtil.basePseudoRemainder(d, c);
                GCDProxyTest.assertTrue((String)("c | gcd(ac,bc) " + e), (boolean)e.isZERO());
            }
            ++i;
        }
        ComputerThreads.terminate();
    }

    public void testBigRational() {
        BigRational b = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> ufd = GCDFactory.getImplementation(b);
        GCDProxyTest.assertTrue((String)("ufd = Primitive " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex b = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> ufd = GCDFactory.getImplementation(b);
        GCDProxyTest.assertTrue((String)("ufd != Simple " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSimple));
    }

    public void xtestAlgebraicNumberBigRational() {
        BigRational b = new BigRational();
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(b, 1);
        GenPolynomial<BigRational> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isConstant() || mo.isZERO()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(mo);
        GreatestCommonDivisorAbstract<BigRational> ufd = GCDFactory.getImplementation(afac);
        GCDProxyTest.assertTrue((String)("ufd = Subres " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSubres));
        mo = fac.univariate(0).subtract((BigRational)fac.getONE());
        afac = new AlgebraicNumberRing<BigRational>(mo, true);
        ufd = GCDFactory.getImplementation(afac);
        GCDProxyTest.assertTrue((String)("ufd = Simple " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing b = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> fac = new GenPolynomialRing<ModInteger>(b, 1);
        GenPolynomial<ModInteger> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isConstant() || mo.isZERO()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> afac = new AlgebraicNumberRing<ModInteger>(mo);
        MonoidElem a = afac.getONE();
        GreatestCommonDivisorAbstract<ModInteger> ufd = GCDFactory.getImplementation(afac);
        GCDProxyTest.assertTrue((String)("ufd = Subres " + ufd), (boolean)(ufd instanceof GreatestCommonDivisorSubres));
    }
}

