/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDSimpleTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDSimpleTest.suite());
    }

    public GCDSimpleTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDSimpleTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = new GreatestCommonDivisorSimple<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBaseGcdSimple() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2, this.el + 2, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.cfac.univariate(0)));
            if (!this.c.isZERO()) {
                this.c = this.ufd.basePrimitivePart(this.c).abs();
                GCDSimpleTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.baseGcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveGCDSimple() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDSimpleTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testArbitraryRecursiveGCDSimple() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 3) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDSimpleTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testGCDSimple() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 4, this.to);
        int i = 0;
        while (i < 2) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            this.c = this.ufd.primitivePart(this.c).abs();
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDSimpleTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }
}

