/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDSubresTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)GCDSubresTest.suite());
    }

    public GCDSubresTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GCDSubresTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        String[] vars = ExpVector.STDVARS(this.rl);
        String[] cvars = ExpVector.STDVARS(this.rl - 1);
        String[] rvars = new String[]{vars[this.rl - 1]};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to, vars);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to, cvars);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to, rvars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBaseGcdSubres() {
        this.ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2, this.el + 2, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            if (!this.c.isZERO()) {
                this.c = this.ufd.basePrimitivePart(this.c).abs();
                GCDSubresTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.baseGcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDSubresTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | a" + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | b" + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testRecursiveGCDsubres() {
        this.ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDSubresTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDSubresTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testArbitraryRecursiveGCDsubres() {
        this.ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDSubresTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = this.ufd.recursiveGcd(this.ar, this.br);
                this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
                GCDSubresTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
                this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
            }
            ++i;
        }
    }

    public void testGCDsubres() {
        this.ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 5, this.to);
        int i = 0;
        while (i < 2) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            this.c = this.ufd.primitivePart(this.c).abs();
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDSubresTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = this.ufd.gcd(this.a, this.b);
                this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
                GCDSubresTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
                this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
                GCDSubresTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
            }
            ++i;
        }
    }

    public void testBaseSubresultant() {
        GreatestCommonDivisorSubres<BigInteger> ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        int i = 0;
        while (i < 1) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
            if (!this.c.isZERO()) {
                GCDSubresTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = ufd.baseResultant(this.a, this.b);
                this.e = ufd.baseGcd(this.a, this.b);
                if (!this.e.isConstant()) {
                    GCDSubresTest.assertTrue((String)("res(a,b) == 0 " + this.d), (boolean)this.d.isZERO());
                } else {
                    GCDSubresTest.assertTrue((String)("res(a,b) != 0 " + this.d), (!this.d.isZERO() ? 1 : 0) != 0);
                }
            }
            ++i;
        }
    }

    public void testRecursiveSubresultant() {
        GreatestCommonDivisorSubres ufd = new GreatestCommonDivisorSubres();
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        int i = 0;
        while (i < 5) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, 2, this.q);
            if (!(this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO())) {
                GCDSubresTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
                this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
                this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
                this.dr = ufd.recursiveResultant(this.ar, this.br);
                this.er = ufd.recursiveUnivariateGcd(this.ar, this.br);
                if (this.er.isZERO()) {
                    GCDSubresTest.assertTrue((String)("res(a,b) = 0 " + this.dr + " e = " + this.er), (boolean)this.dr.isZERO());
                }
                if (this.er.isConstant() && this.er.leadingBaseCoefficient().isConstant()) {
                    GCDSubresTest.assertTrue((String)("res(a,b) != 0 " + this.dr + ", e = " + this.er + ", a = " + this.ar + ", b = " + this.br), (!this.dr.isZERO() ? 1 : 0) != 0);
                } else {
                    GCDSubresTest.assertTrue((String)("res(a,b) = 0 or not const " + this.dr + ", e = " + this.er + ", a = " + this.ar + ", b = " + this.br), (this.dr.isZERO() || !this.dr.isConstant() || !this.dr.leadingBaseCoefficient().isConstant() ? 1 : 0) != 0);
                }
            }
            ++i;
        }
    }

    public void testSubres() {
        GreatestCommonDivisorSubres<BigInteger> ufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        int i = 0;
        while (i < 2) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
            if (!(this.a.isZERO() || this.b.isZERO() || this.c.isZERO())) {
                GCDSubresTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
                this.a = this.a.multiply((BigInteger)((Object)this.c));
                this.b = this.b.multiply((BigInteger)((Object)this.c));
                this.d = ufd.resultant(this.a, this.b);
                this.e = ufd.gcd(this.a, this.b);
                if (this.e.isZERO()) {
                    GCDSubresTest.assertTrue((String)("res(a,b) = 0 " + this.d + " e = " + this.e), (boolean)this.d.isZERO());
                }
                if (this.e.isConstant()) {
                    GCDSubresTest.assertTrue((String)("res(a,b) != 0 " + this.d + ", e = " + this.e + ", a = " + this.a + ", b = " + this.b), (!this.d.isZERO() ? 1 : 0) != 0);
                } else {
                    GCDSubresTest.assertTrue((String)("res(a,b) = 0 or not const " + this.d + ", e = " + this.e + ", a = " + this.a + ", b = " + this.b), (this.d.isZERO() || !this.d.isConstant() ? 1 : 0) != 0);
                }
            }
            ++i;
        }
    }
}

