/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GreatestCommonDivisorAbstract<C extends GcdRingElem<C>>
implements GreatestCommonDivisor<C> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorAbstract.class);
    private final boolean debug = logger.isDebugEnabled();

    public String toString() {
        return this.getClass().getName();
    }

    public C baseContent(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return (C)((GcdRingElem)P.ring.getZEROCoefficient());
        }
        AbelianGroupElem d = null;
        for (GcdRingElem c : P.getMap().values()) {
            if (!(d = d == null ? c : d.gcd(c)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> P) {
        GenPolynomial<C> p;
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<C> pp = P.divide(d);
        if (this.debug && !(p = pp.multiply(d)).equals(P)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return pp;
    }

    public abstract GenPolynomial<C> baseGcd(GenPolynomial<C> var1, GenPolynomial<C> var2);

    public GenPolynomial<C> recursiveContent(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return (GenPolynomial)P.ring.getZEROCoefficient();
        }
        GenPolynomial<C> d = null;
        for (GenPolynomial<C> c : P.getMap().values()) {
            if (!(d = d == null ? c : this.gcd(d, c)).isONE()) continue;
            return d;
        }
        return d.abs();
    }

    public GenPolynomial<GenPolynomial<C>> recursivePrimitivePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomial<C> d = this.recursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<GenPolynomial<C>> pp = PolyUtil.recursiveDivide(P, d);
        return pp;
    }

    public C baseRecursiveContent(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            GenPolynomialRing cf = (GenPolynomialRing)P.ring.coFac;
            return (C)((GcdRingElem)cf.coFac.getZERO());
        }
        AbelianGroupElem d = null;
        for (GenPolynomial<C> c : P.getMap().values()) {
            C cc = this.baseContent(c);
            if (!(d = d == null ? cc : this.gcd(d, cc)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenPolynomial<GenPolynomial<C>> baseRecursivePrimitivePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseRecursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<GenPolynomial<C>> pp = PolyUtil.baseRecursiveDivide(P, d);
        return pp;
    }

    public GenPolynomial<GenPolynomial<C>> recursiveGcd(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar <= 1) {
            return this.recursiveUnivariateGcd(P, S);
        }
        GenPolynomialRing rfac = P.ring;
        RingFactory rrfac = rfac.coFac;
        GenPolynomialRing cfac = (GenPolynomialRing)rrfac;
        GenPolynomialRing dfac = cfac.extend(rfac.nvar);
        GenPolynomial Pd = PolyUtil.distribute(dfac, P);
        GenPolynomial Sd = PolyUtil.distribute(dfac, S);
        GenPolynomial Dd = this.gcd(Pd, Sd);
        GenPolynomial C = PolyUtil.recursive(rfac, Dd);
        return C;
    }

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> var1, GenPolynomial<GenPolynomial<C>> var2);

    @Override
    public GenPolynomial<C> content(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " use baseContent for univariate polynomials");
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial D2 = this.recursiveContent(Pr);
        return D2;
    }

    @Override
    public GenPolynomial<C> primitivePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.basePrimitivePart(P);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial PP = this.recursivePrimitivePart(Pr);
        GenPolynomial D2 = PolyUtil.distribute(pfac, PP);
        return D2;
    }

    public GenPolynomial<C> divide(GenPolynomial<C> a, C b) {
        if (b == null || b.isZERO()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        if (a == null || a.isZERO()) {
            return a;
        }
        return a.divide(b);
    }

    public C gcd(C a, C b) {
        if (b == null || b.isZERO()) {
            return a;
        }
        if (a == null || a.isZERO()) {
            return b;
        }
        return (C)((GcdRingElem)a.gcd(b));
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            GenPolynomial<C> T = this.baseGcd(P, S);
            return T;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Sr = PolyUtil.recursive(rfac, S);
        GenPolynomial Dr = this.recursiveUnivariateGcd(Pr, Sr);
        GenPolynomial D2 = PolyUtil.distribute(pfac, Dr);
        return D2;
    }

    @Override
    public GenPolynomial<C> lcm(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomial<C> C = this.gcd(P, S);
        GenPolynomial<GenPolynomial<C>> A = P.multiply(S);
        return PolyUtil.basePseudoDivide(A, C);
    }

    @Override
    public GenPolynomial<C> resultant(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GreatestCommonDivisorSubres ufd_sr = new GreatestCommonDivisorSubres();
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            GenPolynomial T = ufd_sr.baseResultant(P, S);
            return T;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Sr = PolyUtil.recursive(rfac, S);
        GenPolynomial Dr = ufd_sr.recursiveResultant(Pr, Sr);
        GenPolynomial D2 = PolyUtil.distribute(pfac, Dr);
        return D2;
    }

    @Override
    public List<GenPolynomial<C>> coPrime(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        List<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>(A.size());
        AbelianGroupElem<GenPolynomial<C>> a = A.get(0);
        if (!((GenPolynomial)a).isZERO() && !((GenPolynomial)a).isConstant()) {
            int i = 1;
            while (i < A.size()) {
                GenPolynomial<C> b = A.get(i);
                AbelianGroupElem g = this.gcd((GenPolynomial<C>)a, b).abs();
                if (!g.isONE()) {
                    a = PolyUtil.basePseudoDivide(a, g);
                    b = PolyUtil.basePseudoDivide(b, g);
                    AbelianGroupElem gp = this.gcd((GenPolynomial<C>)a, (GenPolynomial<C>)g).abs();
                    while (!((GenPolynomial)gp).isONE()) {
                        a = PolyUtil.basePseudoDivide(a, gp);
                        g = PolyUtil.basePseudoDivide(g, gp);
                        B.add((GenPolynomial<C>)g);
                        g = gp;
                        gp = this.gcd((GenPolynomial<C>)a, (GenPolynomial<C>)gp).abs();
                    }
                    if (!g.isZERO() && !g.isConstant()) {
                        B.add((GenPolynomial<C>)g);
                    }
                }
                if (!b.isZERO() && !b.isConstant()) {
                    B.add(b);
                }
                ++i;
            }
        } else {
            B.addAll(A.subList(1, A.size()));
        }
        a = ((GenPolynomial)a).abs();
        B = this.coPrime(B);
        if (!((GenPolynomial)a).isZERO() && !((GenPolynomial)a).isConstant()) {
            B.add((GenPolynomial<C>)a);
        }
        return B;
    }

    public List<GenPolynomial<C>> coPrimeRec(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        List<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> a : A) {
            B = this.coPrime(a, B);
        }
        return B;
    }

    @Override
    public List<GenPolynomial<C>> coPrime(GenPolynomial<C> a, List<GenPolynomial<C>> P) {
        if (a == null || a.isZERO() || a.isConstant()) {
            return P;
        }
        ArrayList<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>(P.size() + 1);
        int i = 0;
        while (i < P.size()) {
            GenPolynomial<C> b = P.get(i);
            AbelianGroupElem g = this.gcd(a, b).abs();
            if (!((GenPolynomial)g).isONE()) {
                a = PolyUtil.basePseudoDivide(a, g);
                b = PolyUtil.basePseudoDivide(b, g);
                AbelianGroupElem gp = this.gcd(a, (GenPolynomial<C>)g).abs();
                while (!((GenPolynomial)gp).isONE()) {
                    a = PolyUtil.basePseudoDivide(a, gp);
                    if (!((GenPolynomial)(g = PolyUtil.basePseudoDivide(g, gp))).isZERO() && !((GenPolynomial)g).isConstant()) {
                        B.add((GenPolynomial<C>)g);
                    }
                    g = gp;
                    gp = this.gcd(a, (GenPolynomial<C>)gp).abs();
                }
                gp = this.gcd(b, (GenPolynomial<C>)g).abs();
                while (!((GenPolynomial)gp).isONE()) {
                    b = PolyUtil.basePseudoDivide(b, gp);
                    if (!((GenPolynomial)(g = PolyUtil.basePseudoDivide(g, gp))).isZERO() && !((GenPolynomial)g).isConstant()) {
                        B.add((GenPolynomial<C>)g);
                    }
                    g = gp;
                    gp = this.gcd(b, (GenPolynomial<C>)gp).abs();
                }
                if (!((GenPolynomial)g).isZERO() && !((GenPolynomial)g).isConstant()) {
                    B.add((GenPolynomial<C>)g);
                }
            }
            if (!b.isZERO() && !b.isConstant()) {
                B.add(b);
            }
            ++i;
        }
        if (!a.isZERO() && !a.isConstant()) {
            B.add(a);
        }
        return B;
    }

    @Override
    public boolean isCoPrime(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return true;
        }
        if (A.size() == 1) {
            return true;
        }
        int i = 0;
        while (i < A.size()) {
            GenPolynomial<C> a = A.get(i);
            int j = i + 1;
            while (j < A.size()) {
                GenPolynomial<C> b = A.get(j);
                GenPolynomial<C> g = this.gcd(a, b);
                if (!g.isONE()) {
                    System.out.println("not co-prime, a: " + a);
                    System.out.println("not co-prime, b: " + b);
                    System.out.println("not co-prime, g: " + g);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isCoPrime(List<GenPolynomial<C>> P, List<GenPolynomial<C>> A) {
        if (!this.isCoPrime(P)) {
            return false;
        }
        if (A == null || A.isEmpty()) {
            return true;
        }
        for (GenPolynomial<C> q : A) {
            if (q.isZERO() || q.isConstant()) continue;
            boolean divides = false;
            for (GenPolynomial<C> p : P) {
                GenPolynomial<C> a = PolyUtil.basePseudoRemainder(q, p);
                if (!a.isZERO()) continue;
                divides = true;
                break;
            }
            if (divides) continue;
            System.out.println("no divisor for: " + q);
            return false;
        }
        return true;
    }

    public GenPolynomial<C>[] baseExtendedGcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        GenPolynomial<C>[] hegcd = this.baseHalfExtendedGcd(P, S);
        GenPolynomial[] ret = new GenPolynomial[3];
        ret[0] = hegcd[0];
        ret[1] = hegcd[1];
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> x = hegcd[0].subtract(hegcd[1].multiply(P));
        GenPolynomial<GenPolynomial<GenPolynomial<C>>>[] qr = PolyUtil.basePseudoQuotientRemainder(x, S);
        ret[2] = qr[0];
        return ret;
    }

    public GenPolynomial<C>[] baseHalfExtendedGcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        GenPolynomial[] ret = new GenPolynomial[]{null, null};
        if (S == null || S.isZERO()) {
            ret[0] = P;
            ret[1] = P.ring.getONE();
            return ret;
        }
        if (P == null || P.isZERO()) {
            ret[0] = S;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (P.ring.nvar != 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " not univariate polynomials " + P.ring);
        }
        GenPolynomial<RingElem<GenPolynomial<Object>>> q = P;
        GenPolynomial<C> r = S;
        GenPolynomial<GcdRingElem> c1 = ((GenPolynomial)P.ring.getONE()).clone();
        GenPolynomial<GenPolynomial<Object>> d1 = ((GenPolynomial)P.ring.getZERO()).clone();
        while (!r.isZERO()) {
            GenPolynomial<C>[] qr = PolyUtil.basePseudoQuotientRemainder(q, r);
            q = qr[0];
            GenPolynomial<GenPolynomial<Object>> x = c1.subtract((GcdRingElem)((Object)q.multiply((RingElem<GenPolynomial<Object>>)d1)));
            c1 = d1;
            d1 = x;
            q = r;
            r = qr[1];
        }
        GcdRingElem g = (GcdRingElem)q.leadingBaseCoefficient();
        if (g.isUnit()) {
            GcdRingElem h = (GcdRingElem)g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    public GenPolynomial<C>[] baseGcdDiophant(GenPolynomial<C> P, GenPolynomial<C> S, GenPolynomial<C> c) {
        GenPolynomial<C>[] egcd = this.baseExtendedGcd(P, S);
        GenPolynomial<C> g = egcd[0];
        GenPolynomial<Object>[] qr = PolyUtil.basePseudoQuotientRemainder(c, g);
        if (!qr[1].isZERO()) {
            throw new ArithmeticException("not solvable, r = " + qr[1] + ", c = " + c + ", g = " + g);
        }
        GenPolynomial<C> q = qr[0];
        GenPolynomial<Object> a = egcd[1].multiply(q);
        GenPolynomial<GenPolynomial<GenPolynomial<Object>>> b = egcd[2].multiply(q);
        if (!a.isZERO() && a.degree(0) >= S.degree(0)) {
            qr = PolyUtil.basePseudoQuotientRemainder(a, S);
            a = qr[1];
            b = b.sum((GenPolynomial<GenPolynomial<Object>>)((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)P.multiply(qr[0])));
        }
        GenPolynomial[] ret = new GenPolynomial[]{a, b};
        return ret;
    }

    public GenPolynomial<C>[] basePartialFraction(GenPolynomial<C> A, GenPolynomial<C> P, GenPolynomial<C> S) {
        GenPolynomial[] ret = new GenPolynomial[]{null, null, null};
        GenPolynomial<GenPolynomial<C>> ps = P.multiply(S);
        GenPolynomial<GenPolynomial<C>>[] qr = PolyUtil.basePseudoQuotientRemainder(A, ps);
        ret[0] = qr[0];
        GenPolynomial<GenPolynomial<C>> r = qr[1];
        GenPolynomial<GenPolynomial<C>>[] diop = this.baseGcdDiophant(S, P, r);
        ret[1] = diop[0];
        ret[2] = diop[1];
        if (ret[1].degree(0) >= P.degree(0)) {
            qr = PolyUtil.basePseudoQuotientRemainder(ret[1], P);
            ret[0] = ret[0].sum(qr[0]);
            ret[1] = qr[1];
        }
        if (ret[2].degree(0) >= S.degree(0)) {
            qr = PolyUtil.basePseudoQuotientRemainder(ret[2], S);
            ret[0] = ret[0].sum(qr[0]);
            ret[2] = qr[1];
        }
        return ret;
    }

    public List<GenPolynomial<C>> basePartialFraction(GenPolynomial<C> A, GenPolynomial<C> P, int e) {
        if (A == null || P == null || e == 0) {
            throw new IllegalArgumentException("null A, P or e = 0 not allowed");
        }
        ArrayList<GenPolynomial<C>> pf = new ArrayList<GenPolynomial<C>>(e);
        if (A.isZERO()) {
            int i = 0;
            while (i < e) {
                pf.add(A);
                ++i;
            }
            return pf;
        }
        if (e == 1) {
            GenPolynomial<C>[] qr = PolyUtil.basePseudoQuotientRemainder(A, P);
            pf.add(qr[0]);
            pf.add(qr[1]);
            return pf;
        }
        GenPolynomial<C> a = A;
        int j = e;
        while (j > 0) {
            GenPolynomial<C>[] qr = PolyUtil.basePseudoQuotientRemainder(a, P);
            a = qr[0];
            pf.add(0, qr[1]);
            --j;
        }
        pf.add(0, a);
        return pf;
    }

    public List<GenPolynomial<C>> basePartialFraction(GenPolynomial<C> A, List<GenPolynomial<C>> D2) {
        if (D2 == null || A == null) {
            throw new IllegalArgumentException("null A or D not allowed");
        }
        ArrayList<GenPolynomial<C>> pf = new ArrayList<GenPolynomial<C>>(D2.size() + 1);
        if (A.isZERO() || D2.size() == 0) {
            pf.add(A);
            int i = 0;
            while (i < D2.size()) {
                pf.add(A);
                ++i;
            }
            return pf;
        }
        ArrayList<GenPolynomial<C>> Dp = new ArrayList<GenPolynomial<C>>(D2.size() - 1);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> P = A.ring.getONE();
        GenPolynomial<C> d1 = null;
        for (GenPolynomial<C> d : D2) {
            if (d1 == null) {
                d1 = d;
                continue;
            }
            P = P.multiply((GenPolynomial<GenPolynomial<C>>)d);
            Dp.add(d);
        }
        GenPolynomial<Object>[] qr = PolyUtil.basePseudoQuotientRemainder(A, P.multiply((GenPolynomial<GenPolynomial<C>>)d1));
        GenPolynomial<Object> A0 = qr[0];
        GenPolynomial<Object> r = qr[1];
        if (D2.size() == 1) {
            pf.add(A0);
            pf.add(r);
            return pf;
        }
        GenPolynomial<Object>[] diop = this.baseGcdDiophant(P, d1, r);
        GenPolynomial<Object> A1 = diop[0];
        GenPolynomial<Object> S = diop[1];
        List<GenPolynomial<Object>> Fr = this.basePartialFraction(S, Dp);
        A0 = A0.sum((Object)(Fr.remove(0)));
        pf.add(A0);
        pf.add(A1);
        pf.addAll(Fr);
        return pf;
    }

    public boolean isBasePartialFraction(GenPolynomial<C> A, List<GenPolynomial<C>> D2, List<GenPolynomial<C>> F2) {
        if (D2 == null || A == null || F2 == null) {
            throw new IllegalArgumentException("null A, F or D not allowed");
        }
        if (D2.size() != F2.size() - 1) {
            return false;
        }
        MonoidElem<GenPolynomial<GenPolynomial<C>>> P = A.ring.getONE();
        for (GenPolynomial<C> d : D2) {
            P = ((GenPolynomial)P).multiply(d);
        }
        ArrayList<GenPolynomial<C>> Fp = new ArrayList<GenPolynomial<C>>(F2);
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>> A0 = ((GenPolynomial)Fp.remove(0)).multiply(P);
        int j = 0;
        for (GenPolynomial genPolynomial : Fp) {
            P = A.ring.getONE();
            int i = 0;
            for (GenPolynomial<C> d : D2) {
                if (i != j) {
                    P = ((GenPolynomial)P).multiply(d);
                }
                ++i;
            }
            A0 = A0.sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)genPolynomial.multiply(P));
            ++j;
        }
        boolean bl = A.equals(A0);
        if (!bl) {
            System.out.println("not isPartFrac = " + A0);
        }
        return bl;
    }

    public boolean isBasePartialFraction(GenPolynomial<C> A, GenPolynomial<C> P, int e, List<GenPolynomial<C>> F2) {
        if (A == null || P == null || F2 == null || e == 0) {
            throw new IllegalArgumentException("null A, P, F or e = 0 not allowed");
        }
        GenPolynomial<C> A0 = this.basePartialFractionValue(P, e, F2);
        boolean t = A.equals(A0);
        if (!t) {
            System.out.println("not isPartFrac = " + A0);
        }
        return t;
    }

    public GenPolynomial<C> basePartialFractionValue(GenPolynomial<C> P, int e, List<GenPolynomial<C>> F2) {
        if (P == null || F2 == null || e == 0) {
            throw new IllegalArgumentException("null P, F or e = 0 not allowed");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> A0 = P.ring.getZERO();
        for (GenPolynomial<C> Fi : F2) {
            A0 = A0.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)P);
            A0 = A0.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)Fi);
        }
        return A0;
    }
}

