/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorHensel<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorSubres<BigInteger> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorHensel.class);
    private final boolean debug = logger.isDebugEnabled();
    public final boolean quadratic;

    public GreatestCommonDivisorHensel() {
        this(true);
    }

    public GreatestCommonDivisorHensel(boolean quadratic) {
        this.quadratic = quadratic;
    }

    @Override
    public GenPolynomial<BigInteger> baseGcd(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        AbelianGroupElem<GenPolynomial<BigInteger>> q;
        AbelianGroupElem<GenPolynomial<BigInteger>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " no univariate polynomial");
        }
        GenPolynomialRing fac = P.ring;
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        BigInteger a = this.baseContent(r);
        BigInteger b = this.baseContent(q);
        BigInteger c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        BigInteger ac = (BigInteger)((GenPolynomial)r).leadingBaseCoefficient();
        BigInteger bc = (BigInteger)((GenPolynomial)q).leadingBaseCoefficient();
        BigInteger cc = this.gcd(ac, bc);
        ExpVector rdegv = ((GenPolynomial)r).degreeVector();
        ExpVector qdegv = ((GenPolynomial)q).degreeVector();
        PrimeList primes = new PrimeList(PrimeList.Range.medium);
        int pn = 50;
        GenPolynomial<ModLong> cm = null;
        GenPolynomial[] ecm = null;
        GenPolynomial sm = null;
        GenPolynomial tm = null;
        HenselApprox<ModLong> lift = null;
        if (this.debug) {
            logger.debug((Object)("c = " + c));
            logger.debug((Object)("cc = " + cc));
            logger.debug((Object)("primes = " + primes));
        }
        int i = 0;
        for (java.math.BigInteger p : primes) {
            GenPolynomial<ModLong> cmf;
            AbelianGroupElem<GenPolynomial<BigInteger>> crq;
            GenPolynomial<ModLong> rm;
            GenPolynomialRing<ModLong> mfac;
            GenPolynomial<ModLong> qm;
            if (++i >= pn) {
                logger.error((Object)("prime list exhausted, pn = " + pn));
                logger.info((Object)("primes = " + primes));
                return super.baseGcd(P, S);
            }
            Iterable<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
            GcdRingElem nf = (GcdRingElem)cofac.fromInteger(cc.getVal());
            if (nf.isZERO() || (nf = (GcdRingElem)cofac.fromInteger(((BigInteger)((GenPolynomial)q).leadingBaseCoefficient()).getVal())).isZERO() || (nf = (GcdRingElem)cofac.fromInteger(((BigInteger)((GenPolynomial)r).leadingBaseCoefficient()).getVal())).isZERO() || !(qm = PolyUtil.fromIntegerCoefficients(mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac.nvar, fac.tord, fac.getVars()), q)).degreeVector().equals(qdegv) || !(rm = PolyUtil.fromIntegerCoefficients(mfac, r)).degreeVector().equals(rdegv)) continue;
            if (this.debug) {
                logger.info((Object)("cofac = " + cofac.getIntegerModul()));
            }
            if ((cm = qm.gcd(rm)).isConstant()) {
                logger.debug((Object)("cm, constant = " + cm));
                return ((GenPolynomial)fac.getONE()).multiply(c);
            }
            GenPolynomial<ModLong> rmf = rm.divide(cm);
            ecm = cm.egcd(rmf);
            if (ecm[0].isONE()) {
                crq = r;
                cmf = rmf;
                sm = ecm[1];
                tm = ecm[2];
            } else {
                GenPolynomial<ModLong> qmf = qm.divide(cm);
                ecm = cm.egcd(qmf);
                if (ecm[0].isONE()) {
                    crq = q;
                    cmf = qmf;
                    sm = ecm[1];
                    tm = ecm[2];
                } else {
                    logger.info((Object)"giving up on Hensel gcd reverting to Subres gcd");
                    return super.baseGcd(P, S);
                }
            }
            BigInteger cn = (BigInteger)((GenPolynomial)crq).maxNorm();
            cn = cn.multiply(((BigInteger)((GenPolynomial)crq).leadingBaseCoefficient()).abs());
            cn = cn.multiply(cn.fromInteger(2L));
            if (this.debug) {
                System.out.println("crq = " + crq);
                System.out.println("cm  = " + cm);
                System.out.println("cmf = " + cmf);
                System.out.println("sm  = " + sm);
                System.out.println("tm  = " + tm);
                System.out.println("cn  = " + cn);
            }
            try {
                lift = this.quadratic ? HenselUtil.liftHenselQuadratic(crq, cn, cm, cmf, sm, tm) : HenselUtil.liftHensel(crq, cn, cm, cmf, sm, tm);
            }
            catch (NoLiftingException nle) {
                logger.info((Object)("giving up on Hensel gcd reverting to Subres gcd " + nle));
                return super.baseGcd(P, S);
            }
            q = lift.A;
            if (this.debug) {
                System.out.println("q   = " + q);
                System.out.println("qf  = " + lift.B);
            }
            q = this.basePrimitivePart(q);
            if (PolyUtil.basePseudoRemainder(P, q = ((GenPolynomial)q).multiply((GenPolynomial<BigInteger>)((Object)c)).abs()).isZERO() && PolyUtil.basePseudoRemainder(S, q).isZERO()) break;
            logger.info((Object)"final devision not successfull");
        }
        return q;
    }
}

