/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorModular<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorAbstract<edu.jas.arith.BigInteger> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorModular.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<MOD> mufd;
    protected final GreatestCommonDivisorAbstract<edu.jas.arith.BigInteger> iufd = new GreatestCommonDivisorSubres<edu.jas.arith.BigInteger>();

    public GreatestCommonDivisorModular() {
        this(false);
    }

    public GreatestCommonDivisorModular(boolean simple) {
        this.mufd = simple ? new GreatestCommonDivisorSimple<MOD>() : new GreatestCommonDivisorModEval();
    }

    @Override
    public GenPolynomial<edu.jas.arith.BigInteger> baseGcd(GenPolynomial<edu.jas.arith.BigInteger> P, GenPolynomial<edu.jas.arith.BigInteger> S) {
        return this.iufd.baseGcd(P, S);
    }

    @Override
    public GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> P, GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> S) {
        return this.iufd.recursiveUnivariateGcd(P, S);
    }

    @Override
    public GenPolynomial<edu.jas.arith.BigInteger> gcd(GenPolynomial<edu.jas.arith.BigInteger> P, GenPolynomial<edu.jas.arith.BigInteger> S) {
        edu.jas.arith.BigInteger bn;
        AbelianGroupElem<GenPolynomial<edu.jas.arith.BigInteger>> q;
        AbelianGroupElem<GenPolynomial<edu.jas.arith.BigInteger>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomialRing<edu.jas.arith.BigInteger> fac = P.ring;
        if (fac.nvar <= 1) {
            GenPolynomial<edu.jas.arith.BigInteger> T = this.baseGcd(P, S);
            return T;
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        edu.jas.arith.BigInteger a = this.baseContent(r);
        edu.jas.arith.BigInteger b = this.baseContent(q);
        edu.jas.arith.BigInteger c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<edu.jas.arith.BigInteger>)((Object)c));
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<edu.jas.arith.BigInteger>)((Object)c));
        }
        edu.jas.arith.BigInteger ac = (edu.jas.arith.BigInteger)((GenPolynomial)r).leadingBaseCoefficient();
        edu.jas.arith.BigInteger bc = (edu.jas.arith.BigInteger)((GenPolynomial)q).leadingBaseCoefficient();
        edu.jas.arith.BigInteger cc = this.gcd(ac, bc);
        edu.jas.arith.BigInteger an = (edu.jas.arith.BigInteger)((GenPolynomial)r).maxNorm();
        edu.jas.arith.BigInteger n = an.compareTo(bn = (edu.jas.arith.BigInteger)((GenPolynomial)q).maxNorm()) < 0 ? bn : an;
        n = n.multiply(cc).multiply(n.fromInteger(2L));
        ExpVector rdegv = ((GenPolynomial)r).degreeVector();
        ExpVector qdegv = ((GenPolynomial)q).degreeVector();
        edu.jas.arith.BigInteger af = an.multiply(PolyUtil.factorBound(rdegv));
        edu.jas.arith.BigInteger bf = bn.multiply(PolyUtil.factorBound(qdegv));
        edu.jas.arith.BigInteger cf = af.compareTo(bf) < 0 ? bf : af;
        cf = cf.multiply(cc.multiply(cc.fromInteger(8L)));
        PrimeList primes = new PrimeList();
        int pn = 10;
        ExpVector wdegv = rdegv.subst(0, rdegv.getVal(0) + 1L);
        Iterable<ModLong> cofacM = null;
        GenPolynomialRing<ModLong> rfac = null;
        int i = 0;
        edu.jas.arith.BigInteger M = null;
        edu.jas.arith.BigInteger cfe = null;
        GenPolynomial<ModLong> cp = null;
        GenPolynomial<ModLong> cm = null;
        GenPolynomial<edu.jas.arith.BigInteger> cpi = null;
        if (this.debug) {
            logger.debug((Object)("c = " + c));
            logger.debug((Object)("cc = " + cc));
            logger.debug((Object)("n  = " + n));
            logger.debug((Object)("cf = " + cf));
            logger.info((Object)("wdegv = " + wdegv));
        }
        for (BigInteger p : primes) {
            GenPolynomial<ModLong> rm;
            GenPolynomialRing<ModLong> mfac;
            GenPolynomial<ModLong> qm;
            if (p.longValue() == 2L) continue;
            if (++i >= pn) {
                logger.error((Object)("prime list exhausted, pn = " + pn));
                return this.iufd.gcd(P, S);
            }
            Iterable<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
            GcdRingElem nf = (GcdRingElem)cofac.fromInteger(cc.getVal());
            if (nf.isZERO() || !(qm = PolyUtil.fromIntegerCoefficients(mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac.nvar, fac.tord, fac.getVars()), q)).degreeVector().equals(qdegv) || !(rm = PolyUtil.fromIntegerCoefficients(mfac, r)).degreeVector().equals(rdegv)) continue;
            if (this.debug) {
                logger.info((Object)("cofac = " + cofac.getIntegerModul()));
            }
            if ((cm = this.mufd.gcd(rm, qm)).isConstant()) {
                logger.debug((Object)("cm, constant = " + cm));
                return ((GenPolynomial)fac.getONE()).multiply(c);
            }
            ExpVector mdegv = cm.degreeVector();
            if (wdegv.equals(mdegv)) {
                if (M != null && M.compareTo(cfe) > 0) {
                    System.out.println("M > cfe: " + M + " > " + cfe);
                }
            } else {
                boolean ok = false;
                if (wdegv.multipleOf(mdegv)) {
                    M = null;
                    ok = true;
                }
                if (mdegv.multipleOf(wdegv)) continue;
                if (!ok) {
                    M = null;
                    continue;
                }
            }
            cm = cm.multiply((ModLong)nf);
            if (M == null) {
                M = new edu.jas.arith.BigInteger(p);
                cofacM = cofac;
                rfac = mfac;
                cp = cm;
                wdegv = wdegv.gcd(mdegv);
                cfe = cf;
                int k = 0;
                while (k < wdegv.length()) {
                    cfe = cfe.multiply(new edu.jas.arith.BigInteger(wdegv.getVal(k) + 1L));
                    ++k;
                }
            } else {
                GcdRingElem mi = (GcdRingElem)cofac.fromInteger(M.getVal());
                mi = (GcdRingElem)mi.inverse();
                cofacM = ModLongRing.MAX_LONG.compareTo((M = M.multiply(new edu.jas.arith.BigInteger(p))).getVal()) > 0 ? new ModLongRing(M.getVal()) : new ModIntegerRing(M.getVal());
                rfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofacM), fac.nvar, fac.tord, fac.getVars());
                cp = PolyUtil.chineseRemainder(rfac, cp, mi, cm);
            }
            if (n.compareTo(M) <= 0) break;
            cpi = PolyUtil.integerFromModularCoefficients(fac, cp);
            edu.jas.arith.BigInteger cmn = cpi.sumNorm();
            cmn = cmn.multiply(cmn.fromInteger(4L));
            if (i % 2 == 0 || cp.isZERO()) continue;
            GenPolynomial<edu.jas.arith.BigInteger> x = PolyUtil.integerFromModularCoefficients(fac, cp);
            if (!PolyUtil.basePseudoRemainder(q, x = this.basePrimitivePart(x)).isZERO() || !PolyUtil.basePseudoRemainder(r, x).isZERO()) continue;
            logger.info((Object)("done on exact division, #primes = " + i));
            break;
        }
        if (this.debug) {
            logger.info((Object)("done on M = " + M + ", #primes = " + i));
        }
        q = PolyUtil.integerFromModularCoefficients(fac, cp);
        q = this.basePrimitivePart(q);
        return ((GenPolynomial)((GenPolynomial)q).abs()).multiply(c);
    }
}

