/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HenselUtil {
    private static final Logger logger = Logger.getLogger(HenselUtil.class);
    private static final boolean debug = logger.isInfoEnabled();

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        GcdRingElem b;
        RingFactory p;
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        BigInteger Mq = Qi;
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        GcdRingElem ci = (GcdRingElem)P.fromInteger(c.getVal());
        A = A.multiply((Object)ci);
        B = B.multiply((Object)ci);
        T = T.divide((Object)ci);
        S = S.divide((Object)ci);
        GenPolynomial<RingElem<BigInteger>> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<RingElem<BigInteger>> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        while (Mq.compareTo(M2) < 0) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> E2 = C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi))));
            if (E2.isZERO()) {
                logger.info((Object)"leaving on zero error");
                break;
            }
            E2 = E2.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pfac, E2);
            GenPolynomial<GenPolynomial<Object>> Ap = S.multiply((Object)Ep);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Bp = T.multiply((Object)Ep);
            GenPolynomial<Object>[] QR = Ap.quotientRemainder(B);
            GenPolynomial<Object> Qp = QR[0];
            GenPolynomial<Object> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)A.multiply((Object)Qp));
            GenPolynomial<RingElem<BigInteger>> Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            GenPolynomial<RingElem<BigInteger>> Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            GenPolynomial<BigInteger> Ea1 = Ea.multiply(Qi);
            GenPolynomial<BigInteger> Eb1 = Eb.multiply(Qi);
            Ea = Ai.sum((BigInteger)((Object)Eb1));
            Eb = Bi.sum((BigInteger)((Object)Ea1));
            assert (Ea.degree(0) + Eb.degree(0) <= C.degree(0));
            Mq = Qi;
            Qi = Q.getIntegerModul().multiply(P.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            Ai = Ea;
            Bi = Eb;
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger bi = null;
        try {
            bi = c.divide(ai);
            Bi = Bi.divide(bi);
        }
        catch (RuntimeException e) {
            throw new NoLiftingException("no exact lifting possible " + e);
        }
        return new HenselApprox<Object>(Ai, Bi, A1p, B1p);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = A.egcd(B);
        if (!gst[0].isONE()) {
            throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
        }
        GenPolynomial<MOD> s = gst[1];
        GenPolynomial<MOD> t = gst[2];
        HenselApprox<MOD> ab = HenselUtil.liftHensel(C, M, A, B, s, t);
        return ab;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        GcdRingElem b;
        RingFactory p;
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        BigInteger Mq = Qi;
        GenPolynomialRing qfac = new GenPolynomialRing(Q, pfac);
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        GcdRingElem ci = (GcdRingElem)P.fromInteger(c.getVal());
        A = A.multiply((Object)ci);
        B = B.multiply((Object)ci);
        T = T.divide((Object)ci);
        S = S.divide((Object)ci);
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        GenPolynomial<Object> Sp = S;
        GenPolynomial<Object> Tp = T;
        GenPolynomial<RingElem<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(fac, S);
        GenPolynomial<RingElem<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(fac, T);
        GenPolynomial Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
        GenPolynomial Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
        while (Mq.compareTo(M2) < 0) {
            MonoidElem<GenPolynomial<GenPolynomial<BigInteger>>> E2 = C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi))));
            if (((GenPolynomial)E2).isZERO()) {
                logger.info((Object)"leaving on zero error");
                break;
            }
            E2 = ((GenPolynomial)E2).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(qfac, E2);
            Ep.isZERO();
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Ap = Sp.multiply((Object)Ep);
            GenPolynomial Bp = Tp.multiply((Object)Ep);
            GenPolynomial<GenPolynomial<C>>[] QR = Ap.quotientRemainder(Bq);
            GenPolynomial Qp = QR[0];
            GenPolynomial<GenPolynomial<Object>> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum(Aq.multiply(Qp));
            GenPolynomial<RingElem<BigInteger>> Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            GenPolynomial<RingElem<BigInteger>> Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            GenPolynomial<RingElem<BigInteger>> Ea1 = Ea.multiply(Qi);
            GenPolynomial<RingElem<BigInteger>> Eb1 = Eb.multiply(Qi);
            Ea = Ai.sum((BigInteger)((Object)Eb1));
            Eb = Bi.sum((BigInteger)((Object)Ea1));
            assert (Ea.degree(0) + Eb.degree(0) <= C.degree(0));
            Ai = Ea;
            Bi = Eb;
            E2 = fac.getONE();
            E2 = ((GenPolynomial)E2).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            E2 = ((GenPolynomial)E2).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            Ep = PolyUtil.fromIntegerCoefficients(qfac, E2);
            Ap = Sp.multiply((Object)Ep);
            Bp = Tp.multiply((Object)Ep);
            QR = Bp.quotientRemainder(Aq);
            Qp = QR[0];
            Rp = QR[1];
            B1p = Rp;
            A1p = Ap.sum(Bq.multiply(Qp));
            Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            Ea1 = Ea.multiply(Qi);
            Eb1 = Eb.multiply(Qi);
            Ea = Si.sum((BigInteger)((Object)Ea1));
            Eb = Ti.sum((BigInteger)((Object)Eb1));
            Si = Ea;
            Ti = Eb;
            Mq = Qi;
            Qi = Q.getIntegerModul().multiply(Q.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            qfac = new GenPolynomialRing(Q, pfac);
            Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
            Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
            Sp = PolyUtil.fromIntegerCoefficients(qfac, Si);
            Tp = PolyUtil.fromIntegerCoefficients(qfac, Ti);
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger bi = null;
        try {
            bi = c.divide(ai);
            Bi = Bi.divide(bi);
        }
        catch (RuntimeException e) {
            throw new NoLiftingException("no exact lifting possible " + e);
        }
        return new HenselApprox<Object>(Ai, Bi, A1p, B1p);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = A.egcd(B);
        if (!gst[0].isONE()) {
            throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
        }
        GenPolynomial<MOD> s = gst[1];
        GenPolynomial<MOD> t = gst[2];
        HenselApprox<MOD> ab = HenselUtil.liftHenselQuadratic(C, M, A, B, s, t);
        return ab;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = A.egcd(B);
        if (!gst[0].isONE()) {
            throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
        }
        GenPolynomial<MOD> s = gst[1];
        GenPolynomial<MOD> t = gst[2];
        HenselApprox<MOD> ab = HenselUtil.liftHenselQuadraticFac(C, M, A, B, s, t);
        return ab;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        MonoidElem<GenPolynomial<GenPolynomial<ModLong>>> Em;
        GcdRingElem ci;
        GcdRingElem b;
        BigInteger PP;
        RingFactory p;
        GenPolynomial[] AB = new GenPolynomial[2];
        if (C == null || C.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = PP = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        if (debug) {
            logger.debug((Object)("M2 =  " + M2));
        }
        BigInteger Mq = Qi;
        GenPolynomialRing qfac = new GenPolynomialRing(Q, pfac);
        BigInteger Mi = Q.getIntegerModul().multiply(Q.getIntegerModul());
        Iterable<ModLong> Qmm = ModLongRing.MAX_LONG.compareTo(Mi.getVal()) > 0 ? new ModLongRing(Mi.getVal()) : new ModIntegerRing(Mi.getVal());
        GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)Qmm), qfac);
        GcdRingElem Qm = (GcdRingElem)Qmm.fromInteger(Qi.getVal());
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        if ((ci = (GcdRingElem)P.fromInteger(c.getVal())).isZERO()) {
            System.out.println("c =  " + c);
            System.out.println("P =  " + P);
            throw new ArithmeticException("c mod p == 0 not meaningful");
        }
        A = A.multiply((Object)ci);
        S = S.divide((Object)ci);
        B = B.multiply((Object)ci);
        T = T.divide((Object)ci);
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<GenPolynomial<GenPolynomial>> A1p = A;
        GenPolynomial<GenPolynomial<GenPolynomial>> B1p = B;
        GenPolynomial<Object> Sp = S;
        GenPolynomial<Object> Tp = T;
        GenPolynomial<BigInteger> Si = PolyUtil.integerFromModularCoefficients(fac, S);
        GenPolynomial<BigInteger> Ti = PolyUtil.integerFromModularCoefficients(fac, T);
        GenPolynomial<GenPolynomial> Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
        GenPolynomial<GenPolynomial> Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
        GenPolynomial<ModLong> Cm = PolyUtil.fromIntegerCoefficients(mfac, C);
        GenPolynomial<ModLong> Am = PolyUtil.fromIntegerCoefficients(mfac, Ai);
        GenPolynomial<ModLong> Bm = PolyUtil.fromIntegerCoefficients(mfac, Bi);
        GenPolynomial<RingElem<ModLong>> Sm = PolyUtil.fromIntegerCoefficients(mfac, Si);
        GenPolynomial<RingElem<ModLong>> Tm = PolyUtil.fromIntegerCoefficients(mfac, Ti);
        while (Mq.compareTo(M2) < 0) {
            GenPolynomial<GenPolynomial<GenPolynomial>> Rp;
            if (debug) {
                logger.debug((Object)("mfac =  " + Cm.ring));
            }
            if (((GenPolynomial)(Em = Cm.subtract((ModLong)((Object)Am.multiply((ModLong)((Object)Bm)))))).isZERO() && C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi)))).isZERO()) {
                logger.info((Object)"leaving on zero error");
                break;
            }
            GenPolynomial<BigInteger> Ei = PolyUtil.integerFromModularCoefficients(fac, Em);
            GenPolynomial Emp = PolyUtil.fromIntegerCoefficients(qfac, Ei = Ei.divide(Qi));
            if (Emp.isZERO() && C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi)))).isZERO()) {
                logger.info((Object)"leaving on zero error Emp");
                break;
            }
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial>>> Ap = Sp.multiply((Object)Emp);
            GenPolynomial<GenPolynomial<GenPolynomial>> Bp = Tp.multiply((Object)Emp);
            GenPolynomial[] QR = null;
            QR = Ap.quotientRemainder(Bq);
            GenPolynomial Qp = QR[0];
            A1p = Rp = QR[1];
            B1p = Bp.sum(Aq.multiply(Qp));
            GenPolynomial<RingElem<ModLong>> Ema = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, A1p));
            GenPolynomial<RingElem<ModLong>> Emb = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, B1p));
            GenPolynomial<RingElem<ModLong>> Ema1 = Ema.multiply((ModLong)Qm);
            GenPolynomial<RingElem<ModLong>> Emb1 = Emb.multiply((ModLong)Qm);
            Ema = Am.sum((ModLong)((Object)Emb1));
            Emb = Bm.sum((ModLong)((Object)Ema1));
            assert (Ema.degree(0) + Emb.degree(0) <= Cm.degree(0));
            Am = Ema;
            Bm = Emb;
            Ai = PolyUtil.integerFromModularCoefficients(fac, Am);
            Bi = PolyUtil.integerFromModularCoefficients(fac, Bm);
            Em = mfac.getONE();
            Em = ((GenPolynomial)Em).subtract(Sm.multiply((ModLong)((Object)Am))).subtract(Tm.multiply((ModLong)((Object)Bm)));
            Ei = PolyUtil.integerFromModularCoefficients(fac, Em);
            Ei = Ei.divide(Qi);
            Emp = PolyUtil.fromIntegerCoefficients(qfac, Ei);
            Ap = Sp.multiply((Object)Emp);
            Bp = Tp.multiply((Object)Emp);
            QR = Bp.quotientRemainder(Aq);
            Qp = QR[0];
            B1p = Rp = QR[1];
            A1p = Ap.sum((GenPolynomial<GenPolynomial<GenPolynomial>>)Bq.multiply(Qp));
            Ema = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, A1p));
            Emb = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, B1p));
            Ema1 = Ema.multiply(Qm);
            Emb1 = Emb.multiply(Qm);
            Ema = Sm.sum((ModLong)((Object)Ema1));
            Emb = Tm.sum((ModLong)((Object)Emb1));
            Sm = Ema;
            Tm = Emb;
            Si = PolyUtil.integerFromModularCoefficients(fac, Sm);
            Ti = PolyUtil.integerFromModularCoefficients(fac, Tm);
            Mq = Qi = Q.getIntegerModul().multiply(Q.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            qfac = new GenPolynomialRing(Q, pfac);
            BigInteger Qmmi = Qmm.getIntegerModul().multiply(Qmm.getIntegerModul());
            Qmm = ModLongRing.MAX_LONG.compareTo(Qmmi.getVal()) > 0 ? new ModLongRing(Qmmi.getVal()) : new ModIntegerRing(Qmmi.getVal());
            mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)Qmm), qfac);
            Qm = (GcdRingElem)Qmm.fromInteger(Qi.getVal());
            Cm = PolyUtil.fromIntegerCoefficients(mfac, C);
            Am = PolyUtil.fromIntegerCoefficients(mfac, Ai);
            Bm = PolyUtil.fromIntegerCoefficients(mfac, Bi);
            Sm = PolyUtil.fromIntegerCoefficients(mfac, Si);
            Tm = PolyUtil.fromIntegerCoefficients(mfac, Ti);
            assert (HenselUtil.isHenselLift(C, Mi, PP, Ai, Bi));
            Mi = Mi.fromInteger(Qmm.getIntegerModul().getVal());
            Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
            Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
            Sp = PolyUtil.fromIntegerCoefficients(qfac, Si);
            Tp = PolyUtil.fromIntegerCoefficients(qfac, Ti);
        }
        Em = Cm.subtract((ModLong)((Object)Am.multiply((ModLong)((Object)Bm))));
        if (!((GenPolynomial)Em).isZERO()) {
            System.out.println("Em =  " + Em);
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger[] qr = c.quotientRemainder(ai);
        BigInteger bi = null;
        boolean exact = true;
        if (qr[1].isZERO()) {
            bi = qr[0];
            try {
                Bi = Bi.divide(bi);
            }
            catch (RuntimeException e) {
                System.out.println("*catch: no exact factorization: " + bi + ", e = " + e);
                exact = false;
            }
        } else {
            System.out.println("*remainder: no exact factorization: q = " + qr[0] + ", r = " + qr[1]);
            exact = false;
        }
        if (!exact) {
            System.out.println("*Ai =  " + Ai);
            System.out.println("*ai =  " + ai);
            System.out.println("*Bi =  " + Bi);
            System.out.println("*bi =  " + bi);
            System.out.println("*c  =  " + c);
            throw new NoLiftingException("no exact lifting possible");
        }
        return new HenselApprox(Ai, Bi, Aq, Bq);
    }

    public static boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, List<GenPolynomial<BigInteger>> G) {
        GenPolynomial<ModInteger> hlp;
        if (C == null || C.isZERO()) {
            return false;
        }
        GenPolynomialRing pfac = C.ring;
        ModIntegerRing pm = new ModIntegerRing(p.getVal(), true);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, pfac);
        MonoidElem<GenPolynomial<ModInteger>> cl = mfac.getONE();
        for (GenPolynomial<BigInteger> hl : G) {
            hlp = PolyUtil.fromIntegerCoefficients(mfac, hl);
            cl = ((GenPolynomial)cl).multiply(hlp);
        }
        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(mfac, C);
        if (!cp.equals(cl)) {
            System.out.println("Hensel precondition wrong!");
            System.out.println("cl    = " + cl);
            System.out.println("cp    = " + cp);
            System.out.println("cp-cl = " + cp.subtract((ModInteger)cl));
            System.out.println("M = " + M + ", p = " + p);
            return false;
        }
        BigInteger mip = p;
        while (mip.compareTo(M) < 0) {
            mip = mip.multiply(mip);
        }
        pm = new ModIntegerRing(mip.getVal(), false);
        mfac = new GenPolynomialRing<ModInteger>(pm, pfac);
        cl = mfac.getONE();
        for (GenPolynomial<BigInteger> hl : G) {
            hlp = PolyUtil.fromIntegerCoefficients(mfac, hl);
            cl = ((GenPolynomial)cl).multiply(hlp);
        }
        cp = PolyUtil.fromIntegerCoefficients(mfac, C);
        if (!cp.equals(cl)) {
            System.out.println("Hensel post condition wrong!");
            System.out.println("cl    = " + cl);
            System.out.println("cp    = " + cp);
            System.out.println("cp-cl = " + cp.subtract((ModInteger)cl));
            System.out.println("M = " + M + ", p = " + p + ", p^e = " + mip);
            return false;
        }
        return true;
    }

    public static boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, GenPolynomial<BigInteger> A, GenPolynomial<BigInteger> B) {
        ArrayList<GenPolynomial<BigInteger>> G = new ArrayList<GenPolynomial<BigInteger>>(2);
        G.add(A);
        G.add(B);
        return HenselUtil.isHenselLift(C, M, p, G);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, HenselApprox<MOD> Ha) {
        ArrayList<GenPolynomial<BigInteger>> G = new ArrayList<GenPolynomial<BigInteger>>(2);
        G.add(Ha.A);
        G.add(Ha.B);
        return HenselUtil.isHenselLift(C, M, p, G);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> GenPolynomial<MOD>[] liftExtendedEuclideanP2k(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long k) throws NoLiftingException {
        BigInteger p;
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = A.egcd(B);
        if (!gst[0].isONE()) {
            throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
        }
        GenPolynomial<Object> S = gst[1];
        GenPolynomial<Object> T = gst[2];
        System.out.println("\nS = " + S);
        System.out.println("T = " + T);
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        MonoidElem one = ifac.getONE();
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<BigInteger> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        GenPolynomial<BigInteger> Ti = PolyUtil.integerFromModularCoefficients(ifac, T);
        ModularRingFactory mcfac = (ModularRingFactory)fac.coFac;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        int i = 0;
        while ((long)i < k) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> e = ((GenPolynomial)one).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            System.out.println("\ne = " + e);
            e = e.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)modul));
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(mfac, e);
            System.out.println("c = " + c + ": " + c.ring.coFac);
            GenPolynomial<GenPolynomial<GcdRingElem>> s = S.multiply((Object)c);
            GenPolynomial<GenPolynomial<Object>> t = T.multiply((Object)c);
            GenPolynomial<GenPolynomial<C>>[] QR = s.quotientRemainder(B);
            GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> q = QR[0];
            s = QR[1];
            t = t.sum((GenPolynomial<Object>)q.multiply((GenPolynomial<GenPolynomial<MOD>>)A));
            BigInteger m = modul;
            modul = modul.multiply(p);
            mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
            System.out.println("mcfac = " + mcfac);
            mfac = new GenPolynomialRing(mcfac, fac);
            GcdRingElem mo = (GcdRingElem)mcfac.fromInteger(m.getVal());
            S = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(ifac, S));
            T = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(ifac, T));
            s = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(ifac, s));
            t = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(ifac, t));
            S = S.sum((Object)s.multiply((GenPolynomial<GcdRingElem>)((Object)mo)));
            T = T.sum((Object)t.multiply((GenPolynomial<Object>)((Object)mo)));
            Si = PolyUtil.integerFromModularCoefficients(ifac, S);
            Ti = PolyUtil.integerFromModularCoefficients(ifac, T);
            A = PolyUtil.fromIntegerCoefficients(mfac, Ai);
            B = PolyUtil.fromIntegerCoefficients(mfac, Bi);
            ++i;
        }
        GenPolynomial[] rel = new GenPolynomial[]{S, T};
        return rel;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> GenPolynomial<MOD>[] liftExtendedEuclidean(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long k) throws NoLiftingException {
        BigInteger p;
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = A.egcd(B);
        if (!gst[0].isONE()) {
            throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
        }
        GenPolynomial<Object> S = gst[1];
        GenPolynomial<Object> T = gst[2];
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        MonoidElem one = ifac.getONE();
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<RingElem<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        GenPolynomial<RingElem<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(ifac, T);
        ModularRingFactory mcfac = (ModularRingFactory)fac.coFac;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        int i = 0;
        while ((long)i < k) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> e = ((GenPolynomial)one).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            if (e.isZERO()) {
                logger.info((Object)"leaving on zero error");
                break;
            }
            e = e.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)modul));
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(fac, e);
            GenPolynomial<GenPolynomial<MOD>> s = S.multiply((Object)c);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>> t = T.multiply((Object)c);
            GenPolynomial<GenPolynomial<C>>[] QR = s.quotientRemainder(B);
            GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> q = QR[0];
            s = QR[1];
            t = t.sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply((GenPolynomial<GenPolynomial<MOD>>)A));
            GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            GenPolynomial<BigInteger> ti = PolyUtil.integerFromModularCoefficients(ifac, t);
            Si = Si.sum((BigInteger)((Object)si.multiply(modul)));
            Ti = Ti.sum((BigInteger)((Object)ti.multiply(modul)));
            modul = modul.multiply(p);
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        mfac = new GenPolynomialRing(mcfac, fac);
        S = PolyUtil.fromIntegerCoefficients(mfac, Si);
        T = PolyUtil.fromIntegerCoefficients(mfac, Ti);
        GenPolynomial[] rel = new GenPolynomial[]{S, T};
        return rel;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftExtendedEuclidean(List<GenPolynomial<MOD>> A, long k) throws NoLiftingException {
        if (A == null || A.size() == 0) {
            throw new IllegalArgumentException("A must be non null and non empty");
        }
        GenPolynomialRing fac = A.get((int)0).ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        int r = A.size();
        ArrayList<AbelianGroupElem> Q = new ArrayList<AbelianGroupElem>(r);
        int i = 0;
        while (i < r) {
            Q.add(zero);
            ++i;
        }
        Q.set(r - 2, A.get(r - 1));
        int j = r - 3;
        while (j >= 0) {
            GenPolynomial<GenPolynomial> q = A.get(j + 1).multiply((MOD)((GenPolynomial)Q.get(j + 1)));
            Q.set(j, q);
            --j;
        }
        ArrayList<AbelianGroupElem> B = new ArrayList<AbelianGroupElem>(r + 1);
        ArrayList<GenPolynomial<MOD>> lift = new ArrayList<GenPolynomial<MOD>>(r);
        int i2 = 0;
        while (i2 < r) {
            B.add(zero);
            lift.add((GenPolynomial<MOD>)zero);
            ++i2;
        }
        GenPolynomial<MOD> one = fac.getONE();
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        B.add(0, one);
        GenPolynomial<MOD> b = one;
        int j2 = 0;
        while (j2 < r - 1) {
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant((GenPolynomial)Q.get(j2), A.get(j2), (GenPolynomial)B.get(j2), k);
            b = S.get(0);
            GenPolynomial bb = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, b));
            B.set(j2 + 1, bb);
            lift.set(j2, S.get(1));
            if (debug) {
                logger.info((Object)("lift(" + j2 + ") = " + lift.get(j2)));
            }
            ++j2;
        }
        lift.set(r - 1, b);
        if (debug) {
            logger.info((Object)("lift(" + (r - 1) + ") = " + b));
        }
        return lift;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> C, long k) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        int i = 0;
        while (i < 2) {
            sol.add((GenPolynomial<MOD>)zero);
            ++i;
        }
        for (Monomial<MOD> m : C) {
            long e = m.e.getVal(0);
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant(A, B, e, k);
            GcdRingElem a = (GcdRingElem)m.c;
            fac = S.get((int)0).ring;
            a = (GcdRingElem)fac.coFac.fromInteger(((Modular)((Object)a)).getSymmetricInteger().getVal());
            int i2 = 0;
            for (GenPolynomial<Object> d : S) {
                d = d.multiply((MOD)a);
                d = ((GenPolynomial)sol.get(i2)).sum(d);
                sol.set(i2++, d);
            }
        }
        if (debug) {
            GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
            A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
            B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
            C = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, C));
            GenPolynomial<GenPolynomial<GenPolynomial>> y = B.multiply((Object)((GenPolynomial)sol.get(0))).sum((GenPolynomial)A.multiply((Object)((GenPolynomial)sol.get(1))));
            if (!y.equals(C)) {
                System.out.println("A = " + A + ", B = " + B);
                System.out.println("s1 = " + sol.get(0) + ", s2 = " + sol.get(1));
                System.out.println("A*r1 + B*r2 = " + y + " : " + fac.coFac);
            }
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long e, long k) throws NoLiftingException {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>> y;
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        GenPolynomial<MOD>[] lee = HenselUtil.liftExtendedEuclidean(B, A, k);
        GenPolynomial<MOD> s1 = lee[0];
        GenPolynomial<MOD> s2 = lee[1];
        fac = s1.ring;
        A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        GenPolynomial xe = fac.univariate(0, e);
        GenPolynomial<GenPolynomial<Object>> q = s1.multiply((MOD)xe);
        GenPolynomial<GenPolynomial<C>>[] QR = q.quotientRemainder(A);
        q = QR[0];
        GenPolynomial r1 = QR[1];
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> r2 = s2.multiply((MOD)xe).sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply(B));
        sol.add(r1);
        sol.add(r2);
        if (debug && !(y = B.multiply((Object)r1).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>>>)A.multiply((Object)r2))).equals(xe)) {
            System.out.println("A = " + A + ", B = " + B);
            System.out.println("r1 = " + r1 + ", r2 = " + r2);
            System.out.println("A*r1 + B*r2 = " + y);
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isExtendedEuclideanLift(List<GenPolynomial<MOD>> A, List<GenPolynomial<MOD>> S) {
        GenPolynomialRing fac = A.get((int)0).ring;
        ArrayList<GenPolynomial<GenPolynomial<MOD>>> B = new ArrayList<GenPolynomial<GenPolynomial<MOD>>>(A.size());
        int i = 0;
        for (GenPolynomial<MOD> ai : A) {
            GenPolynomial<GenPolynomial<MOD>> b = fac.getONE();
            int j = 0;
            for (GenPolynomial<MOD> aj : A) {
                if (i != j) {
                    b = b.multiply(aj);
                }
                ++j;
            }
            B.add(b);
            ++i;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> t = fac.getZERO();
        i = 0;
        for (GenPolynomial genPolynomial : B) {
            GenPolynomial<GenPolynomial<MOD>> s = genPolynomial.multiply(S.get(i++));
            t = t.sum(s);
        }
        if (!t.isONE()) {
            System.out.println("no ee lift!");
            System.out.println("A = " + A);
            System.out.println("B = " + B);
            System.out.println("S = " + S);
            System.out.println("t = " + t);
            return false;
        }
        return true;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> C, List<GenPolynomial<MOD>> F2, long k) throws NoLiftingException {
        BigInteger p;
        if (C == null || C.isZERO() || F2 == null || F2.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> lift = new ArrayList<GenPolynomial<MOD>>(F2.size());
        GenPolynomialRing pfac = F2.get((int)0).ring;
        RingFactory pcfac = pfac.coFac;
        ModularRingFactory PF = (ModularRingFactory)pcfac;
        BigInteger P = PF.getIntegerModul();
        int n = F2.size();
        if (n == 1) {
            GenPolynomial<Object> f = F2.get(0);
            Iterable<ModLong> mcfac = ModLongRing.MAX_LONG.compareTo(P.getVal()) > 0 ? new ModLongRing(P.getVal()) : new ModIntegerRing(P.getVal());
            GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)mcfac), fac);
            f = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, f));
            lift.add(f);
            return lift;
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        MonoidElem one = ifac.getONE();
        List<GenPolynomial<BigInteger>> Fi = PolyUtil.integerFromModularCoefficients(ifac, F2);
        List S = HenselUtil.liftExtendedEuclidean(F2, k + 1L);
        if (debug) {
            logger.info((Object)("EE lift = " + S));
            List<GenPolynomial<MOD>> Sx = PolyUtil.fromIntegerCoefficients(pfac, PolyUtil.integerFromModularCoefficients(ifac, S));
            try {
                boolean il = HenselUtil.isExtendedEuclideanLift(F2, Sx);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        List<GenPolynomial<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        ModularRingFactory mcfac = PF;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        List Sp = PolyUtil.fromIntegerCoefficients(mfac, Si);
        int i = 0;
        while ((long)i < k) {
            GenPolynomial<RingElem<BigInteger>> e = fac.getONE();
            for (GenPolynomial<BigInteger> fi : Fi) {
                e = e.multiply((RingElem<BigInteger>)fi);
            }
            if ((e = C.subtract((BigInteger)((Object)e))).isZERO()) {
                logger.info((Object)"leaving on zero error");
                break;
            }
            try {
                e = e.divide(modul);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(mfac, e);
            ArrayList s = new ArrayList(S.size());
            int j = 0;
            for (GenPolynomial genPolynomial : Sp) {
                GenPolynomial<GenPolynomial<MOD>> genPolynomial2 = genPolynomial.multiply(c);
                GenPolynomial genPolynomial3 = genPolynomial2.remainder((GenPolynomial<GenPolynomial<MOD>>)F2.get(j++));
                s.add(genPolynomial3);
            }
            List<GenPolynomial<BigInteger>> list = PolyUtil.integerFromModularCoefficients(ifac, s);
            ArrayList<GenPolynomial<BigInteger>> Fii = new ArrayList<GenPolynomial<BigInteger>>(F2.size());
            j = 0;
            for (GenPolynomial<RingElem<BigInteger>> f : Fi) {
                f = f.sum((BigInteger)((Object)list.get(j++).multiply(modul)));
                Fii.add(f);
            }
            Fi = Fii;
            modul = modul.multiply(p);
            if ((long)i >= k - 1L) {
                logger.info((Object)("e != 0 for k = " + k));
            }
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        mfac = new GenPolynomialRing(mcfac, fac);
        lift = PolyUtil.fromIntegerCoefficients(mfac, Fi);
        return lift;
    }
}

