/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HenselUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)HenselUtilTest.suite());
        ComputerThreads.terminate();
    }

    public HenselUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(HenselUtilTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static java.math.BigInteger getPrime1() {
        long prime = 2L;
        int i = 1;
        while (i < 60) {
            prime *= 2L;
            ++i;
        }
        return new java.math.BigInteger("" + (prime -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        return new java.math.BigInteger("" + (prime -= 35L));
    }

    public void testHenselLifting() {
        BigInteger m;
        java.math.BigInteger p = HenselUtilTest.getPrime1();
        BigInteger mi = m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(mi, 1, this.to);
        int i = 1;
        while (i < 3) {
            this.a = this.dfac.random(this.kl + 70 * i, this.ll, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 2L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(pfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(pfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector())) {
                        GenPolynomial<ModInteger> bp1;
                        GenPolynomial<ModInteger> ap1;
                        GenPolynomial<ModInteger>[] egcd;
                        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(pfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector()) && (egcd = (ap1 = ap).egcd(bp1 = bp))[0].isONE()) {
                            BigInteger bn;
                            GenPolynomial<ModInteger> sp = egcd[1];
                            GenPolynomial<ModInteger> tp = egcd[2];
                            BigInteger an = this.a.maxNorm();
                            mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            try {
                                HenselApprox<ModInteger> lift = HenselUtil.liftHensel(this.c, mi, ap, bp, sp, tp);
                                GenPolynomial<BigInteger> a1 = lift.A;
                                GenPolynomial<BigInteger> b1 = lift.B;
                                GenPolynomial<GenPolynomial<BigInteger>> c1 = a1.multiply((BigInteger)((Object)b1));
                                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, c1);
                            }
                            catch (NoLiftingException e) {
                                HenselUtilTest.fail((String)("" + e));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselLiftingGcd() {
        BigInteger m;
        java.math.BigInteger p = new java.math.BigInteger("19");
        BigInteger mi = m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(mi, 1, this.to);
        int i = 1;
        while (i < 3) {
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 2L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(pfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(pfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector())) {
                        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(pfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector())) {
                            BigInteger bn;
                            BigInteger an = this.a.maxNorm();
                            mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            long tq = System.currentTimeMillis();
                            try {
                                HenselApprox<ModInteger> lift = HenselUtil.liftHensel(this.c, mi, ap, bp);
                                tq = System.currentTimeMillis() - tq;
                                GenPolynomial<BigInteger> a1 = lift.A;
                                GenPolynomial<BigInteger> b1 = lift.B;
                                GenPolynomial<GenPolynomial<BigInteger>> c1 = a1.multiply((BigInteger)((Object)b1));
                                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, c1);
                            }
                            catch (NoLiftingException noLiftingException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselQuadraticLifting() {
        BigInteger m;
        java.math.BigInteger p = new java.math.BigInteger("19");
        BigInteger mi = m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(mi, pfac);
        int i = 1;
        while (i < 3) {
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 2L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(pfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(pfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector())) {
                        GenPolynomial<ModInteger> bp1;
                        GenPolynomial<ModInteger> ap1;
                        GenPolynomial<ModInteger>[] egcd;
                        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(pfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector()) && (egcd = (ap1 = ap).egcd(bp1 = bp))[0].isONE()) {
                            BigInteger bn;
                            GenPolynomial<ModInteger> sp = egcd[1];
                            GenPolynomial<ModInteger> tp = egcd[2];
                            BigInteger an = this.a.maxNorm();
                            mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            long tq = System.currentTimeMillis();
                            try {
                                HenselApprox<ModInteger> lift = HenselUtil.liftHenselQuadratic(this.c, mi, ap, bp, sp, tp);
                                tq = System.currentTimeMillis() - tq;
                                GenPolynomial<BigInteger> a1 = lift.A;
                                GenPolynomial<BigInteger> b1 = lift.B;
                                GenPolynomial<GenPolynomial<BigInteger>> c1 = a1.multiply((BigInteger)((Object)b1));
                                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, c1);
                            }
                            catch (NoLiftingException e) {
                                HenselUtilTest.fail((String)("" + e));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselQuadraticLiftingGcd() {
        BigInteger m;
        java.math.BigInteger p = new java.math.BigInteger("19");
        BigInteger mi = m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> pfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(mi, pfac);
        int i = 1;
        while (i < 3) {
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 2L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(pfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(pfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector())) {
                        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(pfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector())) {
                            BigInteger bn;
                            BigInteger an = this.a.maxNorm();
                            mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            long tq = System.currentTimeMillis();
                            try {
                                HenselApprox<ModInteger> lift = HenselUtil.liftHenselQuadratic(this.c, mi, ap, bp);
                                tq = System.currentTimeMillis() - tq;
                                GenPolynomial<BigInteger> a1 = lift.A;
                                GenPolynomial<BigInteger> b1 = lift.B;
                                GenPolynomial<GenPolynomial<BigInteger>> c1 = a1.multiply((BigInteger)((Object)b1));
                                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, c1);
                            }
                            catch (NoLiftingException noLiftingException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselLiftingEgcd() {
        java.math.BigInteger p = new java.math.BigInteger("5");
        BigInteger m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(m, mfac);
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getProxy(m);
        int i = 1;
        while (i < 2) {
            this.a = this.dfac.random(this.kl + 3 * i, this.ll + 1, this.el + 1, this.q).abs();
            this.b = this.dfac.random(this.kl + 3 * i, this.ll + 1, this.el + 5, this.q).abs();
            this.d = ufd.baseGcd(this.a, this.b);
            if (!this.d.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.d);
                this.b = PolyUtil.basePseudoDivide(this.b, this.d);
            }
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 2L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(mfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> dp;
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(mfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector()) && (dp = ap.gcd(bp)).isONE()) {
                        this.c = this.a.multiply((BigInteger)((Object)this.b));
                        GenPolynomial<RingElem<ModInteger>> cp = PolyUtil.fromIntegerCoefficients(mfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector())) {
                            BigInteger bn;
                            BigInteger an = this.a.maxNorm();
                            BigInteger mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            long k = 1L;
                            BigInteger pi = m;
                            while (pi.compareTo(mi) < 0) {
                                ++k;
                                pi = pi.multiply(m);
                            }
                            long tq = System.currentTimeMillis();
                            try {
                                GenPolynomial<ModInteger>[] lift = HenselUtil.liftExtendedEuclidean(ap, bp, k);
                                tq = System.currentTimeMillis() - tq;
                                GenPolynomial<ModInteger> s = lift[0];
                                GenPolynomial<ModInteger> t = lift[1];
                                ModularRingFactory mcfac = (ModularRingFactory)s.ring.coFac;
                                GenPolynomialRing mfac1 = new GenPolynomialRing(mcfac, mfac);
                                ap = PolyUtil.fromIntegerCoefficients(mfac1, PolyUtil.integerFromModularCoefficients(this.dfac, ap));
                                bp = PolyUtil.fromIntegerCoefficients(mfac1, PolyUtil.integerFromModularCoefficients(this.dfac, bp));
                                cp = s.multiply((ModInteger)((Object)ap)).sum((GenPolynomial<ModInteger>)t.multiply((ModInteger)((Object)bp)));
                                HenselUtilTest.assertTrue((String)("lift(s a + t b mod p^k) = 1: " + cp), (boolean)cp.isONE());
                            }
                            catch (NoLiftingException e) {
                                HenselUtilTest.fail((String)("" + e));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselLiftingEgcdList() {
        java.math.BigInteger p = new java.math.BigInteger("19");
        BigInteger m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(m, mfac);
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getProxy(m);
        int i = 1;
        while (i < 2) {
            this.a = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 1, this.q).abs();
            this.b = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 5, this.q).abs();
            this.e = ufd.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) >= 1L && this.b.degree(0) >= 1L) {
                GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(mfac, this.a);
                if (this.a.degreeVector().equals(ap.degreeVector())) {
                    GenPolynomial<ModInteger> ep;
                    GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(mfac, this.b);
                    if (this.b.degreeVector().equals(bp.degreeVector()) && (ep = ap.gcd(bp)).isONE()) {
                        this.d = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 4, this.q).abs();
                        this.e = ufd.baseGcd(this.a, this.d);
                        if (!this.e.isONE()) {
                            this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                            this.d = PolyUtil.basePseudoDivide(this.d, this.e);
                        }
                        this.e = ufd.baseGcd(this.b, this.d);
                        if (!this.e.isONE()) {
                            this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                            this.d = PolyUtil.basePseudoDivide(this.d, this.e);
                        }
                        if (this.d.degree(0) >= 1L) {
                            GenPolynomial<ModInteger> dp = PolyUtil.fromIntegerCoefficients(mfac, this.d);
                            if (this.d.degreeVector().equals(dp.degreeVector())) {
                                this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
                                GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(mfac, this.c);
                                if (this.c.degreeVector().equals(cp.degreeVector())) {
                                    BigInteger dn;
                                    BigInteger bn;
                                    BigInteger an = this.a.maxNorm();
                                    BigInteger mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                                    BigInteger cn = this.c.maxNorm();
                                    if (cn.compareTo(mi) > 0) {
                                        mi = cn;
                                    }
                                    if ((dn = this.d.maxNorm()).compareTo(mi) > 0) {
                                        mi = dn;
                                    }
                                    long k = 1L;
                                    BigInteger pi = m;
                                    while (pi.compareTo(mi) < 0) {
                                        ++k;
                                        pi = pi.multiply(m);
                                    }
                                    ArrayList A = new ArrayList();
                                    ArrayList As = new ArrayList();
                                    A.add(ap);
                                    A.add(bp);
                                    A.add(dp);
                                    ArrayList A2 = new ArrayList();
                                    ArrayList As2 = new ArrayList();
                                    long tq = System.currentTimeMillis();
                                    try {
                                        A2.add(ap);
                                        A2.add(bp);
                                        GenPolynomial<ModInteger>[] L = HenselUtil.liftExtendedEuclidean(ap, bp, k);
                                        List lift = HenselUtil.liftExtendedEuclidean(A, k);
                                        tq = System.currentTimeMillis() - tq;
                                        As = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(this.dfac, lift));
                                        boolean il = HenselUtil.isExtendedEuclideanLift(A, As);
                                        HenselUtilTest.assertTrue((String)"lift(s0,s1,s2) mod p^k) = 1: ", (boolean)il);
                                        As2.add(L[1]);
                                        As2.add(L[0]);
                                        As2 = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(this.dfac, As2));
                                        il = HenselUtil.isExtendedEuclideanLift(A2, As2);
                                        HenselUtilTest.assertTrue((String)"lift(s a + t b mod p^k) = 1: ", (boolean)il);
                                    }
                                    catch (NoLiftingException noLiftingException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void testHenselLiftingList() {
        java.math.BigInteger p = new java.math.BigInteger("268435399");
        BigInteger m = new BigInteger(p);
        ModIntegerRing pm = new ModIntegerRing(p, true);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(m, mfac);
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getProxy(m);
        BigInteger one = m.getONE();
        int i = 1;
        while (i < 2) {
            ExpVector e;
            this.a = this.dfac.parse("(x^3 + 20 x^2 - 313131)");
            this.b = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 5, this.q).abs();
            if (!this.a.leadingBaseCoefficient().isUnit()) {
                e = this.a.leadingExpVector();
                this.a.doPutToMap(e, one);
            }
            if (!this.b.leadingBaseCoefficient().isUnit()) {
                e = this.b.leadingExpVector();
                this.b.doPutToMap(e, one);
            }
            this.e = ufd.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) < 1L) {
                this.a = this.dfac.parse("(x^3 + 20 x^2 - 313131)");
            }
            if (this.b.degree(0) < 1L) {
                this.b = this.dfac.parse("(x^4 + 23 x^3 - 32)");
            }
            GenPolynomial<ModInteger> ap = PolyUtil.fromIntegerCoefficients(mfac, this.a);
            if (this.a.degreeVector().equals(ap.degreeVector())) {
                GenPolynomial<ModInteger> ep;
                GenPolynomial<ModInteger> bp = PolyUtil.fromIntegerCoefficients(mfac, this.b);
                if (this.b.degreeVector().equals(bp.degreeVector()) && (ep = ap.gcd(bp)).isONE()) {
                    this.d = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 4, this.q).abs();
                    if (!this.d.leadingBaseCoefficient().isUnit()) {
                        e = this.d.leadingExpVector();
                        this.d.doPutToMap(e, one);
                    }
                    this.e = ufd.baseGcd(this.a, this.d);
                    if (!this.e.isONE()) {
                        this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                        this.d = PolyUtil.basePseudoDivide(this.d, this.e);
                    }
                    this.e = ufd.baseGcd(this.b, this.d);
                    if (!this.e.isONE()) {
                        this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                        this.d = PolyUtil.basePseudoDivide(this.d, this.e);
                    }
                    if (this.d.degree(0) < 1L) {
                        this.d = this.dfac.parse("(x^2 + 22 x - 33)");
                    }
                    GenPolynomial<ModInteger> dp = PolyUtil.fromIntegerCoefficients(mfac, this.d);
                    if (this.d.degreeVector().equals(dp.degreeVector())) {
                        this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
                        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(mfac, this.c);
                        if (this.c.degreeVector().equals(cp.degreeVector())) {
                            BigInteger dn;
                            BigInteger bn;
                            BigInteger an = this.a.maxNorm();
                            BigInteger mi = an.compareTo(bn = this.b.maxNorm()) > 0 ? an : bn;
                            BigInteger cn = this.c.maxNorm();
                            if (cn.compareTo(mi) > 0) {
                                mi = cn;
                            }
                            if ((dn = this.d.maxNorm()).compareTo(mi) > 0) {
                                mi = dn;
                            }
                            long k = 1L;
                            BigInteger pi = m;
                            while (pi.compareTo(mi) < 0) {
                                ++k;
                                pi = pi.multiply(m);
                            }
                            ArrayList A = new ArrayList();
                            ArrayList As = new ArrayList();
                            A.add(ap);
                            A.add(bp);
                            A.add(dp);
                            A = PolyUtil.monic(A);
                            long tq = System.currentTimeMillis();
                            try {
                                List lift = HenselUtil.liftHenselMonic(this.c, A, k);
                                tq = System.currentTimeMillis() - tq;
                                List<GenPolynomial<BigInteger>> L = PolyUtil.integerFromModularCoefficients(this.dfac, lift);
                                boolean ih = HenselUtil.isHenselLift(this.c, m, pi, L);
                                HenselUtilTest.assertTrue((String)("prod(lift(L)) = c: " + this.c), (boolean)ih);
                            }
                            catch (NoLiftingException noLiftingException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }
}

