/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.PolyUfdUtil;
import java.math.BigInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyUfdUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<edu.jas.arith.BigInteger> dfac;
    GenPolynomialRing<edu.jas.arith.BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<edu.jas.arith.BigInteger>> rfac;
    edu.jas.arith.BigInteger ai;
    edu.jas.arith.BigInteger bi;
    edu.jas.arith.BigInteger ci;
    edu.jas.arith.BigInteger di;
    edu.jas.arith.BigInteger ei;
    GenPolynomial<edu.jas.arith.BigInteger> a;
    GenPolynomial<edu.jas.arith.BigInteger> b;
    GenPolynomial<edu.jas.arith.BigInteger> c;
    GenPolynomial<edu.jas.arith.BigInteger> d;
    GenPolynomial<edu.jas.arith.BigInteger> e;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)PolyUfdUtilTest.suite());
        ComputerThreads.terminate();
    }

    public PolyUfdUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PolyUfdUtilTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    protected static BigInteger getPrime1() {
        long prime = 2L;
        int i = 1;
        while (i < 60) {
            prime *= 2L;
            ++i;
        }
        return new BigInteger("" + (prime -= 93L));
    }

    protected static BigInteger getPrime2() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        return new BigInteger("" + (prime -= 35L));
    }

    public void testKroneckerSubstitution() {
        int i = 0;
        while (i < 10) {
            this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 5, this.q);
            long d = this.a.degree() + 1L;
            this.b = PolyUfdUtil.substituteKronecker(this.a, d);
            this.c = PolyUfdUtil.backSubstituteKronecker(this.dfac, this.b, d);
            this.e = this.a.subtract((edu.jas.arith.BigInteger)((Object)this.c));
            PolyUfdUtilTest.assertTrue((String)"back(subst(a)) = a", (boolean)this.e.isZERO());
            ++i;
        }
    }
}

