/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class QuotientIntTest
extends TestCase {
    QuotientRing<BigInteger> efac;
    GenPolynomialRing<BigInteger> mfac;
    Quotient<BigInteger> a;
    Quotient<BigInteger> b;
    Quotient<BigInteger> c;
    Quotient<BigInteger> d;
    Quotient<BigInteger> e;
    int rl = 3;
    int kl = 5;
    int ll = 4;
    int el = 2;
    float q = 0.4f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)QuotientIntTest.suite());
    }

    public QuotientIntTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QuotientIntTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigInteger cfac = new BigInteger(1L);
        TermOrder to = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigInteger>(cfac, this.rl, to);
        this.efac = new QuotientRing<BigInteger>(this.mfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.efac.getONE();
        QuotientIntTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        QuotientIntTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientIntTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.efac.getZERO();
        QuotientIntTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        QuotientIntTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotientIntTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.efac.random(this.kl * (i + 1), this.ll + 2 + 2 * i, this.el, this.q);
            if (!this.a.isZERO() && !this.a.isONE()) {
                QuotientIntTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
                QuotientIntTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                QuotientIntTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        QuotientIntTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientIntTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        QuotientIntTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Quotient<BigInteger>)this.efac.getZERO());
        this.d = this.a.subtract((Quotient<BigInteger>)this.efac.getZERO());
        QuotientIntTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.efac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.efac.getZERO()).subtract(this.a.negate());
        QuotientIntTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        this.d = this.a.multiply((BigInteger)((Object)this.b));
        if (!this.a.isZERO() && !this.b.isZERO()) {
            QuotientIntTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
            QuotientIntTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        }
        this.e = this.d.subtract(this.c);
        QuotientIntTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        QuotientIntTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        QuotientIntTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigInteger)((Object)this.b.multiply((BigInteger)((Object)this.c))));
        this.e = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.c);
        QuotientIntTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuotientIntTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigInteger)this.efac.getONE());
        this.d = ((Quotient)this.efac.getONE()).multiply(this.a);
        QuotientIntTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigInteger)((Object)this.a));
            QuotientIntTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testParse() {
        this.a = this.efac.random(this.kl * 2, this.ll * 2, this.el * 2, this.q * 2.0f);
        PrettyPrint.setPretty();
        String p = this.a.toString();
        this.b = this.efac.parse(p);
        QuotientIntTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }
}

