/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Power;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeAlgModTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    long p = 7L;
    long qp;
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    ModIntegerRing mfac;
    String[] alpha;
    GenPolynomialRing<ModInteger> mpfac;
    GenPolynomial<ModInteger> agen;
    AlgebraicNumberRing<ModInteger> fac;
    GreatestCommonDivisorAbstract<AlgebraicNumber<ModInteger>> ufd;
    SquarefreeFiniteFieldCharP<AlgebraicNumber<ModInteger>> sqf;
    GenPolynomialRing<AlgebraicNumber<ModInteger>> dfac;
    GenPolynomial<AlgebraicNumber<ModInteger>> a;
    GenPolynomial<AlgebraicNumber<ModInteger>> b;
    GenPolynomial<AlgebraicNumber<ModInteger>> c;
    GenPolynomial<AlgebraicNumber<ModInteger>> d;
    GenPolynomial<AlgebraicNumber<ModInteger>> e;
    GenPolynomialRing<AlgebraicNumber<ModInteger>> cfac;
    GenPolynomialRing<GenPolynomial<AlgebraicNumber<ModInteger>>> rfac;
    GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>> ar;
    GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>> br;
    GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>> cr;
    GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>> dr;
    GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>> er;

    public static void main(String[] args) {
        TestRunner.run((Test)SquarefreeAlgModTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeAlgModTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SquarefreeAlgModTest.class);
        return suite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.mfac = new ModIntegerRing(this.p);
        this.alpha = new String[]{"alpha"};
        this.mpfac = new GenPolynomialRing<ModInteger>(this.mfac, 1, this.to, this.alpha);
        this.agen = this.mpfac.univariate(0, 2L);
        this.agen = this.agen.sum((ModInteger)this.mpfac.getONE());
        this.fac = new AlgebraicNumberRing<ModInteger>(this.agen, true);
        this.qp = 1L;
        int i = 0;
        while ((long)i < this.agen.degree(0)) {
            this.qp *= this.p;
            ++i;
        }
        this.ufd = GCDFactory.getProxy(this.fac);
        this.sqf = new SquarefreeFiniteFieldCharP<ModInteger>(this.fac);
        SquarefreeAbstract<AlgebraicNumber<ModInteger>> sqff = SquarefreeFactory.getImplementation(this.fac);
        SquarefreeAlgModTest.assertEquals((String)"sqf == sqff ", this.sqf.getClass(), sqff.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.cr).multiply(this.br).multiply(this.br);
        SortedMap sfactors = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.squarefreeFactors((AlgebraicNumber<ModInteger>)((Object)this.d));
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testBaseSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, p);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el + 1, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, p);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testBaseSquarefreeCharRoot2() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, this.qp);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactorsCharRoot2() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, this.qp);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, this.el, this.q);
        this.br = this.rfac.random(this.kl, 3, this.el, this.q);
        this.cr = this.rfac.random(this.kl, 3, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.er = Power.positivePower(this.br, p);
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.ar).multiply(this.er).multiply(this.cr);
        this.cr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.br).multiply(this.cr);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.er = Power.positivePower(this.br, p);
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<ModInteger>>)this.ar).multiply(this.er).multiply(this.cr);
        SortedMap sfactors = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 3, this.q);
        this.b = this.dfac.random(this.kl, 3, 3, this.q);
        this.c = this.dfac.random(this.kl, 3, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, p);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeAlgModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 3, this.q);
        this.b = this.dfac.random(this.kl, 3, 3, this.q);
        this.c = this.dfac.random(this.kl, 3, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.e = Power.positivePower(this.b, p);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).multiply(this.e).multiply(this.c);
        SortedMap sfactors = this.sqf.squarefreeFactors((AlgebraicNumber<ModInteger>)((Object)this.d));
        SquarefreeAlgModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }
}

