/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SquarefreeAlgQuotModTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    int rl = 3;
    int kl = 1;
    int ll = 3;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    ModIntegerRing mfac;
    String[] alpha;
    String[] beta;
    GenPolynomialRing<ModInteger> mpfac;
    GenPolynomial<ModInteger> agen;
    QuotientRing<ModInteger> fac;
    AlgebraicNumberRing<Quotient<ModInteger>> afac;
    SquarefreeInfiniteFieldCharP<ModInteger> sqf;
    SquarefreeInfiniteAlgebraicFieldCharP<Quotient<ModInteger>> asqf;
    GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>> dfac;
    GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>> a;
    GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>> b;
    GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>> c;
    GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>> d;
    GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>> e;
    GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>> cfac;
    GenPolynomialRing<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> rfac;
    GenPolynomial<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> ar;
    GenPolynomial<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> br;
    GenPolynomial<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> cr;
    GenPolynomial<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> dr;
    GenPolynomial<GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>> er;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SquarefreeAlgQuotModTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeAlgQuotModTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SquarefreeAlgQuotModTest.class);
        return suite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.mfac = new ModIntegerRing(7L);
        this.alpha = new String[]{"u"};
        this.beta = new String[]{"b"};
        this.mpfac = new GenPolynomialRing<ModInteger>(this.mfac, 1, this.to, this.alpha);
        this.fac = new QuotientRing<ModInteger>(this.mpfac);
        GenPolynomialRing<ModInteger> qpfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.beta);
        GenPolynomial<ModInteger> an = qpfac.univariate(0, 2L);
        an = an.subtract((ModInteger)qpfac.fromInteger(3L));
        this.afac = new AlgebraicNumberRing<ModInteger>(an, true);
        this.sqf = new SquarefreeInfiniteFieldCharP(this.fac);
        this.asqf = new SquarefreeInfiniteAlgebraicFieldCharP<ModInteger>((RingFactory<AlgebraicNumber<ModInteger>>)this.afac);
        SquarefreeAbstract<AlgebraicNumber<Quotient<ModInteger>>> sqff = SquarefreeFactory.getImplementation(this.afac);
        SquarefreeAlgQuotModTest.assertEquals((String)"asqf == sqff ", this.asqf.getClass(), sqff.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 0, this.ll - 1, this.el + 0, this.q);
        this.b = this.dfac.random(this.kl + 0, this.ll, this.el + 1, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.b)).multiply(this.c);
        this.c = this.asqf.baseSquarefreePart(this.c);
        this.d = this.asqf.baseSquarefreePart(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.asqf.isSquarefree(this.c));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.asqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 0, this.ll - 1, this.el + 0, this.q);
        this.b = this.dfac.random(this.kl + 0, this.ll, this.el + 1, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 0, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        int num = 0;
        if (!this.a.isConstant()) {
            ++num;
        }
        if (!this.b.isConstant()) {
            ++num;
        }
        if (!this.c.isConstant()) {
            ++num;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.asqf.baseSquarefreeFactors(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isFactorization(this.d, sfactors));
        SquarefreeAlgQuotModTest.assertTrue((String)("#factors >= " + num), (sfactors.size() >= num ? 1 : 0) != 0);
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)this.br);
        this.cr = this.asqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.asqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.asqf.isRecursiveSquarefree(this.cr));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.asqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 2, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO()) {
            return;
        }
        int num = 0;
        if (!this.ar.isConstant()) {
            ++num;
        }
        if (!this.br.isConstant()) {
            ++num;
        }
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)this.br).multiply(this.br);
        SortedMap sfactors = this.asqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isRecursiveFactorization(this.dr, sfactors));
        SquarefreeAlgQuotModTest.assertTrue((String)("#factors >= " + num), (sfactors.size() >= num ? 1 : 0) != 0);
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll - 1, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.b)).multiply(this.c);
        this.c = this.asqf.squarefreePart(this.c);
        this.d = this.asqf.squarefreePart(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.asqf.isSquarefree(this.d));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.asqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 3, this.q);
        this.b = this.dfac.random(this.kl, 2, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        int num = 0;
        if (!this.a.isConstant()) {
            ++num;
        }
        if (!this.b.isConstant()) {
            ++num;
        }
        if (!this.c.isConstant()) {
            ++num;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.asqf.squarefreeFactors((Quotient<ModInteger>)((Object)this.d));
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isFactorization(this.d, sfactors));
        SquarefreeAlgQuotModTest.assertTrue((String)("#factors >= " + num), (sfactors.size() >= num ? 1 : 0) != 0);
    }

    public void testBaseSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 0, this.ll + 0, this.el + 1, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.c = this.dfac.random(this.kl + 0, this.ll, this.el, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.b)).multiply(this.c);
        this.c = this.asqf.baseSquarefreePart(this.c);
        this.d = this.asqf.baseSquarefreePart(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.asqf.isSquarefree(this.c));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.asqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 1, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        SortedMap sfactors = this.asqf.baseSquarefreeFactors(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.ar = PolyUtil.monic(this.ar);
        this.br = PolyUtil.monic(this.br);
        this.cr = PolyUtil.monic(this.cr);
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)Power.positivePower(this.br, p)).multiply(this.cr);
        this.cr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)this.br).multiply(this.cr);
        this.cr = this.asqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.asqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.asqf.isRecursiveSquarefree(this.cr));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.asqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<AlgebraicNumber<Quotient<ModInteger>>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.ar = PolyUtil.monic(this.ar);
        this.br = PolyUtil.monic(this.br);
        this.cr = PolyUtil.monic(this.cr);
        this.dr = this.ar.multiply((GenPolynomial<AlgebraicNumber<Quotient<ModInteger>>>)Power.positivePower(this.br, p)).multiply(this.cr);
        SortedMap sfactors = this.asqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        this.c = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.b)).multiply(this.c);
        this.c = this.asqf.squarefreePart(this.c);
        this.d = this.asqf.squarefreePart(this.d);
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.asqf.isSquarefree(this.d));
        SquarefreeAlgQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.asqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeAlgQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<Quotient<ModInteger>>(this.afac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((AlgebraicNumber<Quotient<ModInteger>>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        SortedMap sfactors = this.asqf.squarefreeFactors((Quotient<ModInteger>)((Object)this.d));
        SquarefreeAlgQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.asqf.isFactorization(this.d, sfactors));
    }
}

